/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.net;

import de.maxhenkel.camera.ImageTools;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.corelib.net.Message;
import de.maxhenkel.camera.net.MessageImage;
import de.maxhenkel.camera.net.MessageImageUnavailable;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class MessageRequestImage
implements Message<MessageRequestImage> {
    public static ResourceLocation ID = new ResourceLocation("camera", "request_image");
    private UUID imgUUID;

    public MessageRequestImage() {
    }

    public MessageRequestImage(UUID imgUUID) {
        this.imgUUID = imgUUID;
    }

    @Override
    public PacketFlow getExecutingSide() {
        return PacketFlow.SERVERBOUND;
    }

    @Override
    public void executeServerSide(PlayPayloadContext context) {
        Object var3_2 = context.player().orElse(null);
        if (!(var3_2 instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sender = var3_2;
        try {
            byte[] data = ImageTools.toBytes(Main.PACKET_MANAGER.getExistingImage(sender, this.imgUUID));
            context.replyHandler().send((CustomPacketPayload)new MessageImage(this.imgUUID, data));
        }
        catch (IOException e) {
            e.printStackTrace();
            context.replyHandler().send((CustomPacketPayload)new MessageImageUnavailable(this.imgUUID));
        }
    }

    @Override
    public MessageRequestImage fromBytes(FriendlyByteBuf buf) {
        this.imgUUID = buf.readUUID();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeUUID(this.imgUUID);
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }
}

