/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.net;

import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.corelib.net.Message;
import de.maxhenkel.camera.items.CameraItem;
import de.maxhenkel.camera.net.MessageUploadCustomImage;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class MessageRequestUploadCustomImage
implements Message<MessageRequestUploadCustomImage> {
    public static ResourceLocation ID = new ResourceLocation("camera", "request_upload");
    private UUID uuid;

    public MessageRequestUploadCustomImage() {
    }

    public MessageRequestUploadCustomImage(UUID uuid) {
        this.uuid = uuid;
    }

    @Override
    public PacketFlow getExecutingSide() {
        return PacketFlow.SERVERBOUND;
    }

    @Override
    public void executeServerSide(PlayPayloadContext context) {
        Object var3_2 = context.player().orElse(null);
        if (!(var3_2 instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sender = var3_2;
        if (Main.PACKET_MANAGER.canTakeImage(sender.getUUID())) {
            if (CameraItem.consumePaper((Player)sender)) {
                context.replyHandler().send((CustomPacketPayload)new MessageUploadCustomImage(this.uuid));
            } else {
                sender.displayClientMessage((Component)Component.translatable((String)"message.no_consumable"), true);
            }
        } else {
            sender.displayClientMessage((Component)Component.translatable((String)"message.image_cooldown"), true);
        }
    }

    @Override
    public MessageRequestUploadCustomImage fromBytes(FriendlyByteBuf buf) {
        this.uuid = buf.readUUID();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeUUID(this.uuid);
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }
}

