/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.net;

import de.maxhenkel.camera.corelib.net.Message;
import de.maxhenkel.camera.entities.ImageEntity;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class MessageResizeFrame
implements Message<MessageResizeFrame> {
    public static ResourceLocation ID = new ResourceLocation("camera", "resize_frame");
    private UUID uuid;
    private Direction direction;
    private boolean larger;

    public MessageResizeFrame() {
    }

    public MessageResizeFrame(UUID uuid, Direction direction, boolean larger) {
        this.uuid = uuid;
        this.direction = direction;
        this.larger = larger;
    }

    @Override
    public PacketFlow getExecutingSide() {
        return PacketFlow.SERVERBOUND;
    }

    @Override
    public void executeServerSide(PlayPayloadContext context) {
        Object var3_2 = context.player().orElse(null);
        if (!(var3_2 instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sender = var3_2;
        Level level = sender.level();
        if (level instanceof ServerLevel) {
            Entity entity;
            ServerLevel serverLevel = (ServerLevel)level;
            if (sender.getAbilities().mayBuild && (entity = serverLevel.getEntity(this.uuid)) instanceof ImageEntity) {
                ImageEntity image = (ImageEntity)entity;
                image.resize(this.direction, this.larger);
            }
        }
    }

    @Override
    public MessageResizeFrame fromBytes(FriendlyByteBuf buf) {
        this.uuid = buf.readUUID();
        this.direction = Direction.values()[buf.readInt()];
        this.larger = buf.readBoolean();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeUUID(this.uuid);
        buf.writeInt(this.direction.ordinal());
        buf.writeBoolean(this.larger);
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    public static enum Direction {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }
}

