/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.items.ImageItem;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.IShapedRecipe;

public class ImageCloningRecipe
implements CraftingRecipe,
IShapedRecipe<CraftingContainer> {
    private final ItemStack image;
    private final Ingredient paper;

    public ImageCloningRecipe(ItemStack image, Ingredient paper) {
        this.image = image;
        this.paper = paper;
    }

    public int getWidth() {
        return 2;
    }

    public int getHeight() {
        return 2;
    }

    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of((ItemStack[])new ItemStack[]{this.image}), this.paper});
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        return this.craft(inv) != null;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        CraftingResult craft = this.craft(inv);
        if (craft == null) {
            return null;
        }
        return craft.remaining;
    }

    public ItemStack assemble(CraftingContainer container, HolderLookup.Provider provider) {
        CraftingResult craft = this.craft(container);
        if (craft == null) {
            return null;
        }
        return craft.result;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width > 1 && height > 1;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.image;
    }

    public ItemStack getImage() {
        return this.image;
    }

    public Ingredient getPaper() {
        return this.paper;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)Main.IMAGE_CLONING_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return RecipeType.CRAFTING;
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    protected CraftingResult craft(CraftingContainer inv) {
        ItemStack image = null;
        NonNullList remaining = NonNullList.withSize((int)inv.getContainerSize(), (Object)ItemStack.EMPTY);
        int paperSlotIndex = -1;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof ImageItem) {
                if (image != null) {
                    return null;
                }
                image = stack;
                remaining.set(i, (Object)image.copy());
                continue;
            }
            if (!stack.is(Main.IMAGE_PAPER)) continue;
            if (paperSlotIndex >= 0) {
                return null;
            }
            paperSlotIndex = i;
        }
        if (image == null) {
            return null;
        }
        if (paperSlotIndex < 0) {
            return null;
        }
        ItemStack imageOut = image.copy();
        imageOut.setCount(1);
        return new CraftingResult(imageOut, (NonNullList<ItemStack>)remaining);
    }

    private static class CraftingResult {
        public final ItemStack result;
        public final NonNullList<ItemStack> remaining;

        public CraftingResult(ItemStack result, NonNullList<ItemStack> remaining) {
            this.result = result;
            this.remaining = remaining;
        }
    }

    public static class ImageCloningSerializer
    implements RecipeSerializer<ImageCloningRecipe> {
        private static final MapCodec<ImageCloningRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)BuiltInRegistries.ITEM.byNameCodec().xmap(ItemStack::new, ItemStack::getItem).fieldOf("image").forGetter(recipe -> recipe.image), (App)Ingredient.CODEC_NONEMPTY.fieldOf("paper").forGetter(recipe -> recipe.paper)).apply((Applicative)builder, ImageCloningRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, ImageCloningRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, ImageCloningRecipe::getImage, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, ImageCloningRecipe::getPaper, ImageCloningRecipe::new);

        public MapCodec<ImageCloningRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ImageCloningRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

