/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.entities;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import de.maxhenkel.camera.TextureCache;
import de.maxhenkel.camera.entities.ImageEntity;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import org.joml.Matrix4f;

public class ImageRenderer
extends EntityRenderer<ImageEntity> {
    private static final ResourceLocation DEFAULT_IMAGE = new ResourceLocation("camera", "textures/images/default_image.png");
    private static final ResourceLocation EMPTY_IMAGE = new ResourceLocation("camera", "textures/images/empty_image.png");
    private static final ResourceLocation FRAME_SIDE = new ResourceLocation("camera", "textures/images/frame_side.png");
    private static final ResourceLocation FRAME_BACK = new ResourceLocation("camera", "textures/images/frame_back.png");
    private static final float THICKNESS = 0.0625f;
    public static final UUID DEFAULT_IMAGE_UUID = new UUID(0L, 0L);
    private static Minecraft mc;

    public ImageRenderer(EntityRendererProvider.Context context) {
        super(context);
        mc = Minecraft.getInstance();
    }

    public void render(ImageEntity entity, float f1, float f2, PoseStack matrixStack, MultiBufferSource buffer1, int light) {
        int imageLight = LevelRenderer.getLightColor((BlockAndTintGetter)entity.level(), (BlockPos)entity.getCenterPosition());
        ImageRenderer.renderImage(entity.getImageUUID().orElse(null), entity.getFacing(), entity.getFrameWidth(), entity.getFrameHeight(), matrixStack, buffer1, imageLight);
        ImageRenderer.renderBoundingBox(entity, matrixStack, buffer1);
        super.render((Entity)entity, f1, f2, matrixStack, buffer1, light);
    }

    public static void renderImage(UUID imageUUID, Direction facing, float width, float height, PoseStack matrixStack, MultiBufferSource buffer1, int light) {
        float ratioY;
        float ratioX;
        matrixStack.pushPose();
        float imageRatio = 1.0f;
        boolean stretch = true;
        ResourceLocation resourceLocation = EMPTY_IMAGE;
        if (DEFAULT_IMAGE_UUID.equals(imageUUID)) {
            resourceLocation = DEFAULT_IMAGE;
            imageRatio = 1.5f;
            stretch = false;
        } else if (imageUUID != null) {
            ResourceLocation rl = TextureCache.instance().getImage(imageUUID);
            if (rl != null) {
                resourceLocation = rl;
                NativeImage image = TextureCache.instance().getNativeImage(imageUUID);
                imageRatio = (float)image.getWidth() / (float)image.getHeight();
                stretch = false;
            } else {
                resourceLocation = DEFAULT_IMAGE;
                imageRatio = 1.5f;
                stretch = false;
            }
        }
        matrixStack.translate(-0.5, 0.0, -0.5);
        ImageRenderer.rotate(facing, matrixStack);
        float frameRatio = width / height;
        float ratio = imageRatio / frameRatio;
        if (stretch) {
            ratioX = 0.0f;
            ratioY = 0.0f;
        } else {
            if (ratio >= 1.0f) {
                ratioY = (1.0f - 1.0f / ratio) / 2.0f;
                ratioX = 0.0f;
            } else {
                ratioX = (1.0f - ratio) / 2.0f;
                ratioY = 0.0f;
            }
            ratioX *= width;
            ratioY *= height;
        }
        VertexConsumer builderFront = buffer1.getBuffer(RenderType.entityCutout((ResourceLocation)resourceLocation));
        ImageRenderer.vertex(builderFront, matrixStack, 0.0f + ratioX, ratioY, 0.0625f, 0.0f, 1.0f, light);
        ImageRenderer.vertex(builderFront, matrixStack, width - ratioX, ratioY, 0.0625f, 1.0f, 1.0f, light);
        ImageRenderer.vertex(builderFront, matrixStack, width - ratioX, height - ratioY, 0.0625f, 1.0f, 0.0f, light);
        ImageRenderer.vertex(builderFront, matrixStack, ratioX, height - ratioY, 0.0625f, 0.0f, 0.0f, light);
        VertexConsumer builderSide = buffer1.getBuffer(RenderType.entityCutout((ResourceLocation)FRAME_SIDE));
        ImageRenderer.vertex(builderSide, matrixStack, 0.0f + ratioX, 0.0f + ratioY, 0.0f, 1.0f, 0.0f + ratioY, light);
        ImageRenderer.vertex(builderSide, matrixStack, 0.0f + ratioX, 0.0f + ratioY, 0.0625f, 0.9375f, 0.0f + ratioY, light);
        ImageRenderer.vertex(builderSide, matrixStack, 0.0f + ratioX, height - ratioY, 0.0625f, 0.9375f, 1.0f - ratioY, light);
        ImageRenderer.vertex(builderSide, matrixStack, 0.0f + ratioX, height - ratioY, 0.0f, 1.0f, 1.0f - ratioY, light);
        ImageRenderer.vertex(builderSide, matrixStack, width - ratioX, 0.0f + ratioY, 0.0f, 0.0f, 0.0f + ratioY, light);
        ImageRenderer.vertex(builderSide, matrixStack, width - ratioX, height - ratioY, 0.0f, 0.0f, 1.0f - ratioY, light);
        ImageRenderer.vertex(builderSide, matrixStack, width - ratioX, height - ratioY, 0.0625f, 0.0625f, 1.0f - ratioY, light);
        ImageRenderer.vertex(builderSide, matrixStack, width - ratioX, 0.0f + ratioY, 0.0625f, 0.0625f, 0.0f + ratioY, light);
        ImageRenderer.vertex(builderSide, matrixStack, 0.0f + ratioX, height - ratioY, 0.0f, 0.0f + ratioX, 1.0f, light);
        ImageRenderer.vertex(builderSide, matrixStack, 0.0f + ratioX, height - ratioY, 0.0625f, 0.0f + ratioX, 0.9375f, light);
        ImageRenderer.vertex(builderSide, matrixStack, width - ratioX, height - ratioY, 0.0625f, 1.0f - ratioX, 0.9375f, light);
        ImageRenderer.vertex(builderSide, matrixStack, width - ratioX, height - ratioY, 0.0f, 1.0f - ratioX, 1.0f, light);
        ImageRenderer.vertex(builderSide, matrixStack, 0.0f + ratioX, 0.0f + ratioY, 0.0f, 0.0f + ratioX, 0.0f, light);
        ImageRenderer.vertex(builderSide, matrixStack, width - ratioX, 0.0f + ratioY, 0.0f, 1.0f - ratioX, 0.0f, light);
        ImageRenderer.vertex(builderSide, matrixStack, width - ratioX, 0.0f + ratioY, 0.0625f, 1.0f - ratioX, 0.0625f, light);
        ImageRenderer.vertex(builderSide, matrixStack, 0.0f + ratioX, 0.0f + ratioY, 0.0625f, 0.0f + ratioX, 0.0625f, light);
        VertexConsumer builderBack = buffer1.getBuffer(RenderType.entityCutout((ResourceLocation)FRAME_BACK));
        ImageRenderer.vertex(builderBack, matrixStack, width - ratioX, 0.0f + ratioY, 0.0f, 1.0f - ratioX, 0.0f + ratioY, light);
        ImageRenderer.vertex(builderBack, matrixStack, 0.0f + ratioX, 0.0f + ratioY, 0.0f, 0.0f + ratioX, 0.0f + ratioY, light);
        ImageRenderer.vertex(builderBack, matrixStack, 0.0f + ratioX, height - ratioY, 0.0f, 0.0f + ratioX, 1.0f - ratioY, light);
        ImageRenderer.vertex(builderBack, matrixStack, width - ratioX, height - ratioY, 0.0f, 1.0f - ratioX, 1.0f - ratioY, light);
        matrixStack.popPose();
    }

    private static void vertex(VertexConsumer builder, PoseStack matrixStack, float x, float y, float z, float u, float v, int light) {
        PoseStack.Pose entry = matrixStack.last();
        Matrix4f matrix4f = entry.pose();
        builder.vertex(matrix4f, x, y, z).color(255, 255, 255, 255).uv(u, v).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(light).normal(entry, 0.0f, 0.0f, -1.0f).endVertex();
    }

    private static void renderBoundingBox(ImageEntity entity, PoseStack matrixStack, MultiBufferSource buffer) {
        if (!(ImageRenderer.mc.hitResult instanceof EntityHitResult) || ((EntityHitResult)ImageRenderer.mc.hitResult).getEntity() != entity) {
            return;
        }
        if (ImageRenderer.mc.options.hideGui) {
            return;
        }
        matrixStack.pushPose();
        AABB axisalignedbb = entity.getBoundingBox().move(-entity.getX(), -entity.getY(), -entity.getZ());
        LevelRenderer.renderLineBox((PoseStack)matrixStack, (VertexConsumer)buffer.getBuffer(RenderType.lines()), (AABB)axisalignedbb, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
        matrixStack.popPose();
    }

    public static void rotate(Direction facing, PoseStack matrixStack) {
        switch (facing) {
            case NORTH: {
                matrixStack.translate(1.0, 0.0, 1.0);
                matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                break;
            }
            case SOUTH: {
                break;
            }
            case EAST: {
                matrixStack.translate(0.0, 0.0, 1.0);
                matrixStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case WEST: {
                matrixStack.translate(1.0, 0.0, 0.0);
                matrixStack.mulPose(Axis.YP.rotationDegrees(270.0f));
            }
        }
    }

    @Nullable
    public ResourceLocation getTextureLocation(ImageEntity entity) {
        return EMPTY_IMAGE;
    }
}

