/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.gui;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import de.maxhenkel.camera.ImageData;
import de.maxhenkel.camera.TextureCache;
import de.maxhenkel.camera.gui.DummyContainer;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;

public class ImageScreen
extends AbstractContainerScreen<AbstractContainerMenu> {
    public static final ResourceLocation DEFAULT_IMAGE = new ResourceLocation("camera", "textures/images/default_image.png");
    @Nullable
    private UUID imageID;

    public ImageScreen(ItemStack image) {
        super((AbstractContainerMenu)new DummyContainer(), Minecraft.getInstance().player.getInventory(), (Component)Component.translatable((String)"gui.image.title"));
        ImageData imageData = ImageData.fromStack(image);
        if (imageData != null) {
            this.imageID = imageData.getId();
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        this.renderTransparentBackground(guiGraphics);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.imageID == null) {
            return;
        }
        ImageScreen.drawImage(guiGraphics, this.minecraft, this.width, this.height, 100.0f, this.imageID);
    }

    public static void drawImage(GuiGraphics guiGraphics, Minecraft minecraft, int width, int height, float zLevel, UUID uuid) {
        float hnew;
        float wnew;
        guiGraphics.pose().pushPose();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ResourceLocation location = TextureCache.instance().getImage(uuid);
        float imageWidth = 12.0f;
        float imageHeight = 8.0f;
        if (location == null) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)DEFAULT_IMAGE);
        } else {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)location);
            NativeImage image = TextureCache.instance().getNativeImage(uuid);
            imageWidth = image.getWidth();
            imageHeight = image.getHeight();
        }
        BufferBuilder buffer = Tesselator.getInstance().getBuilder();
        buffer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        float scale = 0.8f;
        float ws = (float)width * scale;
        float hs = (float)height * scale;
        float rs = ws / hs;
        float ri = imageWidth / imageHeight;
        if (rs > ri) {
            wnew = imageWidth * hs / imageHeight;
            hnew = hs;
        } else {
            wnew = ws;
            hnew = imageHeight * ws / imageWidth;
        }
        float top = (hs - hnew) / 2.0f;
        float left = (ws - wnew) / 2.0f;
        Matrix4f matrix = guiGraphics.pose().last().pose();
        buffer.vertex(matrix, left += (1.0f - scale) * ws / 2.0f, top += (1.0f - scale) * hs / 2.0f, zLevel).uv(0.0f, 0.0f).endVertex();
        buffer.vertex(matrix, left, top + hnew, zLevel).uv(0.0f, 1.0f).endVertex();
        buffer.vertex(matrix, left + wnew, top + hnew, zLevel).uv(1.0f, 1.0f).endVertex();
        buffer.vertex(matrix, left + wnew, top, zLevel).uv(1.0f, 0.0f).endVertex();
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)buffer.end());
        guiGraphics.pose().popPose();
    }

    protected void renderLabels(GuiGraphics guiGraphics, int x, int y) {
    }
}

