/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.net;

import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.corelib.net.Message;
import de.maxhenkel.camera.items.CameraItem;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class MessageDisableCameraMode
implements Message<MessageDisableCameraMode> {
    public static final CustomPacketPayload.Type<MessageDisableCameraMode> TYPE = new CustomPacketPayload.Type(new ResourceLocation("camera", "disable_camera_mode"));

    @Override
    public PacketFlow getExecutingSide() {
        return PacketFlow.SERVERBOUND;
    }

    @Override
    public void executeServerSide(IPayloadContext context) {
        InteractionHand[] interactionHandArray = context.player();
        if (!(interactionHandArray instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sender = (ServerPlayer)interactionHandArray;
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = sender.getItemInHand(hand);
            if (!stack.getItem().equals(Main.CAMERA.get())) continue;
            ((CameraItem)((Object)Main.CAMERA.get())).setActive(stack, false);
        }
    }

    @Override
    public MessageDisableCameraMode fromBytes(RegistryFriendlyByteBuf buf) {
        return this;
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
    }

    @Override
    public CustomPacketPayload.Type<MessageDisableCameraMode> type() {
        return TYPE;
    }
}

