/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camerautils.config;

import de.maxhenkel.camerautils.CameraUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;

public class Config {
    protected Properties properties;
    protected Path path;

    public Config(Path path) {
        this.path = path;
        this.properties = new Properties();
        try {
            this.load();
        }
        catch (IOException e) {
            CameraUtils.LOGGER.error("Failed to read " + path.getFileName().toString(), (Throwable)e);
            CameraUtils.LOGGER.warn("Using default configuration values");
        }
    }

    public String get(String key) {
        return this.properties.getProperty(key);
    }

    public void set(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void load() throws IOException {
        File file = this.path.toFile();
        if (file.exists()) {
            this.properties.load(new FileInputStream(file));
        }
    }

    private void saveUnthreaded() {
        try {
            File file = this.path.toFile();
            file.getParentFile().mkdirs();
            this.properties.store(new FileWriter(file, false), "");
        }
        catch (IOException e) {
            CameraUtils.LOGGER.error("Failed to save " + this.path.getFileName().toString(), (Throwable)e);
        }
    }

    public void save() {
        new Thread(() -> {
            Config config = this;
            synchronized (config) {
                this.saveUnthreaded();
            }
        }).start();
    }
}

