/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camerautils.config;

import de.maxhenkel.camerautils.config.Config;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public class ConfigBuilder {
    protected List<ConfigEntry<?>> entries = new ArrayList();

    private ConfigBuilder() {
    }

    public static void create(Path path, Consumer<ConfigBuilder> builderConsumer) {
        ConfigBuilder builder = new ConfigBuilder();
        builderConsumer.accept(builder);
        Config config = new Config(path);
        for (ConfigEntry<?> entry : builder.entries) {
            entry.config = config;
            entry.loadOrDefault();
        }
        config.save();
    }

    public ConfigEntry<Boolean> booleanEntry(String key, boolean def) {
        BooleanConfigEntry entry = new BooleanConfigEntry();
        entry.key = key;
        entry.def = def;
        this.entries.add(entry);
        return entry;
    }

    public ConfigEntry<Integer> integerEntry(String key, int def, int min, int max) {
        IntegerConfigEntry entry = new IntegerConfigEntry(min, max);
        entry.key = key;
        entry.def = def;
        this.entries.add(entry);
        return entry;
    }

    public ConfigEntry<Double> doubleEntry(String key, double def, double min, double max) {
        DoubleConfigEntry entry = new DoubleConfigEntry(min, max);
        entry.key = key;
        entry.def = def;
        this.entries.add(entry);
        return entry;
    }

    public ConfigEntry<String> stringEntry(String key, String def) {
        StringConfigEntry entry = new StringConfigEntry();
        entry.key = key;
        entry.def = def;
        this.entries.add(entry);
        return entry;
    }

    public <T extends Enum> ConfigEntry<T> enumEntry(String key, T def) {
        EnumConfigEntry entry = new EnumConfigEntry(def.getClass());
        entry.key = key;
        entry.def = def;
        this.entries.add(entry);
        return entry;
    }

    public static abstract class ConfigEntry<T> {
        protected Config config;
        protected String key;
        protected T value;
        protected T def;

        private ConfigEntry() {
        }

        public T get() {
            return this.value;
        }

        public void set(T value) {
            if (this.value.equals(value)) {
                return;
            }
            this.value = value;
            String serialized = this.serialize(value);
            this.config.getProperties().setProperty(this.key, serialized);
        }

        protected void loadOrDefault() {
            if (this.config.getProperties().containsKey(this.key)) {
                T val = this.deserialize(this.config.getProperties().getProperty(this.key));
                if (val == null) {
                    this.reset();
                } else {
                    this.value = val;
                }
            } else {
                this.reset();
            }
        }

        public void reset() {
            this.value = this.def;
            this.config.getProperties().setProperty(this.key, this.serialize(this.def));
        }

        public void save() {
            this.config.save();
        }

        @Nullable
        public abstract T deserialize(String var1);

        public abstract String serialize(T var1);
    }

    private static class BooleanConfigEntry
    extends ConfigEntry<Boolean> {
        private BooleanConfigEntry() {
        }

        @Override
        @Nullable
        public Boolean deserialize(String str) {
            return Boolean.valueOf(str);
        }

        @Override
        public String serialize(Boolean val) {
            return String.valueOf(val);
        }
    }

    private static class IntegerConfigEntry
    extends ConfigEntry<Integer> {
        private int min;
        private int max;

        public IntegerConfigEntry(int min, int max) {
            this.min = min;
            this.max = max;
        }

        @Override
        @Nullable
        public Integer deserialize(String str) {
            try {
                return Math.max(Math.min(Integer.parseInt(str), this.max), this.min);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        @Override
        public String serialize(Integer val) {
            return String.valueOf(val);
        }
    }

    private static class DoubleConfigEntry
    extends ConfigEntry<Double> {
        private double min;
        private double max;

        public DoubleConfigEntry(double min, double max) {
            this.min = min;
            this.max = max;
        }

        @Override
        @Nullable
        public Double deserialize(String str) {
            try {
                return Math.max(Math.min(Double.parseDouble(str), this.max), this.min);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        @Override
        public String serialize(Double val) {
            return String.valueOf(val);
        }
    }

    private static class StringConfigEntry
    extends ConfigEntry<String> {
        private StringConfigEntry() {
        }

        @Override
        @Nullable
        public String deserialize(String str) {
            return str;
        }

        @Override
        public String serialize(String val) {
            return val;
        }
    }

    private static class EnumConfigEntry<T extends Enum>
    extends ConfigEntry<Enum> {
        protected Class<T> enumClass;

        public EnumConfigEntry(Class<T> enumClass) {
            this.enumClass = enumClass;
        }

        @Override
        @Nullable
        public Enum deserialize(String str) {
            try {
                return Enum.valueOf(this.enumClass, str);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public String serialize(Enum val) {
            return val.name();
        }
    }
}

