/*
 * Decompiled with CFR 0.152.
 */
package io.github.simplycmd.camping.items;

import io.github.simplycmd.camping.Main;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4174;
import org.jetbrains.annotations.Nullable;

public class MarshmallowOnStickItem
extends class_1792 {
    private static final double CAMPFIRE_DISTANCE = 2.0;
    private final Cooked cooked;

    public MarshmallowOnStickItem(Cooked cooked) {
        super((class_1792.class_1793)(switch (cooked) {
            case Cooked.RAW -> new FabricItemSettings().group(class_1761.field_7922).maxCount(1).food(new class_4174.class_4175().method_19238(1).method_19237(0.5f).method_19241().method_19240().method_19242());
            case Cooked.WARM, Cooked.FLAMING -> new FabricItemSettings().group(class_1761.field_7922).maxCount(1).food(new class_4174.class_4175().method_19238(2).method_19237(0.75f).method_19241().method_19240().method_19242());
            case Cooked.GOLDEN -> new FabricItemSettings().group(class_1761.field_7922).maxCount(1).food(new class_4174.class_4175().method_19238(8).method_19237(1.25f).method_19241().method_19240().method_19242());
            case Cooked.HALFBURNT -> new FabricItemSettings().group(class_1761.field_7922).maxCount(1).food(new class_4174.class_4175().method_19238(4).method_19237(0.5f).method_19241().method_19240().method_19242());
            case Cooked.BURNT -> new FabricItemSettings().group(class_1761.field_7922).maxCount(1).food(new class_4174.class_4175().method_19238(1).method_19237(0.0f).method_19241().method_19240().method_19242());
            default -> throw new EnumConstantNotPresentException(Cooked.class, "cooked");
        }));
        this.cooked = cooked;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        tooltip.add((class_2561)new class_2585("Hold over a campfire to cook").method_27695(new class_124[]{class_124.field_1056, class_124.field_1080}));
        tooltip.add((class_2561)new class_2585("(hint: look at it)").method_27695(new class_124[]{class_124.field_1056, class_124.field_1080}));
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        class_3965 hit;
        class_2680 hitBlock;
        class_1309 livingEntity = (class_1309)entity;
        if ((livingEntity.method_6047().method_7909().equals((Object)this) || livingEntity.method_6079().method_7909().equals((Object)this)) && (hitBlock = world.method_8320((hit = MarshmallowOnStickItem.raycast(world, livingEntity, class_3959.class_242.field_1348)).method_17777())).method_26164((class_3494)class_3481.field_23799) && hit.method_24801((class_1297)livingEntity) <= 2.0) {
            this.cook(stack);
        }
        if (this.cooked.equals((Object)Cooked.FLAMING)) {
            if (MarshmallowOnStickItem.getCooked(stack).isEmpty()) {
                MarshmallowOnStickItem.setCooked(stack, 0);
            } else {
                MarshmallowOnStickItem.setCooked(stack, MarshmallowOnStickItem.getCooked(stack).get() + 1);
            }
        }
        this.update(livingEntity, stack, slot);
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        super.method_7861(stack, world, user);
        if (this.cooked.equals((Object)Cooked.FLAMING)) {
            user.method_5639(3);
        }
        if (stack.method_7960()) {
            if (user instanceof class_1657) {
                ((class_1657)user).method_7281(Main.BURNED);
            }
            return new class_1799((class_1935)class_1802.field_8600);
        }
        class_1309 class_13092 = user;
        if (class_13092 instanceof class_1657) {
            class_1657 playerEntity = (class_1657)class_13092;
            if (!((class_1657)user).method_31549().field_7477) {
                class_1799 itemStack = new class_1799((class_1935)class_1802.field_8600);
                if (!playerEntity.method_31548().method_7394(itemStack)) {
                    playerEntity.method_7328(itemStack, false);
                }
            }
        }
        return stack;
    }

    public static Optional<Integer> getCooked(class_1799 stack) {
        class_2487 nbtCompound = stack.method_7969();
        if (nbtCompound != null) {
            return Optional.of(nbtCompound.method_10550("Cooked"));
        }
        return Optional.empty();
    }

    public static void setCooked(class_1799 stack, int cooked) {
        class_2487 nbtCompound = stack.method_7948();
        nbtCompound.method_10569("Cooked", cooked);
    }

    private void update(class_1309 entity, class_1799 stack, int slot) {
        if (MarshmallowOnStickItem.getCooked(stack).isEmpty()) {
            MarshmallowOnStickItem.setCooked(stack, 0);
        } else if (MarshmallowOnStickItem.getCooked(stack).get() >= this.cooked.getBurnTime()) {
            Optional<class_1792> next = this.cooked.getNext();
            if (next.isPresent()) {
                if (entity instanceof class_1657) {
                    stack.method_7934(1);
                    ((class_1657)entity).method_7270(next.get().method_7854());
                }
                if (this.cooked.equals((Object)Cooked.FLAMING) && entity instanceof class_1657) {
                    entity.field_6002.method_8396((class_1657)entity, entity.method_24515(), class_3417.field_14821, class_3419.field_15248, 1.0f, 1.0f);
                }
            } else {
                if (entity instanceof class_1657) {
                    stack.method_7934(1);
                    ((class_1657)entity).method_7270(class_1802.field_8600.method_7854());
                }
                if (entity instanceof class_1657) {
                    entity.field_6002.method_8396((class_1657)entity, entity.method_24515(), class_3417.field_14821, class_3419.field_15248, 1.0f, 1.0f);
                }
            }
        }
    }

    private void cook(class_1799 stack) {
        if (MarshmallowOnStickItem.getCooked(stack).isPresent() && !this.cooked.equals((Object)Cooked.FLAMING)) {
            MarshmallowOnStickItem.setCooked(stack, MarshmallowOnStickItem.getCooked(stack).get() + 1);
        }
    }

    private static class_3965 raycast(class_1937 world, class_1309 entity, class_3959.class_242 fluidHandling) {
        float f = entity.method_36455();
        float g = entity.method_36454();
        class_243 vec3d = entity.method_33571();
        float h = class_3532.method_15362((float)(-g * ((float)Math.PI / 180) - (float)Math.PI));
        float i = class_3532.method_15374((float)(-g * ((float)Math.PI / 180) - (float)Math.PI));
        float j = -class_3532.method_15362((float)(-f * ((float)Math.PI / 180)));
        float k = class_3532.method_15374((float)(-f * ((float)Math.PI / 180)));
        float l = i * j;
        float n = h * j;
        class_243 vec3d2 = vec3d.method_1031((double)l * 5.0, (double)k * 5.0, (double)n * 5.0);
        return world.method_17742(new class_3959(vec3d, vec3d2, class_3959.class_3960.field_17559, fluidHandling, (class_1297)entity));
    }

    public static enum Cooked {
        BURNT(100, Optional.empty()),
        FLAMING(100, Optional.empty()),
        HALFBURNT(50, Optional.empty()),
        GOLDEN(25, Optional.empty()),
        WARM(75, Optional.empty()),
        RAW(100, Optional.empty());

        private Optional<class_1792> nextItem;
        private final int burnTime;

        private Optional<class_1792> getNext() {
            return this.nextItem;
        }

        public static void updateItems() {
            Cooked.BURNT.nextItem = Optional.of(Main.MARSHMALLOW_ON_STICK_FLAMING);
            Cooked.FLAMING.nextItem = Optional.of(Main.MARSHMALLOW_ON_STICK_BURNT);
            Cooked.HALFBURNT.nextItem = Optional.of(Main.MARSHMALLOW_ON_STICK_FLAMING);
            Cooked.GOLDEN.nextItem = Optional.of(Main.MARSHMALLOW_ON_STICK_HALFBURNT);
            Cooked.WARM.nextItem = Optional.of(Main.MARSHMALLOW_ON_STICK_GOLDEN);
            Cooked.RAW.nextItem = Optional.of(Main.MARSHMALLOW_ON_STICK_WARM);
        }

        private int getBurnTime() {
            return this.burnTime;
        }

        private Cooked(int burnTime, Optional<class_1792> nextItem) {
            this.nextItem = nextItem;
            this.burnTime = burnTime;
        }
    }
}

