/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.StructurePieceType;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.puffish.castle.ForgeBlockParser;
import net.puffish.castle.ForgeGenerator;
import net.puffish.castle.config.Config;
import net.puffish.castle.config.Configuration;
import net.puffish.castle.config.Theme;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="castle_dungeons")
public class CastleDungeons {
    public static final String MOD_ID = "castle_dungeons";
    public static final Logger LOGGER = LogManager.getLogger((String)"castle_dungeons");
    public static final ResourceLocation LOOT_TABLE_LOOT = new ResourceLocation("castle_dungeons", "chests/loot");
    public static final ResourceLocation LOOT_TABLE_HEAL = new ResourceLocation("castle_dungeons", "chests/heal");
    public static final ResourceLocation LOOT_TABLE_JUNK = new ResourceLocation("castle_dungeons", "chests/junk");
    public static final StructurePieceType CASTLE_TYPE = (StructurePieceType)Registry.m_122965_((Registry)Registry.f_122843_, (ResourceLocation)new ResourceLocation("castle_dungeons", "castle_piece"), ForgeGenerator.Piece::new);
    private static final ForgeGenerator GENERATOR = new ForgeGenerator();
    private static final DeferredRegister<StructureFeature<?>> DEFERRED_REGISTRY_STRUCTURE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"castle_dungeons");
    private static final ConfiguredStructureFeature<?, ?> CONFIGURED_STRUCTURE_GENERATOR = GENERATOR.m_67065_((FeatureConfiguration)NoneFeatureConfiguration.f_67816_);
    private File configDirectory;
    private static final String[] files = new String[]{"themes/default.cfg", "themes/desert.cfg", "config.cfg"};
    private List<Theme<Block>> themes;
    private Config config;

    public CastleDungeons() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        DEFERRED_REGISTRY_STRUCTURE.register(eventBus);
        DEFERRED_REGISTRY_STRUCTURE.register("castle", () -> GENERATOR);
        eventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, this::onWorldLoad);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            this.configDirectory = new File(FMLPaths.CONFIGDIR.get().toFile(), "castle_dungeons/");
            if (!this.configDirectory.exists()) {
                this.configDirectory.mkdirs();
                Configuration.copyDefault(this.configDirectory, files);
            }
            this.themes = Configuration.loadThemes(this.configDirectory, new ForgeBlockParser());
            this.config = Configuration.loadConfig(this.configDirectory);
            if (this.config == null) {
                LOGGER.warn("Could not load config!");
                return;
            }
            LOGGER.info("Loaded " + String.valueOf(this.themes.size()) + " themes!");
            GENERATOR.initialize(this);
            StructureFeature.f_67012_.put((Object)GENERATOR.getRegistryName().toString(), (Object)GENERATOR);
            StructureFeature.f_67031_ = ImmutableList.builder().addAll((Iterable)StructureFeature.f_67031_).add((Object)GENERATOR).build();
            StructureFeatureConfiguration structureSeparationSettings = new StructureFeatureConfiguration(this.config.getSpacing(), this.config.getSeparation(), 30042004);
            StructureSettings.f_64580_ = ImmutableMap.builder().putAll((Map)StructureSettings.f_64580_).put((Object)GENERATOR, (Object)structureSeparationSettings).build();
            BuiltinRegistries.f_123866_.m_6579_().forEach(settings -> {
                Map structureMap = ((NoiseGeneratorSettings)settings.getValue()).m_64457_().m_64590_();
                if (structureMap instanceof ImmutableMap) {
                    HashMap<ForgeGenerator, StructureFeatureConfiguration> tmpMap = new HashMap<ForgeGenerator, StructureFeatureConfiguration>(structureMap);
                    tmpMap.put(GENERATOR, structureSeparationSettings);
                    ((NoiseGeneratorSettings)settings.getValue()).m_64457_().f_64582_ = tmpMap;
                } else {
                    structureMap.put(GENERATOR, structureSeparationSettings);
                }
            });
            Registry.m_122965_((Registry)BuiltinRegistries.f_123862_, (ResourceLocation)new ResourceLocation(MOD_ID, "configured_castle"), CONFIGURED_STRUCTURE_GENERATOR);
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)event.getWorld();
            ChunkGenerator chunkGenerator = serverWorld.m_7726_().m_8481_();
            if (chunkGenerator instanceof FlatLevelSource && serverWorld.m_46472_().equals((Object)Level.f_46428_)) {
                return;
            }
            HashMap<StructureFeature, HashMultimap> structureToMultiMap = new HashMap<StructureFeature, HashMultimap>();
            for (Map.Entry biomeEntry : serverWorld.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                structureToMultiMap.putIfAbsent(CastleDungeons.CONFIGURED_STRUCTURE_GENERATOR.f_65403_, HashMultimap.create());
                HashMultimap configuredStructureToBiomeMultiMap = (HashMultimap)structureToMultiMap.get(CastleDungeons.CONFIGURED_STRUCTURE_GENERATOR.f_65403_);
                configuredStructureToBiomeMultiMap.put(CONFIGURED_STRUCTURE_GENERATOR, (Object)((ResourceKey)biomeEntry.getKey()));
            }
            StructureSettings worldStructureConfig = chunkGenerator.m_62205_();
            ImmutableMap.Builder tempStructureToMultiMap = ImmutableMap.builder();
            worldStructureConfig.f_189361_.entrySet().stream().filter(entry -> !structureToMultiMap.containsKey(entry.getKey())).forEach(arg_0 -> ((ImmutableMap.Builder)tempStructureToMultiMap).put(arg_0));
            structureToMultiMap.forEach((key, value) -> tempStructureToMultiMap.put(key, (Object)ImmutableMultimap.copyOf((Multimap)value)));
            worldStructureConfig.f_189361_ = tempStructureToMultiMap.build();
            HashMap<ForgeGenerator, StructureFeatureConfiguration> tempMap = new HashMap<ForgeGenerator, StructureFeatureConfiguration>(serverWorld.m_7726_().m_8481_().m_62205_().m_64590_());
            tempMap.putIfAbsent(GENERATOR, (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)GENERATOR));
            serverWorld.m_7726_().m_8481_().m_62205_().f_64582_ = tempMap;
        }
    }

    public List<Theme<Block>> getThemes() {
        return this.themes;
    }

    public Config getConfig() {
        return this.config;
    }
}

