/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.ScatteredFeaturePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.puffish.castle.CastleDungeons;
import net.puffish.castle.ForgeWorldEditor;
import net.puffish.castle.builder.Generator;
import net.puffish.castle.builder.WorldEditor;
import net.puffish.castle.config.Theme;

public class ForgeGenerator
extends StructureFeature<NoneFeatureConfiguration> {
    private static ForgeGeneratorInternal internal;
    private static CastleDungeons castleDungeons;

    public ForgeGenerator() {
        super(NoneFeatureConfiguration.f_67815_, context -> {
            ChunkPos chunkPos = context.f_197355_();
            final int x = chunkPos.m_151382_(7);
            final int z = chunkPos.m_151391_(7);
            final int y = context.f_197352_().m_142647_(x, z, Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
            if (!internal.hasThemeForBiome(castleDungeons.getThemes(), context.f_197360_(), context.f_197353_().m_183546_(QuartPos.m_175400_((int)x), QuartPos.m_175400_((int)y), QuartPos.m_175400_((int)z), context.f_197352_().m_183403_()))) {
                return Optional.empty();
            }
            if (y > castleDungeons.getConfig().getMaxTerrainHeight()) {
                return Optional.empty();
            }
            if (y < castleDungeons.getConfig().getMinTerrainHeight()) {
                return Optional.empty();
            }
            return Optional.of(new PieceGenerator<NoneFeatureConfiguration>(){

                public void m_197325_(StructurePiecesBuilder structurePiecesBuilder, PieceGenerator.Context<NoneFeatureConfiguration> context) {
                    structurePiecesBuilder.m_142679_((StructurePiece)new Piece(x, y, z));
                }
            });
        });
    }

    public void initialize(CastleDungeons castleDungeons) {
        if (ForgeGenerator.castleDungeons == null) {
            ForgeGenerator.castleDungeons = castleDungeons;
            internal = new ForgeGeneratorInternal(castleDungeons);
        }
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    private static class ForgeGeneratorInternal
    extends Generator {
        private CastleDungeons castleDungeons;

        public ForgeGeneratorInternal(CastleDungeons castleDungeons) {
            super(castleDungeons.getConfig().getMinCastleSize(), castleDungeons.getConfig().getMaxCastleSize(), castleDungeons.getConfig().getSpawnerChance(), castleDungeons.getConfig().getChestChance());
            this.castleDungeons = castleDungeons;
        }

        public void generate(ServerLevel world, int chunkX, int chunkZ, Biome biome, Random random) {
            Theme<Block> theme = this.getThemeForBiome(this.castleDungeons.getThemes(), world.m_5962_(), biome, random);
            if (theme == null) {
                CastleDungeons.LOGGER.warn("Could not find theme for biome!");
                return;
            }
            ForgeWorldEditor editor = new ForgeWorldEditor(this.castleDungeons, world, theme, random);
            this.generate(editor, chunkX, chunkZ, random);
        }

        @Override
        public int findGroundHeight(WorldEditor editor, int x, int z, int sizeX, int sizeZ) {
            ServerLevel world = ((ForgeWorldEditor)editor).getWorld();
            ChunkGenerator chunkGenerator = world.m_7726_().m_8481_();
            int height = 0;
            for (int i = 0; i < sizeX; ++i) {
                for (int j = 0; j < sizeZ; ++j) {
                    height = Math.max(height, chunkGenerator.m_156174_(x + i, z + j, Heightmap.Types.WORLD_SURFACE_WG, (LevelHeightAccessor)world));
                }
            }
            return height;
        }

        private String getBiomeName(RegistryAccess dynamicRegistries, Biome biome) {
            ResourceLocation id = dynamicRegistries.m_175515_(Registry.f_122885_).m_7981_((Object)biome);
            if (id == null) {
                return "?";
            }
            return id.m_135827_() + ":" + id.m_135815_();
        }

        public <T> boolean hasThemeForBiome(List<Theme<T>> themes, RegistryAccess dynamicRegistries, Biome biome) {
            return this.hasThemeForBiome(themes, this.getBiomeName(dynamicRegistries, biome));
        }

        public <T> Theme<T> getThemeForBiome(List<Theme<T>> themes, RegistryAccess dynamicRegistries, Biome biome, Random random) {
            return this.getThemeForBiome(themes, this.getBiomeName(dynamicRegistries, biome), random);
        }
    }

    public static class Piece
    extends ScatteredFeaturePiece {
        public Piece(int x, int y, int z) {
            super(CastleDungeons.CASTLE_TYPE, x, y, z, 1, 1, 1, Direction.NORTH);
        }

        public Piece(CompoundTag nbt) {
            super(CastleDungeons.CASTLE_TYPE, nbt);
        }

        public void m_183269_(WorldGenLevel worldGenLevel, StructureFeatureManager structureManager, ChunkGenerator chunkGenerator, Random random, BoundingBox box, ChunkPos chunkPos, BlockPos pos) {
            ServerLevel world = worldGenLevel.m_6018_();
            int x = chunkPos.m_151382_(7);
            int z = chunkPos.m_151391_(7);
            int y = chunkGenerator.m_142647_(x, z, Heightmap.Types.WORLD_SURFACE_WG, (LevelHeightAccessor)worldGenLevel);
            Biome biome = chunkGenerator.m_62218_().m_183546_(QuartPos.m_175400_((int)x), QuartPos.m_175400_((int)y), QuartPos.m_175400_((int)z), chunkGenerator.m_183403_());
            Random tmpRandom = new Random(random.nextLong());
            world.m_142572_().execute(() -> internal.generate(world, chunkPos.f_45578_, chunkPos.f_45579_, biome, tmpRandom));
        }
    }
}

