/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.puffish.castle.BlockParserImpl;
import net.puffish.castle.StructureImpl;
import net.puffish.castle.config.Config;
import net.puffish.castle.config.Configuration;
import net.puffish.castle.config.Theme;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CastleDungeons {
    public static final String MOD_ID = "castle_dungeons";
    public static final Logger LOGGER = LogManager.getLogger((String)"castle_dungeons");
    public static final ResourceLocation LOOT_TABLE_LOOT = new ResourceLocation("castle_dungeons", "chests/loot");
    public static final ResourceLocation LOOT_TABLE_HEAL = new ResourceLocation("castle_dungeons", "chests/heal");
    public static final ResourceLocation LOOT_TABLE_JUNK = new ResourceLocation("castle_dungeons", "chests/junk");
    public static final StructureType<StructureImpl> CASTLE_STRUCTURE = () -> StructureImpl.CODEC;
    public static final StructurePieceType CASTLE_PIECE_TYPE = StructureImpl.CastlePiece::new;
    public static final StructurePieceType GROUND_PIECE_TYPE = StructureImpl.GroundPiece::new;
    private File configDir;
    private static final String[] files = new String[]{"themes/default.cfg", "themes/desert.cfg", "config.cfg"};
    private List<Theme<Block>> themes;
    private Config config;

    public static void init(Path configDirectory) {
        new CastleDungeons(configDirectory);
    }

    private CastleDungeons(Path configDirectory) {
        this.configDir = configDirectory.resolve(MOD_ID).toFile();
        if (!this.configDir.exists()) {
            this.configDir.mkdirs();
            Configuration.copyDefault(this.configDir, files);
        }
        this.themes = Configuration.loadThemes(this.configDir, new BlockParserImpl());
        this.config = Configuration.loadConfig(this.configDir);
        if (this.config == null) {
            LOGGER.warn("Could not load config!");
            return;
        }
        LOGGER.info("Loaded " + this.themes.size() + " themes!");
        StructureImpl.initialize(this);
        Registry.m_122965_((Registry)Registry.f_235740_, (ResourceLocation)new ResourceLocation(MOD_ID, "castle"), CASTLE_STRUCTURE);
        Registry.m_122965_((Registry)Registry.f_122843_, (ResourceLocation)new ResourceLocation(MOD_ID, "castle_piece"), (Object)CASTLE_PIECE_TYPE);
        Registry.m_122965_((Registry)Registry.f_122843_, (ResourceLocation)new ResourceLocation(MOD_ID, "ground_piece"), (Object)GROUND_PIECE_TYPE);
    }

    public List<Theme<Block>> getThemes() {
        return this.themes;
    }

    public Config getConfig() {
        return this.config;
    }
}

