/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.ScatteredFeaturePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.puffish.castle.CastleDungeons;
import net.puffish.castle.WorldEditorImpl;
import net.puffish.castle.builder.Generator;
import net.puffish.castle.builder.Rect;
import net.puffish.castle.config.Theme;

public class StructureImpl
extends Structure {
    private static GeneratorImpl internal;
    private static CastleDungeons castleDungeons;
    public static final Codec<StructureImpl> CODEC;

    protected StructureImpl(Structure.StructureSettings config) {
        super(config);
    }

    public static void initialize(CastleDungeons castleDungeons) {
        if (StructureImpl.castleDungeons == null) {
            StructureImpl.castleDungeons = castleDungeons;
            internal = new GeneratorImpl(castleDungeons);
        }
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.f_226628_();
        int x = chunkPos.m_151382_(7);
        int z = chunkPos.m_151391_(7);
        int y = context.f_226622_().m_214096_(x, z, Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_());
        if (!internal.hasThemeForBiome(castleDungeons.getThemes(), context.f_226621_(), (Biome)context.f_226623_().m_203407_(QuartPos.m_175400_((int)x), QuartPos.m_175400_((int)y), QuartPos.m_175400_((int)z), context.f_226624_().m_224579_()).m_203334_())) {
            return Optional.empty();
        }
        Random random = new Random(BlockPos.m_121882_((int)x, (int)y, (int)z) ^ context.f_226627_());
        random.nextLong();
        Rect rect = internal.calculate(x, z, random);
        if (y > castleDungeons.getConfig().getMaxTerrainHeight()) {
            return Optional.empty();
        }
        if (y < castleDungeons.getConfig().getMinTerrainHeight()) {
            return Optional.empty();
        }
        return Structure.m_226585_((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, structurePiecesCollector -> {
            structurePiecesCollector.m_142679_((StructurePiece)new GroundPiece(rect.getX(), y, rect.getZ(), rect.getWidth(), rect.getHeight()));
            structurePiecesCollector.m_142679_((StructurePiece)new CastlePiece(x, y, z));
        });
    }

    public StructureType<?> m_213658_() {
        return CastleDungeons.CASTLE_STRUCTURE;
    }

    static {
        CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)StructureImpl.m_226567_((RecordCodecBuilder.Instance)instance)).apply((Applicative)instance, StructureImpl::new)).codec();
    }

    private static class GeneratorImpl
    extends Generator {
        private CastleDungeons castleDungeons;

        public GeneratorImpl(CastleDungeons castleDungeons) {
            super(castleDungeons.getConfig().getMinCastleSize(), castleDungeons.getConfig().getMaxCastleSize(), castleDungeons.getConfig().getSpawnerChance(), castleDungeons.getConfig().getChestChance());
            this.castleDungeons = castleDungeons;
        }

        public void generate(ServerLevel world, int x, int y, int z, Biome biome, Random random) {
            Theme<Block> theme = this.getThemeForBiome(this.castleDungeons.getThemes(), world.m_5962_(), biome, new Random(random.nextLong()));
            if (theme == null) {
                CastleDungeons.LOGGER.warn("Could not find theme for biome!");
                return;
            }
            WorldEditorImpl editor = new WorldEditorImpl(this.castleDungeons, world, theme, random);
            this.generate(editor, x, y, z, random);
        }

        private String getBiomeName(RegistryAccess dynamicRegistryManager, Biome biome) {
            ResourceLocation id = dynamicRegistryManager.m_175515_(Registry.f_122885_).m_7981_((Object)biome);
            if (id == null) {
                return "?";
            }
            return id.m_135827_() + ":" + id.m_135815_();
        }

        public <T> boolean hasThemeForBiome(List<Theme<T>> themes, RegistryAccess dynamicRegistryManager, Biome biome) {
            return this.hasThemeForBiome(themes, this.getBiomeName(dynamicRegistryManager, biome));
        }

        public <T> Theme<T> getThemeForBiome(List<Theme<T>> themes, RegistryAccess dynamicRegistryManager, Biome biome, Random random) {
            return this.getThemeForBiome(themes, this.getBiomeName(dynamicRegistryManager, biome), random);
        }
    }

    public static class GroundPiece
    extends ScatteredFeaturePiece {
        public GroundPiece(int x, int y, int z, int w, int h) {
            super(CastleDungeons.GROUND_PIECE_TYPE, x, y, z, w, 1, h, Direction.NORTH);
        }

        public GroundPiece(CompoundTag nbt) {
            super(CastleDungeons.GROUND_PIECE_TYPE, nbt);
        }

        public void m_213694_(WorldGenLevel structureWorldAccess, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox blockBox, ChunkPos chunkPos, BlockPos blockPos) {
        }
    }

    public static class CastlePiece
    extends ScatteredFeaturePiece {
        public CastlePiece(int x, int y, int z) {
            super(CastleDungeons.CASTLE_PIECE_TYPE, x, y, z, 1, 1, 1, Direction.NORTH);
        }

        public CastlePiece(CompoundTag nbt) {
            super(CastleDungeons.CASTLE_PIECE_TYPE, nbt);
        }

        public void m_213694_(WorldGenLevel structureWorldAccess, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox blockBox, ChunkPos chunkPos, BlockPos blockPos) {
            ServerLevel world = structureWorldAccess.m_6018_();
            int x = this.m_73547_().m_162395_();
            int y = this.m_73547_().m_162396_();
            int z = this.m_73547_().m_162398_();
            Biome biome = (Biome)chunkGenerator.m_62218_().m_203407_(QuartPos.m_175400_((int)x), QuartPos.m_175400_((int)y), QuartPos.m_175400_((int)z), world.m_7726_().m_214994_().m_224579_()).m_203334_();
            Random tmpRandom = new Random(BlockPos.m_121882_((int)x, (int)y, (int)z) ^ world.m_7328_());
            world.m_7654_().execute(() -> internal.generate(world, x, y, z, biome, tmpRandom));
        }
    }
}

