/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.puffish.castle.builder.Builder;
import net.puffish.castle.builder.Coord;
import net.puffish.castle.builder.Rect;
import net.puffish.castle.builder.WorldEditor;
import net.puffish.castle.builder.rooms.BedRoom;
import net.puffish.castle.builder.rooms.BlacksmithRoom;
import net.puffish.castle.builder.rooms.JainRoom;
import net.puffish.castle.builder.rooms.LibraryRoom;
import net.puffish.castle.builder.rooms.SpiderRoom;
import net.puffish.castle.builder.rooms.StorageRoom;
import net.puffish.castle.config.Theme;
import net.puffish.castle.generator.Castle;

public abstract class Generator {
    private int minCastleSize;
    private int maxCastleSize;
    private int spawnerChance;
    private int chestChance;

    public Generator(int minCastleSize, int maxCastleSize, int spawnerChance, int chestChance) {
        this.minCastleSize = minCastleSize;
        this.maxCastleSize = maxCastleSize;
        this.spawnerChance = spawnerChance;
        this.chestChance = chestChance;
    }

    private Castle create(Random random) {
        int w = random.nextInt(this.maxCastleSize - this.minCastleSize + 1) + this.minCastleSize;
        int h = random.nextInt(this.maxCastleSize - this.minCastleSize + 1) + this.minCastleSize;
        return this.create(w, h);
    }

    private Castle create(int w, int h) {
        Castle castle = new Castle(w, h);
        castle.addRoom(new LibraryRoom(1));
        castle.addRoom(new JainRoom(1));
        castle.addRoom(new SpiderRoom(2));
        castle.addRoom(new BlacksmithRoom(2));
        castle.addRoom(new BedRoom(6));
        castle.addRoom(new StorageRoom(10));
        return castle;
    }

    public void generate(WorldEditor editor, int x, int y, int z, Random random) {
        Castle castle = this.create(random);
        Rect rect = this.calculate(castle, x, z);
        castle.generate(random);
        Coord coord = new Coord(rect.getX(), y, rect.getZ());
        Builder builder = new Builder(editor, this.spawnerChance, this.chestChance);
        builder.buildCastle(coord, castle, random);
        builder.buildFundation(coord, rect.getWidth(), rect.getHeight());
    }

    private Rect calculate(Castle castle, int x, int z) {
        int width = castle.getWidth() * 6 + 1 + 2;
        int height = castle.getHeight() * 6 + 1 + 2;
        return new Rect(x - width / 2, z - height / 2, width, height);
    }

    public Rect calculate(int x, int z, Random random) {
        return this.calculate(this.create(random), x, z);
    }

    public <T> boolean hasThemeForBiome(List<Theme<T>> themes, String biomeName) {
        for (Theme<T> t : themes) {
            if (t.getBiomeWhitelist() != null) {
                if (!t.getBiomeWhitelist().contains(biomeName)) continue;
                return true;
            }
            if (t.getBiomeBlacklist() != null) {
                if (t.getBiomeBlacklist().contains(biomeName)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public <T> Theme<T> getThemeForBiome(List<Theme<T>> themes, String biomeName, Random random) {
        ArrayList<Theme<T>> matchingThemes = new ArrayList<Theme<T>>();
        for (Theme<T> t : themes) {
            if (t.getBiomeWhitelist() != null) {
                if (!t.getBiomeWhitelist().contains(biomeName)) continue;
                matchingThemes.add(t);
                continue;
            }
            if (t.getBiomeBlacklist() != null) {
                if (t.getBiomeBlacklist().contains(biomeName)) continue;
                matchingThemes.add(t);
                continue;
            }
            matchingThemes.add(t);
        }
        if (matchingThemes.isEmpty()) {
            return null;
        }
        return (Theme)matchingThemes.get(random.nextInt(matchingThemes.size()));
    }
}

