/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle.builder;

import net.puffish.castle.builder.BlockGroup;
import net.puffish.castle.builder.BlockType;
import net.puffish.castle.builder.ChestType;
import net.puffish.castle.builder.Coord;
import net.puffish.castle.builder.EntityType;
import net.puffish.castle.builder.WorldEditor;

public class TranslatedWorldEditor
extends WorldEditor {
    private WorldEditor editor;
    private Coord coord;

    public TranslatedWorldEditor(WorldEditor editor, Coord coord) {
        this.editor = editor;
        this.coord = coord;
    }

    private Coord convert(Coord coord) {
        return new Coord(this.coord.getX() + coord.getX(), this.coord.getY() + coord.getY(), this.coord.getZ() + coord.getZ());
    }

    @Override
    public BlockGroup createGroup() {
        return this.editor.createGroup();
    }

    @Override
    public boolean setBlockIfEmpty(Coord coord, BlockType type) {
        return this.editor.setBlockIfEmpty(this.convert(coord), type);
    }

    @Override
    public void setBlock(Coord coord, BlockType type, BlockGroup group) {
        this.editor.setBlock(this.convert(coord), type, group);
    }

    @Override
    public void setChest(Coord coord, ChestType type, int level) {
        this.editor.setChest(this.convert(coord), type, level);
    }

    @Override
    public void setSpawner(Coord coord, int level) {
        this.editor.setSpawner(this.convert(coord), level);
    }

    @Override
    public void setSpawner(Coord coord, EntityType type) {
        this.editor.setSpawner(this.convert(coord), type);
    }

    @Override
    public void spawnEntity(Coord coord, EntityType type) {
        this.editor.spawnEntity(this.convert(coord), type);
    }
}

