/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle.builder.nodes;

import net.puffish.castle.builder.BlockType;
import net.puffish.castle.builder.Coord;
import net.puffish.castle.builder.WorldEditor;
import net.puffish.castle.generator.Castle;
import net.puffish.castle.generator.CastleLayer;
import net.puffish.castle.generator.CastleNode;
import net.puffish.castle.generator.CastleNodeState;

public class Node {
    protected WorldEditor editor;
    protected Castle castle;
    protected CastleNode node;

    public Node(WorldEditor editor, Castle castle, CastleNode node) {
        this.editor = editor;
        this.castle = castle;
        this.node = node;
    }

    public boolean isColumnTower() {
        for (CastleLayer layer : this.castle.getLayers()) {
            if (layer.getGrid()[this.node.getX()][this.node.getY()].getState() != CastleNodeState.TOWER) continue;
            return true;
        }
        return false;
    }

    private CastleNode getNodeAtOffset(int offsetX, int offsetY) {
        int x = this.node.getX() + offsetX;
        if (x >= this.castle.getWidth()) {
            return null;
        }
        if (x < 0) {
            return null;
        }
        int y = this.node.getY() + offsetY;
        if (y >= this.castle.getHeight()) {
            return null;
        }
        if (y < 0) {
            return null;
        }
        return this.castle.getLayers().get(this.node.getLevel()).getGrid()[x][y];
    }

    public boolean isEmptyAtOffset(int offsetX, int offsetY) {
        CastleNode node = this.getNodeAtOffset(offsetX, offsetY);
        if (node == null) {
            return true;
        }
        return node.getState() == CastleNodeState.EMPTY;
    }

    public boolean isEmptyOrWalkAtOffset(int offsetX, int offsetY) {
        CastleNode node = this.getNodeAtOffset(offsetX, offsetY);
        if (node == null) {
            return true;
        }
        return node.getState() == CastleNodeState.EMPTY || node.getState() == CastleNodeState.WALK;
    }

    public void build() {
        this.buildWalls();
        if (this.node.getState() != CastleNodeState.ROOM) {
            this.buildConnections();
        }
        this.buildDoors();
        this.buildWindows();
        if (this.node.getState() != CastleNodeState.ROOM) {
            this.buildCorners();
        }
    }

    private void buildCorners() {
        int y;
        for (y = 0; y < 4; ++y) {
            this.editor.setBlock(new Coord(3, y, 3), BlockType.WALL);
        }
        this.editor.setBlock(new Coord(3, 4, 3), BlockType.WALL_FRAME);
        for (y = 0; y < 4; ++y) {
            this.editor.setBlock(new Coord(-3, y, 3), BlockType.WALL);
        }
        this.editor.setBlock(new Coord(-3, 4, 3), BlockType.WALL_FRAME);
        for (y = 0; y < 4; ++y) {
            this.editor.setBlock(new Coord(3, y, -3), BlockType.WALL);
        }
        this.editor.setBlock(new Coord(3, 4, -3), BlockType.WALL_FRAME);
        for (y = 0; y < 4; ++y) {
            this.editor.setBlock(new Coord(-3, y, -3), BlockType.WALL);
        }
        this.editor.setBlock(new Coord(-3, 4, -3), BlockType.WALL_FRAME);
    }

    private void buildWalls() {
        int x;
        int z;
        int y;
        int z2;
        int x2;
        boolean tower;
        if (!this.node.getConnections().isPositiveX()) {
            tower = this.isColumnTower() && this.isEmptyOrWalkAtOffset(1, 0);
            x2 = 3;
            for (z2 = -3; z2 <= 3; ++z2) {
                if (!tower || z2 <= -2 || z2 >= 2) {
                    for (y = 0; y < 4; ++y) {
                        this.editor.setBlock(new Coord(x2, y, z2), BlockType.WALL);
                    }
                    this.editor.setBlock(new Coord(x2, 4, z2), BlockType.WALL_FRAME);
                }
                if (tower && z2 >= -2 && z2 <= 2) {
                    for (y = 0; y < 4; ++y) {
                        this.editor.setBlock(new Coord(x2 + 1, y, z2), BlockType.WALL);
                    }
                    this.editor.setBlock(new Coord(x2 + 1, 4, z2), BlockType.WALL_FRAME);
                }
                if (!tower || z2 < -1 || z2 > 1) continue;
                this.editor.setBlock(new Coord(x2, 4, z2), BlockType.WALL);
                this.editor.setBlock(new Coord(x2, 3, z2), BlockType.WALL_BOTTOM_NEGATIVE_X);
                this.editor.setBlock(new Coord(x2, 1, z2), BlockType.WALL_TOP_NEGATIVE_X);
                this.editor.setBlock(new Coord(x2, 0, z2), BlockType.WALL);
            }
        }
        if (!this.node.getConnections().isPositiveY()) {
            tower = this.isColumnTower() && this.isEmptyOrWalkAtOffset(0, 1);
            z = 3;
            for (x = -3; x <= 3; ++x) {
                if (!tower || x <= -2 || x >= 2) {
                    for (y = 0; y < 4; ++y) {
                        this.editor.setBlock(new Coord(x, y, z), BlockType.WALL);
                    }
                    this.editor.setBlock(new Coord(x, 4, z), BlockType.WALL_FRAME);
                }
                if (tower && x >= -2 && x <= 2) {
                    for (y = 0; y < 4; ++y) {
                        this.editor.setBlock(new Coord(x, y, z + 1), BlockType.WALL);
                    }
                    this.editor.setBlock(new Coord(x, 4, z + 1), BlockType.WALL_FRAME);
                }
                if (!tower || x < -1 || x > 1) continue;
                this.editor.setBlock(new Coord(x, 4, z), BlockType.WALL);
                this.editor.setBlock(new Coord(x, 3, z), BlockType.WALL_BOTTOM_NEGATIVE_Z);
                this.editor.setBlock(new Coord(x, 1, z), BlockType.WALL_TOP_NEGATIVE_Z);
                this.editor.setBlock(new Coord(x, 0, z), BlockType.WALL);
            }
        }
        if (!this.node.getConnections().isNegativeX()) {
            tower = this.isColumnTower() && this.isEmptyOrWalkAtOffset(-1, 0);
            x2 = -3;
            for (z2 = -3; z2 <= 3; ++z2) {
                if (!tower || z2 <= -2 || z2 >= 2) {
                    for (y = 0; y < 4; ++y) {
                        this.editor.setBlock(new Coord(x2, y, z2), BlockType.WALL);
                    }
                    this.editor.setBlock(new Coord(x2, 4, z2), BlockType.WALL_FRAME);
                }
                if (tower && z2 >= -2 && z2 <= 2) {
                    for (y = 0; y < 4; ++y) {
                        this.editor.setBlock(new Coord(x2 - 1, y, z2), BlockType.WALL);
                    }
                    this.editor.setBlock(new Coord(x2 - 1, 4, z2), BlockType.WALL_FRAME);
                }
                if (!tower || z2 < -1 || z2 > 1) continue;
                this.editor.setBlock(new Coord(x2, 4, z2), BlockType.WALL);
                this.editor.setBlock(new Coord(x2, 3, z2), BlockType.WALL_BOTTOM_POSITIVE_X);
                this.editor.setBlock(new Coord(x2, 1, z2), BlockType.WALL_TOP_POSITIVE_X);
                this.editor.setBlock(new Coord(x2, 0, z2), BlockType.WALL);
            }
        }
        if (!this.node.getConnections().isNegativeY()) {
            tower = this.isColumnTower() && this.isEmptyOrWalkAtOffset(0, -1);
            z = -3;
            for (x = -3; x <= 3; ++x) {
                if (!tower || x <= -2 || x >= 2) {
                    for (y = 0; y < 4; ++y) {
                        this.editor.setBlock(new Coord(x, y, z), BlockType.WALL);
                    }
                    this.editor.setBlock(new Coord(x, 4, z), BlockType.WALL_FRAME);
                }
                if (tower && x >= -2 && x <= 2) {
                    for (y = 0; y < 4; ++y) {
                        this.editor.setBlock(new Coord(x, y, z - 1), BlockType.WALL);
                    }
                    this.editor.setBlock(new Coord(x, 4, z - 1), BlockType.WALL_FRAME);
                }
                if (!tower || x < -1 || x > 1) continue;
                this.editor.setBlock(new Coord(x, 4, z), BlockType.WALL);
                this.editor.setBlock(new Coord(x, 3, z), BlockType.WALL_BOTTOM_POSITIVE_Z);
                this.editor.setBlock(new Coord(x, 1, z), BlockType.WALL_TOP_POSITIVE_Z);
                this.editor.setBlock(new Coord(x, 0, z), BlockType.WALL);
            }
        }
    }

    private void buildConnections() {
        int x;
        int z;
        int y;
        int z2;
        int x2;
        int limit;
        int n = limit = this.isColumnTower() ? 4 : 3;
        if (this.node.getConnections().isPositiveX()) {
            for (x2 = 3; x2 <= limit; ++x2) {
                for (z2 = -2; z2 <= 2; ++z2) {
                    this.editor.setBlock(new Coord(x2, 0, z2), BlockType.FLOOR_0);
                    this.editor.setBlock(new Coord(x2, 4, z2), BlockType.WALL_FRAME);
                }
                for (y = 0; y < 4; ++y) {
                    this.editor.setBlock(new Coord(x2, y, 2), BlockType.WALL);
                    this.editor.setBlock(new Coord(x2, y, -2), BlockType.WALL);
                }
            }
        }
        if (this.node.getConnections().isPositiveY()) {
            for (z = 3; z <= limit; ++z) {
                for (x = -2; x <= 2; ++x) {
                    this.editor.setBlock(new Coord(x, 0, z), BlockType.FLOOR_0);
                    this.editor.setBlock(new Coord(x, 4, z), BlockType.WALL_FRAME);
                }
                for (y = 0; y < 4; ++y) {
                    this.editor.setBlock(new Coord(2, y, z), BlockType.WALL);
                    this.editor.setBlock(new Coord(-2, y, z), BlockType.WALL);
                }
            }
        }
        if (this.node.getConnections().isNegativeX()) {
            for (x2 = -3; x2 >= -limit; --x2) {
                for (z2 = -2; z2 <= 2; ++z2) {
                    this.editor.setBlock(new Coord(x2, 0, z2), BlockType.FLOOR_0);
                    this.editor.setBlock(new Coord(x2, 4, z2), BlockType.WALL_FRAME);
                }
                for (y = 0; y < 4; ++y) {
                    this.editor.setBlock(new Coord(x2, y, 2), BlockType.WALL);
                    this.editor.setBlock(new Coord(x2, y, -2), BlockType.WALL);
                }
            }
        }
        if (this.node.getConnections().isNegativeY()) {
            for (z = -3; z >= -limit; --z) {
                for (x = -2; x <= 2; ++x) {
                    this.editor.setBlock(new Coord(x, 0, z), BlockType.FLOOR_0);
                    this.editor.setBlock(new Coord(x, 4, z), BlockType.WALL_FRAME);
                }
                for (y = 0; y < 4; ++y) {
                    this.editor.setBlock(new Coord(2, y, z), BlockType.WALL);
                    this.editor.setBlock(new Coord(-2, y, z), BlockType.WALL);
                }
            }
        }
    }

    private void buildDoors() {
        int x;
        int z;
        int y;
        int z2;
        int x2;
        if (this.node.getDoors().isPositiveX()) {
            x2 = 3;
            for (z2 = -2; z2 <= 2; ++z2) {
                this.editor.setBlock(new Coord(x2, 0, z2), BlockType.FLOOR_0);
                for (y = 1; y < 4; ++y) {
                    this.editor.setBlock(new Coord(x2, y, z2), BlockType.WALL);
                }
                this.editor.setBlock(new Coord(x2, 4, z2), BlockType.WALL_FRAME);
            }
            this.editor.setBlock(new Coord(3, 1, 0), BlockType.DOOR_X);
        }
        if (this.node.getDoors().isPositiveY()) {
            z = 3;
            for (x = -2; x <= 2; ++x) {
                this.editor.setBlock(new Coord(x, 0, z), BlockType.FLOOR_0);
                for (y = 1; y < 4; ++y) {
                    this.editor.setBlock(new Coord(x, y, z), BlockType.WALL);
                }
                this.editor.setBlock(new Coord(x, 4, z), BlockType.WALL_FRAME);
            }
            this.editor.setBlock(new Coord(0, 1, 3), BlockType.DOOR_Y);
        }
        if (this.node.getDoors().isNegativeX()) {
            x2 = -3;
            for (z2 = -2; z2 <= 2; ++z2) {
                this.editor.setBlock(new Coord(x2, 0, z2), BlockType.FLOOR_0);
                for (y = 1; y < 4; ++y) {
                    this.editor.setBlock(new Coord(x2, y, z2), BlockType.WALL);
                }
                this.editor.setBlock(new Coord(x2, 4, z2), BlockType.WALL_FRAME);
            }
            this.editor.setBlock(new Coord(-3, 1, 0), BlockType.DOOR_X);
        }
        if (this.node.getDoors().isNegativeY()) {
            z = -3;
            for (x = -2; x <= 2; ++x) {
                this.editor.setBlock(new Coord(x, 0, z), BlockType.FLOOR_0);
                for (y = 1; y < 4; ++y) {
                    this.editor.setBlock(new Coord(x, y, z), BlockType.WALL);
                }
                this.editor.setBlock(new Coord(x, 4, z), BlockType.WALL_FRAME);
            }
            this.editor.setBlock(new Coord(0, 1, -3), BlockType.DOOR_Y);
        }
    }

    private void buildWindows() {
        int offset;
        int n = offset = this.isColumnTower() ? 4 : 3;
        if (this.node.getWindows().isPositiveX()) {
            this.editor.setBlock(new Coord(offset, 2, 0), BlockType.WINDOW);
        }
        if (this.node.getWindows().isPositiveY()) {
            this.editor.setBlock(new Coord(0, 2, offset), BlockType.WINDOW);
        }
        if (this.node.getWindows().isNegativeX()) {
            this.editor.setBlock(new Coord(-offset, 2, 0), BlockType.WINDOW);
        }
        if (this.node.getWindows().isNegativeY()) {
            this.editor.setBlock(new Coord(0, 2, -offset), BlockType.WINDOW);
        }
    }
}

