/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle.builder.rooms;

import java.util.Random;
import net.puffish.castle.builder.BlockType;
import net.puffish.castle.builder.Coord;
import net.puffish.castle.builder.EntityType;
import net.puffish.castle.builder.WorldEditor;
import net.puffish.castle.builder.rooms.Room;

public class JainRoom
extends Room {
    public JainRoom(int maxCount) {
        super(2, 2, 1, maxCount);
        this.getConnection(0, 0, 0).setNegativeX(true);
        this.getConnection(1, 0, 0).setPositiveX(true);
    }

    @Override
    public void build(WorldEditor editor, Random random) {
        int y;
        int w = this.getWidthInBlocks();
        int h = this.getHeightInBlocks();
        for (int x = 0; x < w; ++x) {
            for (int z = 0; z < h; ++z) {
                editor.setBlock(new Coord(x, 0, z), BlockType.FLOOR_0);
                editor.setBlock(new Coord(x, 4, z), BlockType.CEIL);
            }
            for (y = 1; y < 4; ++y) {
                editor.setBlock(new Coord(x, y, 5), BlockType.JAIL_BARS);
            }
        }
        for (int z = 6; z < h; ++z) {
            for (y = 1; y < 4; ++y) {
                editor.setBlock(new Coord(5, y, z), BlockType.JAIL_BARS);
            }
        }
        editor.spawnEntity(new Coord(2, 1, 8), EntityType.ZOMBIE_VILLAGER);
        editor.spawnEntity(new Coord(8, 1, 8), EntityType.ZOMBIE_VILLAGER);
    }
}

