/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle.builder.rooms;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.puffish.castle.builder.BlockType;
import net.puffish.castle.builder.Coord;
import net.puffish.castle.builder.EntityType;
import net.puffish.castle.builder.WorldEditor;
import net.puffish.castle.builder.rooms.Room;

public class SpiderRoom
extends Room {
    public SpiderRoom(int maxCount) {
        super(2, 2, 1, maxCount);
        this.getConnection(0, 0, 0).setNegativeX(true);
        this.getConnection(0, 0, 0).setNegativeY(true);
        this.getConnection(1, 0, 0).setPositiveX(true);
        this.getConnection(1, 0, 0).setNegativeY(true);
        this.getConnection(0, 1, 0).setNegativeX(true);
        this.getConnection(0, 1, 0).setPositiveY(true);
        this.getConnection(1, 1, 0).setPositiveX(true);
        this.getConnection(1, 1, 0).setPositiveY(true);
    }

    @Override
    public void build(WorldEditor editor, Random random) {
        int w = this.getWidthInBlocks();
        int h = this.getHeightInBlocks();
        for (int x = 0; x < w; ++x) {
            for (int z = 0; z < h; ++z) {
                editor.setBlock(new Coord(x, 0, z), BlockType.FLOOR_0);
                editor.setBlock(new Coord(x, 4, z), BlockType.CEIL);
                for (int y = 1; y < 4; ++y) {
                    if (random.nextInt(5) >= 3) continue;
                    editor.setBlock(new Coord(x, y, z), BlockType.COBWEB);
                }
            }
        }
        List<Coord> coords = Arrays.asList(new Coord(3, 1, 3), new Coord(7, 1, 3), new Coord(3, 1, 7), new Coord(7, 1, 7));
        Collections.shuffle(coords);
        for (int i = 0; i < 2; ++i) {
            editor.setSpawner(coords.get(i), EntityType.CAVE_SPIDER);
        }
    }
}

