/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle.config;

import java.io.File;
import net.puffish.castle.config.CfgFile;

public class Config {
    private int maxTerrainHeight;
    private int minTerrainHeight;
    private int spacing;
    private int separation;
    private int spawnerChance;
    private int chestChance;
    private int maxCastleSize;
    private int minCastleSize;
    private String spawnerLogic;

    public Config(File file) {
        CfgFile cfg = new CfgFile(file);
        cfg.setDefault("min-terrain-height", 16);
        cfg.setDefault("max-terrain-height", 128);
        cfg.setDefault("spacing", 64);
        cfg.setDefault("separation", 8);
        cfg.setDefault("min-castle-size", 6);
        cfg.setDefault("max-castle-size", 8);
        cfg.setDefault("spawner-chance", "40%");
        cfg.setDefault("chest-chance", "10%");
        cfg.setDefault("spawner-logic", "");
        this.minTerrainHeight = cfg.getInt("min-terrain-height");
        this.maxTerrainHeight = cfg.getInt("max-terrain-height");
        this.spacing = cfg.getInt("spacing");
        this.separation = cfg.getInt("separation");
        if (this.spacing < 1) {
            this.spacing = 1;
            cfg.set("spacing", this.spacing);
        }
        if (this.separation > this.spacing - 1) {
            this.separation = this.spacing - 1;
            cfg.set("separation", this.separation);
        }
        this.spawnerChance = this.parseIntPercent(cfg, "spawner-chance");
        this.chestChance = this.parseIntPercent(cfg, "chest-chance");
        this.minCastleSize = cfg.getInt("min-castle-size");
        this.maxCastleSize = cfg.getInt("max-castle-size");
        if (this.minCastleSize < 1) {
            this.minCastleSize = 1;
            cfg.set("min-castle-size", this.minCastleSize);
        }
        this.spawnerLogic = cfg.getString("spawner-logic");
        cfg.saveChanges();
    }

    private int parseIntPercent(CfgFile cfg, String key) {
        String value = cfg.getString(key);
        if (value.endsWith("%")) {
            int percent = -1;
            try {
                percent = Integer.parseInt(value.substring(0, value.length() - 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (percent >= 0 && percent <= 100) {
                return percent;
            }
        }
        cfg.restoreDefault(key);
        return this.parseIntPercent(cfg, key);
    }

    public int getMaxTerrainHeight() {
        return this.maxTerrainHeight;
    }

    public int getMinTerrainHeight() {
        return this.minTerrainHeight;
    }

    public int getSpacing() {
        return this.spacing;
    }

    public int getSeparation() {
        return this.separation;
    }

    public int getSpawnerChance() {
        return this.spawnerChance;
    }

    public int getChestChance() {
        return this.chestChance;
    }

    public int getMaxCastleSize() {
        return this.maxCastleSize;
    }

    public int getMinCastleSize() {
        return this.minCastleSize;
    }

    public String getSpawnerLogic() {
        return this.spawnerLogic;
    }
}

