/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle.generator;

import net.puffish.castle.generator.CastleRoom;
import net.puffish.castle.generator.Direction;
import net.puffish.castle.generator.Rotation;

public class CastleArea {
    private int x;
    private int y;
    private int level;
    private Rotation rotation;
    private CastleRoom room;
    private Direction[][][] connections;

    public CastleArea(int x, int y, int level, Rotation rotation, CastleRoom room) {
        this.x = x;
        this.y = y;
        this.level = level;
        this.rotation = rotation;
        this.room = room;
        this.connections = new Direction[room.getWidth()][room.getHeight()][room.getLevels()];
        for (int i = 0; i < room.getWidth(); ++i) {
            for (int j = 0; j < room.getHeight(); ++j) {
                for (int k = 0; k < room.getLevels(); ++k) {
                    this.connections[i][j][k] = new Direction();
                }
            }
        }
    }

    public Direction getConnection(int x, int y, int level) {
        return this.connections[x][y][level];
    }

    public CastleRoom getRoom() {
        return this.room;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getLevel() {
        return this.level;
    }

    public Rotation getRotation() {
        return this.rotation;
    }
}

