/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle.generator;

import net.puffish.castle.generator.CastleNodeState;
import net.puffish.castle.generator.Direction;

public class CastleNode {
    private int x;
    private int y;
    private boolean visited;
    private Direction connections = new Direction();
    private Direction temporaryConnections = new Direction();
    private Direction optionalConnections = new Direction();
    private Direction temporaryOptionalConnections = new Direction();
    private Direction doors = new Direction();
    private Direction windows = new Direction();
    private CastleNodeState state = CastleNodeState.EMPTY;
    private CastleNodeState temporaryState = CastleNodeState.EMPTY;
    private boolean stairs = false;
    private boolean entrance = false;
    private boolean stairsBelow = false;
    private int level;

    public CastleNode(int x, int y, int level) {
        this.x = x;
        this.y = y;
        this.level = level;
    }

    public boolean isVisited() {
        return this.visited;
    }

    public void setVisited(boolean visited) {
        this.visited = visited;
    }

    public boolean isStairsBelow() {
        return this.stairsBelow;
    }

    public void setStairsBelow(boolean stairsBelow) {
        this.stairsBelow = stairsBelow;
    }

    public Direction getTemporaryConnections() {
        return this.temporaryConnections;
    }

    public Direction getTemporaryOptionalConnections() {
        return this.temporaryOptionalConnections;
    }

    public Direction getConnections() {
        return this.connections;
    }

    public Direction getOptionalConnections() {
        return this.optionalConnections;
    }

    public Direction getDoors() {
        return this.doors;
    }

    public Direction getWindows() {
        return this.windows;
    }

    public void applyTemporaryChanges() {
        this.connections = new Direction(this.temporaryConnections);
        this.optionalConnections = new Direction(this.temporaryOptionalConnections);
        this.state = this.temporaryState;
    }

    public void resetTemporaryChanges() {
        this.temporaryConnections = new Direction(this.connections);
        this.temporaryOptionalConnections = new Direction(this.optionalConnections);
        this.temporaryState = this.state;
    }

    public void setEntrance(boolean entrance) {
        this.entrance = entrance;
    }

    public boolean isEntrance() {
        return this.entrance;
    }

    public void setStairs(boolean stairs) {
        this.stairs = stairs;
    }

    public boolean isStairs() {
        return this.stairs;
    }

    public void setState(CastleNodeState state) {
        this.state = state;
    }

    public CastleNodeState getState() {
        return this.state;
    }

    public void setTemporaryState(CastleNodeState temporaryState) {
        this.temporaryState = temporaryState;
    }

    public CastleNodeState getTemporaryState() {
        return this.temporaryState;
    }

    public int getLevel() {
        return this.level;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }
}

