/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.puffish.castle.CastleDungeons;
import net.puffish.castle.builder.BlockGroup;
import net.puffish.castle.builder.BlockType;
import net.puffish.castle.builder.ChestType;
import net.puffish.castle.builder.Coord;
import net.puffish.castle.builder.EntityType;
import net.puffish.castle.builder.WorldEditor;
import net.puffish.castle.config.Theme;

public class WorldEditorImpl
extends WorldEditor {
    private CastleDungeons castleDungeons;
    private ServerLevel world;
    private Theme<Block> theme;
    private Random random;
    private static final Block[] BEDS = new Block[]{Blocks.f_50066_, Blocks.f_50067_, Blocks.f_50068_, Blocks.f_50017_, Blocks.f_50018_, Blocks.f_50019_, Blocks.f_50020_, Blocks.f_50021_, Blocks.f_50022_, Blocks.f_50023_, Blocks.f_50024_, Blocks.f_50025_, Blocks.f_50026_, Blocks.f_50027_, Blocks.f_50028_, Blocks.f_50029_};

    public WorldEditorImpl(CastleDungeons castleDungeons, ServerLevel world, Theme<Block> theme, Random random) {
        this.castleDungeons = castleDungeons;
        this.world = world;
        this.theme = theme;
        this.random = random;
    }

    @Override
    public boolean setBlockIfEmpty(Coord coord, BlockType type) {
        if (coord.getY() < this.world.m_141937_()) {
            return false;
        }
        BlockPos pos = new BlockPos(coord.getX(), coord.getY(), coord.getZ());
        if (this.world.m_8055_(pos).m_60804_((BlockGetter)this.world, pos)) {
            return false;
        }
        this.setBlock(coord, type);
        return true;
    }

    private void placeBed(Coord coord, Random random, Direction facing) {
        try {
            Block bedBlock = BEDS[random.nextInt(BEDS.length)];
            BlockState state = bedBlock.m_49966_();
            state = (BlockState)state.m_61124_((Property)BedBlock.f_49440_, (Comparable)BedPart.HEAD);
            state = (BlockState)state.m_61124_((Property)BedBlock.f_54117_, (Comparable)facing);
            BlockPos pos = new BlockPos(coord.getX(), coord.getY(), coord.getZ());
            this.world.m_46597_(pos, state);
            pos = pos.m_121945_(facing.m_122424_());
            state = bedBlock.m_49966_();
            state = (BlockState)state.m_61124_((Property)BedBlock.f_49440_, (Comparable)BedPart.FOOT);
            state = (BlockState)state.m_61124_((Property)BedBlock.f_54117_, (Comparable)facing);
            this.world.m_46597_(pos, state);
        }
        catch (Exception e) {
            CastleDungeons.LOGGER.warn("An error occurred while placing bed!", (Throwable)e);
        }
    }

    private void placeDoor(Coord coord, Block block, Direction facing) {
        try {
            BlockState state = block.m_49966_();
            state = (BlockState)state.m_61124_((Property)DoorBlock.f_52726_, (Comparable)facing);
            state = (BlockState)state.m_61124_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.LOWER);
            BlockPos pos = new BlockPos(coord.getX(), coord.getY(), coord.getZ());
            this.world.m_46597_(pos, state);
            pos = pos.m_7494_();
            state = block.m_49966_();
            state = (BlockState)state.m_61124_((Property)DoorBlock.f_52726_, (Comparable)facing);
            state = (BlockState)state.m_61124_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.UPPER);
            this.world.m_46597_(pos, state);
        }
        catch (Exception e) {
            CastleDungeons.LOGGER.warn("An error occurred while placing door!", (Throwable)e);
        }
    }

    @Override
    public BlockGroup createGroup() {
        return new BlockGroupImpl(this.random.nextLong());
    }

    @Override
    public void setBlock(Coord coord, BlockType type, BlockGroup group) {
        Random random = null;
        random = group != null && group instanceof BlockGroupImpl ? new Random(((BlockGroupImpl)group).getSeed()) : this.random;
        try {
            switch (type) {
                case BED_NEGATIVE_X: {
                    this.placeBed(coord, random, Direction.EAST);
                    break;
                }
                case BED_NEGATIVE_Z: {
                    this.placeBed(coord, random, Direction.SOUTH);
                    break;
                }
                case BED_POSITIVE_X: {
                    this.placeBed(coord, random, Direction.WEST);
                    break;
                }
                case BED_POSITIVE_Z: {
                    this.placeBed(coord, random, Direction.NORTH);
                    break;
                }
                case DOOR_X: {
                    this.setBlock(coord, Blocks.f_50016_);
                    this.setBlock(Coord.add(coord, 0, 1, 0), Blocks.f_50016_);
                    if (random.nextInt(2) == 0) {
                        this.placeDoor(coord, this.getRandom(this.theme.getDoorBlocks(), random), Direction.EAST);
                        break;
                    }
                    this.placeDoor(coord, this.getRandom(this.theme.getDoorBlocks(), random), Direction.WEST);
                    break;
                }
                case DOOR_Y: {
                    this.setBlock(coord, Blocks.f_50016_);
                    this.setBlock(Coord.add(coord, 0, 1, 0), Blocks.f_50016_);
                    if (random.nextInt(2) == 0) {
                        this.placeDoor(coord, this.getRandom(this.theme.getDoorBlocks(), random), Direction.SOUTH);
                        break;
                    }
                    this.placeDoor(coord, this.getRandom(this.theme.getDoorBlocks(), random), Direction.NORTH);
                    break;
                }
                case WALL: {
                    this.setBlock(coord, this.getRandom(this.theme.getWallBlocks(), random));
                    break;
                }
                case WALL_FRAME: {
                    this.setBlock(coord, this.getRandom(this.theme.getWallFrameBlocks(), random));
                    break;
                }
                case FLOOR_0: {
                    this.setBlock(coord, this.getRandom(this.theme.getFloor0Blocks(), random));
                    break;
                }
                case FLOOR_1: {
                    this.setBlock(coord, this.getRandom(this.theme.getFloor1Blocks(), random));
                    break;
                }
                case PILLAR_0: {
                    this.setBlock(coord, this.getRandom(this.theme.getPillar0Blocks(), random));
                    break;
                }
                case PILLAR_1: {
                    this.setBlock(coord, this.getRandom(this.theme.getPillar1Blocks(), random));
                    break;
                }
                case FENCE_0: {
                    this.setBlock(coord, this.getRandom(this.theme.getFence0Blocks(), random));
                    break;
                }
                case FENCE_1: {
                    this.setBlock(coord, this.getRandom(this.theme.getFence1Blocks(), random));
                    break;
                }
                case ROOF_NEGATIVE_X: {
                    this.setStairsBlock(coord, this.getRandom(this.theme.getRoofStairsBlocks(), random), Direction.EAST, StairsShape.STRAIGHT);
                    break;
                }
                case ROOF_NEGATIVE_X_NEGATIVE_Z: {
                    this.setStairsBlock(coord, this.getRandom(this.theme.getRoofStairsBlocks(), random), Direction.SOUTH, StairsShape.OUTER_LEFT);
                    break;
                }
                case ROOF_NEGATIVE_X_POSITIVE_Z: {
                    this.setStairsBlock(coord, this.getRandom(this.theme.getRoofStairsBlocks(), random), Direction.NORTH, StairsShape.OUTER_RIGHT);
                    break;
                }
                case ROOF_NEGATIVE_Z: {
                    this.setStairsBlock(coord, this.getRandom(this.theme.getRoofStairsBlocks(), random), Direction.SOUTH, StairsShape.STRAIGHT);
                    break;
                }
                case ROOF_POSITIVE_X: {
                    this.setStairsBlock(coord, this.getRandom(this.theme.getRoofStairsBlocks(), random), Direction.WEST, StairsShape.STRAIGHT);
                    break;
                }
                case ROOF_POSITIVE_X_NEGATIVE_Z: {
                    this.setStairsBlock(coord, this.getRandom(this.theme.getRoofStairsBlocks(), random), Direction.SOUTH, StairsShape.OUTER_RIGHT);
                    break;
                }
                case ROOF_POSITIVE_X_POSITIVE_Z: {
                    this.setStairsBlock(coord, this.getRandom(this.theme.getRoofStairsBlocks(), random), Direction.NORTH, StairsShape.OUTER_LEFT);
                    break;
                }
                case ROOF_POSITIVE_Z: {
                    this.setStairsBlock(coord, this.getRandom(this.theme.getRoofStairsBlocks(), random), Direction.NORTH, StairsShape.STRAIGHT);
                    break;
                }
                case ROOF: {
                    this.setBlock(coord, this.getRandom(this.theme.getRoofBlockBlocks(), random));
                    break;
                }
                case ROOF_TOP: {
                    this.setBlock(coord, this.getRandom(this.theme.getRoofSlabBlocks(), random));
                    break;
                }
                case STAIRS_0: {
                    this.setSlabBlock(coord, this.getRandom(this.theme.getSpiralStairsBlocks(), random), SlabType.BOTTOM);
                    break;
                }
                case STAIRS_1: {
                    this.setSlabBlock(coord, this.getRandom(this.theme.getSpiralStairsBlocks(), random), SlabType.TOP);
                    break;
                }
                case WINDOW: {
                    this.setBlock(coord, this.getRandom(this.theme.getWindowBlocks(), random));
                    break;
                }
                case CEIL: {
                    this.setBlock(coord, this.getRandom(this.theme.getCeilBlocks(), random));
                    break;
                }
                case FOUNDATION: {
                    this.setBlock(coord, this.getRandom(this.theme.getFoundationBlocks(), random));
                    break;
                }
                case STORAGE_ROOM_BLOCK: {
                    this.setBlock(coord, this.getRandom(this.theme.getStorageRoomBlocks(), random));
                    break;
                }
                case JAIL_BARS: {
                    this.setBlock(coord, Blocks.f_50183_);
                    break;
                }
                case FURNACE_NEGATIVE_X: {
                    this.setFurnaceBlock(coord, Blocks.f_50094_, Direction.WEST);
                    break;
                }
                case FURNACE_NEGATIVE_Z: {
                    this.setFurnaceBlock(coord, Blocks.f_50094_, Direction.NORTH);
                    break;
                }
                case FURNACE_POSITIVE_X: {
                    this.setFurnaceBlock(coord, Blocks.f_50094_, Direction.EAST);
                    break;
                }
                case FURNACE_POSITIVE_Z: {
                    this.setFurnaceBlock(coord, Blocks.f_50094_, Direction.SOUTH);
                    break;
                }
                case ANVIL: {
                    this.setBlock(coord, Blocks.f_50322_);
                    break;
                }
                case BOOKSHELF: {
                    this.setBlock(coord, Blocks.f_50078_);
                    break;
                }
                case ENCHANTING_TABLE: {
                    this.setBlock(coord, Blocks.f_50201_);
                    break;
                }
                case COBWEB: {
                    this.setBlock(coord, Blocks.f_50033_);
                    break;
                }
                case EMPTY: {
                    this.setBlock(coord, this.getRandom(this.theme.getAirBlocks(), random));
                    break;
                }
                case WALL_BOTTOM_NEGATIVE_X: {
                    this.setStairsBlock(coord, this.getRandom(this.theme.getWallStairsBlocks(), random), Direction.EAST, StairsShape.STRAIGHT, Half.TOP);
                    break;
                }
                case WALL_BOTTOM_NEGATIVE_Z: {
                    this.setStairsBlock(coord, this.getRandom(this.theme.getWallStairsBlocks(), random), Direction.SOUTH, StairsShape.STRAIGHT, Half.TOP);
                    break;
                }
                case WALL_BOTTOM_POSITIVE_X: {
                    this.setStairsBlock(coord, this.getRandom(this.theme.getWallStairsBlocks(), random), Direction.WEST, StairsShape.STRAIGHT, Half.TOP);
                    break;
                }
                case WALL_BOTTOM_POSITIVE_Z: {
                    this.setStairsBlock(coord, this.getRandom(this.theme.getWallStairsBlocks(), random), Direction.NORTH, StairsShape.STRAIGHT, Half.TOP);
                    break;
                }
                case WALL_TOP: {
                    this.setBlock(coord, this.getRandom(this.theme.getWallSlabBlocks(), random));
                    break;
                }
                case WALL_TOP_NEGATIVE_X: {
                    this.setStairsBlock(coord, this.getRandom(this.theme.getWallStairsBlocks(), random), Direction.EAST, StairsShape.STRAIGHT, Half.BOTTOM);
                    break;
                }
                case WALL_TOP_NEGATIVE_Z: {
                    this.setStairsBlock(coord, this.getRandom(this.theme.getWallStairsBlocks(), random), Direction.SOUTH, StairsShape.STRAIGHT, Half.BOTTOM);
                    break;
                }
                case WALL_TOP_POSITIVE_X: {
                    this.setStairsBlock(coord, this.getRandom(this.theme.getWallStairsBlocks(), random), Direction.WEST, StairsShape.STRAIGHT, Half.BOTTOM);
                    break;
                }
                case WALL_TOP_POSITIVE_Z: {
                    this.setStairsBlock(coord, this.getRandom(this.theme.getWallStairsBlocks(), random), Direction.NORTH, StairsShape.STRAIGHT, Half.BOTTOM);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Block getRandom(List<Block> blocks, Random random) {
        if (blocks.isEmpty()) {
            return Blocks.f_50016_;
        }
        return blocks.get(random.nextInt(blocks.size()));
    }

    public void setBlock(Coord coord, Block block) {
        this.setBlockState(new BlockPos(coord.getX(), coord.getY(), coord.getZ()), block.m_49966_());
    }

    public void setFurnaceBlock(Coord coord, Block block, Direction facing) {
        try {
            BlockState state = block.m_49966_();
            state = (BlockState)state.m_61124_((Property)FurnaceBlock.f_48683_, (Comparable)facing);
            this.setBlockState(new BlockPos(coord.getX(), coord.getY(), coord.getZ()), state);
        }
        catch (Exception e) {
            CastleDungeons.LOGGER.warn("An error occurred while placing furnace!", (Throwable)e);
        }
    }

    public void setStairsBlock(Coord coord, Block block, Direction facing, StairsShape shape) {
        this.setStairsBlock(coord, block, facing, shape, null);
    }

    public void setStairsBlock(Coord coord, Block block, Direction facing, StairsShape shape, Half half) {
        try {
            BlockState state = block.m_49966_();
            state = (BlockState)state.m_61124_((Property)StairBlock.f_56841_, (Comparable)facing);
            state = (BlockState)state.m_61124_((Property)StairBlock.f_56843_, (Comparable)shape);
            if (half != null) {
                state = (BlockState)state.m_61124_((Property)StairBlock.f_56842_, (Comparable)half);
            }
            this.setBlockState(new BlockPos(coord.getX(), coord.getY(), coord.getZ()), state);
        }
        catch (Exception e) {
            CastleDungeons.LOGGER.warn("An error occurred while placing stairs!", (Throwable)e);
        }
    }

    public void setSlabBlock(Coord coord, Block block, SlabType half) {
        try {
            BlockState state = block.m_49966_();
            state = (BlockState)state.m_61124_((Property)SlabBlock.f_56353_, (Comparable)half);
            this.setBlockState(new BlockPos(coord.getX(), coord.getY(), coord.getZ()), state);
        }
        catch (Exception e) {
            CastleDungeons.LOGGER.warn("An error occurred while placing slab!", (Throwable)e);
        }
    }

    @Override
    public void setChest(Coord coord, ChestType type, int level) {
        try {
            BlockPos pos = new BlockPos(coord.getX(), coord.getY(), coord.getZ());
            this.setBlockState(pos, Blocks.f_50087_.m_49966_());
            String lootTable = null;
            switch (type) {
                case LOOT: {
                    lootTable = this.theme.findLootChest(level);
                    break;
                }
                case HEAL: {
                    lootTable = this.theme.findHealChest(level);
                    break;
                }
                case JUNK: {
                    lootTable = this.theme.findJunkChest(level);
                }
            }
            long seed = this.random.nextLong();
            if (lootTable != null) {
                ChestBlockEntity chest = (ChestBlockEntity)this.world.m_7702_(pos);
                chest.m_59626_(new ResourceLocation(lootTable), seed);
            }
        }
        catch (Exception e) {
            CastleDungeons.LOGGER.warn("An error occurred while placing chest!", (Throwable)e);
        }
    }

    @Override
    public void setSpawner(Coord coord, int level) {
        try {
            List<String> list = this.theme.findMobs(level);
            if (list == null) {
                return;
            }
            if (list.isEmpty()) {
                return;
            }
            String mob = list.get(this.random.nextInt(list.size()));
            BlockPos pos = new BlockPos(coord.getX(), coord.getY(), coord.getZ());
            this.setBlockState(pos, Blocks.f_50085_.m_49966_());
            SpawnerBlockEntity spawner = (SpawnerBlockEntity)this.world.m_7702_(pos);
            CompoundTag nbt = null;
            try {
                nbt = TagParser.m_129359_((String)this.castleDungeons.getConfig().getSpawnerLogic());
            }
            catch (Exception e) {
                nbt = new CompoundTag();
            }
            CompoundTag entity = null;
            int index = mob.indexOf("{");
            if (index == -1) {
                entity = new CompoundTag();
                entity.m_128359_("id", mob);
            } else {
                try {
                    entity = TagParser.m_129359_((String)mob.substring(index, mob.length()));
                }
                catch (Exception e) {
                    entity = new CompoundTag();
                }
                entity.m_128359_("id", mob.substring(0, index));
            }
            CompoundTag spawnData = new CompoundTag();
            spawnData.m_128365_("entity", (Tag)entity);
            nbt.m_128365_("SpawnData", (Tag)spawnData);
            nbt.m_128473_("SpawnPotentials");
            spawner.m_59801_().m_151328_((Level)this.world, pos, nbt);
        }
        catch (Exception e) {
            CastleDungeons.LOGGER.warn("An error occurred while placing spawner!", (Throwable)e);
        }
    }

    @Override
    public void setSpawner(Coord coord, EntityType type) {
        try {
            String mob = null;
            switch (type) {
                case CAVE_SPIDER: {
                    mob = "minecraft:cave_spider";
                    break;
                }
                case ZOMBIE_VILLAGER: {
                    mob = "minecraft:zombie_villager";
                }
            }
            BlockPos pos = new BlockPos(coord.getX(), coord.getY(), coord.getZ());
            this.setBlockState(pos, Blocks.f_50085_.m_49966_());
            SpawnerBlockEntity spawner = (SpawnerBlockEntity)this.world.m_7702_(pos);
            CompoundTag nbt = null;
            try {
                nbt = TagParser.m_129359_((String)this.castleDungeons.getConfig().getSpawnerLogic());
            }
            catch (Exception e) {
                nbt = new CompoundTag();
            }
            CompoundTag entity = new CompoundTag();
            entity.m_128359_("id", mob);
            CompoundTag spawnData = new CompoundTag();
            spawnData.m_128365_("entity", (Tag)entity);
            nbt.m_128365_("SpawnData", (Tag)spawnData);
            nbt.m_128473_("SpawnPotentials");
            spawner.m_59801_().m_151328_((Level)this.world, pos, nbt);
        }
        catch (Exception e) {
            CastleDungeons.LOGGER.warn("An error occurred while placing spawner!", (Throwable)e);
        }
    }

    @Override
    public void spawnEntity(Coord coord, EntityType type) {
        Mob entity = null;
        switch (type) {
            case CAVE_SPIDER: {
                entity = (Mob)net.minecraft.world.entity.EntityType.f_20554_.m_20615_((Level)this.world);
                break;
            }
            case ZOMBIE_VILLAGER: {
                entity = (Mob)net.minecraft.world.entity.EntityType.f_20530_.m_20615_((Level)this.world);
            }
        }
        if (entity != null) {
            entity.m_20343_((double)coord.getX(), (double)coord.getY(), (double)coord.getZ());
            entity.m_21530_();
            this.world.m_7967_((Entity)entity);
        }
    }

    public void setBlockState(BlockPos pos, BlockState state) {
        this.world.m_46597_(pos, state);
        if (!state.m_60804_((BlockGetter)this.world, pos)) {
            this.updateBlock(pos.m_7918_(1, 0, 0));
            this.updateBlock(pos.m_7918_(0, 0, 1));
            this.updateBlock(pos.m_7918_(-1, 0, 0));
            this.updateBlock(pos.m_7918_(0, 0, -1));
        }
    }

    private void updateBlock(BlockPos pos) {
        BlockState state = this.world.m_8055_(pos);
        state.m_60705_((LevelAccessor)this.world, pos, 3, 512);
    }

    public ServerLevel getWorld() {
        return this.world;
    }

    private static class BlockGroupImpl
    extends BlockGroup {
        private long seed;

        public BlockGroupImpl(long seed) {
            this.seed = seed;
        }

        public long getSeed() {
            return this.seed;
        }
    }
}

