/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle.builder.nodes;

import net.puffish.castle.builder.BlockType;
import net.puffish.castle.builder.Coord;
import net.puffish.castle.builder.WorldEditor;
import net.puffish.castle.builder.nodes.Node;
import net.puffish.castle.generator.Castle;
import net.puffish.castle.generator.CastleNode;

public class WalkNode
extends Node {
    public WalkNode(WorldEditor editor, Castle castle, CastleNode node) {
        super(editor, castle, node);
    }

    @Override
    public void build() {
        this.buildWalk();
        this.buildWalkDoors();
    }

    private void buildWalk() {
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                this.editor.setBlock(new Coord(x, 0, z), BlockType.FLOOR_1);
            }
        }
    }

    private void buildWalkDoors() {
        int x;
        int z;
        int z2;
        int x2;
        if (this.isEmptyAtOffset(1, 0)) {
            x2 = 4;
            for (z2 = -3; z2 <= 3; ++z2) {
                if ((z2 & 1) == 0) {
                    this.editor.setBlock(new Coord(x2, 1, z2), BlockType.WALL_TOP_POSITIVE_X);
                    this.editor.setBlock(new Coord(x2, 0, z2), BlockType.WALL_BOTTOM_POSITIVE_X);
                    continue;
                }
                this.editor.setBlock(new Coord(x2, 2, z2), BlockType.WALL_TOP);
                this.editor.setBlock(new Coord(x2, 1, z2), BlockType.WALL);
                this.editor.setBlock(new Coord(x2, 0, z2), BlockType.WALL);
                this.editor.setBlock(new Coord(x2, -1, z2), BlockType.WALL_BOTTOM_POSITIVE_X);
            }
        }
        if (this.isEmptyAtOffset(-1, 0)) {
            x2 = -4;
            for (z2 = -3; z2 <= 3; ++z2) {
                if ((z2 & 1) == 0) {
                    this.editor.setBlock(new Coord(x2, 1, z2), BlockType.WALL_TOP_NEGATIVE_X);
                    this.editor.setBlock(new Coord(x2, 0, z2), BlockType.WALL_BOTTOM_NEGATIVE_X);
                    continue;
                }
                this.editor.setBlock(new Coord(x2, 2, z2), BlockType.WALL_TOP);
                this.editor.setBlock(new Coord(x2, 1, z2), BlockType.WALL);
                this.editor.setBlock(new Coord(x2, 0, z2), BlockType.WALL);
                this.editor.setBlock(new Coord(x2, -1, z2), BlockType.WALL_BOTTOM_NEGATIVE_X);
            }
        }
        if (this.isEmptyAtOffset(0, 1)) {
            z = 4;
            for (x = -3; x <= 3; ++x) {
                if ((x & 1) == 0) {
                    this.editor.setBlock(new Coord(x, 1, z), BlockType.WALL_TOP_POSITIVE_Z);
                    this.editor.setBlock(new Coord(x, 0, z), BlockType.WALL_BOTTOM_POSITIVE_Z);
                    continue;
                }
                this.editor.setBlock(new Coord(x, 2, z), BlockType.WALL_TOP);
                this.editor.setBlock(new Coord(x, 1, z), BlockType.WALL);
                this.editor.setBlock(new Coord(x, 0, z), BlockType.WALL);
                this.editor.setBlock(new Coord(x, -1, z), BlockType.WALL_BOTTOM_POSITIVE_Z);
            }
        }
        if (this.isEmptyAtOffset(0, -1)) {
            z = -4;
            for (x = -3; x <= 3; ++x) {
                if ((x & 1) == 0) {
                    this.editor.setBlock(new Coord(x, 1, z), BlockType.WALL_TOP_NEGATIVE_Z);
                    this.editor.setBlock(new Coord(x, 0, z), BlockType.WALL_BOTTOM_NEGATIVE_Z);
                    continue;
                }
                this.editor.setBlock(new Coord(x, 2, z), BlockType.WALL_TOP);
                this.editor.setBlock(new Coord(x, 1, z), BlockType.WALL);
                this.editor.setBlock(new Coord(x, 0, z), BlockType.WALL);
                this.editor.setBlock(new Coord(x, -1, z), BlockType.WALL_BOTTOM_NEGATIVE_Z);
            }
        }
    }
}

