/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castlemod.generator;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Stack;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.puffish.castlemod.generator.CastleLayerMetrics;
import net.puffish.castlemod.generator.CastleMetrics;
import net.puffish.castlemod.generator.CastleNode;
import net.puffish.castlemod.generator.CastleNodeType;
import net.puffish.castlemod.generator.ConnectionState;
import net.puffish.castlemod.util.Direction4XZ;
import net.puffish.castlemod.util.Direction8XZ;
import net.puffish.castlemod.util.GridXZ;
import net.puffish.castlemod.util.PositionDirection4XZ;
import net.puffish.castlemod.util.PositionXZ;
import net.puffish.castlemod.util.RelationsXZ;
import net.puffish.castlemod.util.Util;

public class CastleLayer {
    private final CastleLayerMetrics metrics;
    private final GridXZ<CastleNode> nodes;
    private final RelationsXZ<ConnectionState> connections;
    private final RelationsXZ<Boolean> doors;

    private CastleLayer(CastleLayerMetrics metrics) {
        this.metrics = metrics;
        this.nodes = new GridXZ<CastleNode>(metrics.getSizeX(), metrics.getSizeZ(), CastleNode::new);
        this.connections = new RelationsXZ<ConnectionState>(metrics.getSizeX(), metrics.getSizeZ(), () -> ConnectionState.MAY_EXIST);
        this.doors = new RelationsXZ<Boolean>(metrics.getSizeX(), metrics.getSizeZ(), () -> false);
    }

    public CastleLayer(CastleMetrics metrics) {
        this(new CastleLayerMetrics(metrics));
    }

    public CastleLayer nextFloor() {
        return new CastleLayer(this.metrics.copy());
    }

    public boolean testConnectivity() {
        long visitedCount = 0L;
        long totalCount = this.metrics.streamPositionsInCutBounds().count();
        GridXZ<Boolean> visited = new GridXZ<Boolean>(this.metrics.getSizeX(), this.metrics.getSizeZ(), () -> false);
        Stack<PositionXZ> stack = new Stack<PositionXZ>();
        PositionXZ startPos = new PositionXZ(this.metrics.getNegativeXCut(), this.metrics.getNegativeZCut());
        ++visitedCount;
        visited.set(startPos, true);
        stack.push(startPos);
        while (!stack.isEmpty()) {
            PositionXZ currentPos = (PositionXZ)stack.pop();
            for (Direction4XZ dir : Direction4XZ.values()) {
                PositionXZ neighborPos = dir.toPos().add(currentPos);
                if (this.metrics.isOutsideCutBounds(neighborPos) || visited.get(neighborPos).booleanValue() || this.getConnection(currentPos, dir) == ConnectionState.CANNOT_EXISTS) continue;
                ++visitedCount;
                visited.set(neighborPos, true);
                stack.push(neighborPos);
            }
        }
        return visitedCount == totalCount;
    }

    public void fillWalk() {
        this.metrics.streamPositionsInCutBounds().forEach(pos -> this.nodes.get((PositionXZ)pos).setType(CastleNodeType.WALK));
    }

    public void fillHallway() {
        this.metrics.streamPositionsInCutBounds().forEach(pos -> this.nodes.get((PositionXZ)pos).setType(CastleNodeType.HALLWAY));
    }

    public void generateMaze(Random random) {
        GridXZ<Boolean> visited = new GridXZ<Boolean>(this.metrics.getSizeX(), this.metrics.getSizeZ(), () -> false);
        Stack<PositionXZ> stack = new Stack<PositionXZ>();
        PositionXZ startPos = Util.pickRandom(this.metrics.streamPositionsInCutBounds().toList(), random).orElseThrow();
        visited.set(startPos, true);
        stack.push(startPos);
        while (!stack.isEmpty()) {
            PositionXZ currentPos = (PositionXZ)stack.pop();
            Optional<PositionDirection4XZ> optNeighbor = Util.pickRandom(this.streamUnvisitedNeighbors(visited, currentPos).toList(), random);
            if (!optNeighbor.isPresent()) continue;
            stack.push(currentPos);
            PositionDirection4XZ neighbor = optNeighbor.orElseThrow();
            this.setConnection(currentPos, neighbor.dir(), ConnectionState.MUST_EXIST);
            visited.set(neighbor.pos(), true);
            stack.push(neighbor.pos());
        }
    }

    private Stream<PositionDirection4XZ> streamUnvisitedNeighbors(GridXZ<Boolean> visited, PositionXZ startPos) {
        return Arrays.stream(Direction4XZ.values()).flatMap(dir -> {
            PositionXZ neighborPos = dir.toPos().add(startPos);
            if (this.metrics.isOutsideBounds(neighborPos)) {
                return Stream.empty();
            }
            if (((Boolean)visited.get(neighborPos)).booleanValue()) {
                return Stream.empty();
            }
            if (this.getNode(neighborPos).getType() == CastleNodeType.EMPTY) {
                return Stream.empty();
            }
            if (this.getConnection(startPos, (Direction4XZ)((Object)dir)) == ConnectionState.CANNOT_EXISTS) {
                return Stream.empty();
            }
            return Stream.of(new PositionDirection4XZ(neighborPos, (Direction4XZ)((Object)dir)));
        });
    }

    public void generateWalkEntrances(CastleLayer belowLayer, Random random) {
        GridXZ<Boolean> visited = new GridXZ<Boolean>(this.metrics.getSizeX(), this.metrics.getSizeZ(), () -> false);
        this.metrics.streamPositionsInBounds().forEach(pos -> {
            if (((Boolean)visited.get((PositionXZ)pos)).booleanValue()) {
                return;
            }
            CastleNode node = belowLayer.getNode((PositionXZ)pos);
            if (node.hasStairs()) {
                this.visitUnvisitedNeighbors(visited, (PositionXZ)pos);
            }
        });
        List candidates = Arrays.stream(Direction4XZ.values()).flatMap(dir -> this.metrics.streamPositionsOnCutEdge((Direction4XZ)((Object)dir)).map(pos -> new PositionDirection4XZ((PositionXZ)pos, (Direction4XZ)((Object)dir)))).collect(Collectors.toList());
        Collections.shuffle(candidates, random);
        for (PositionDirection4XZ candidate : candidates) {
            CastleNodeType neighborType;
            PositionXZ neighborPos = candidate.dir().toPos().add(candidate.pos());
            if (this.metrics.isOutsideBounds(neighborPos) || visited.get(neighborPos).booleanValue() || (neighborType = this.getNode(neighborPos).getType()) != CastleNodeType.WALK) continue;
            this.getNode(candidate.pos()).setEntrance(true);
            this.setConnection(candidate.pos(), candidate.dir(), ConnectionState.MUST_EXIST);
            this.visitUnvisitedNeighbors(visited, neighborPos);
        }
    }

    private void visitUnvisitedNeighbors(GridXZ<Boolean> visited, PositionXZ startPos) {
        Stack<PositionXZ> stack = new Stack<PositionXZ>();
        visited.set(startPos, true);
        stack.push(startPos);
        while (!stack.isEmpty()) {
            PositionXZ currentPos = (PositionXZ)stack.pop();
            this.streamUnvisitedNeighbors(visited, currentPos).forEach(neighbor -> {
                visited.set(neighbor.pos(), true);
                stack.push(neighbor.pos());
            });
        }
    }

    public void fixConnections() {
        this.metrics.streamPositionsInBounds().forEach(pos -> {
            CastleNode currentNode = this.getNode((PositionXZ)pos);
            CastleNodeType currentType = currentNode.getType();
            for (Direction4XZ dir : Direction4XZ.values()) {
                PositionXZ neighborPos = dir.toPos().add((PositionXZ)pos);
                if (this.metrics.isOutsideBounds(neighborPos)) continue;
                CastleNodeType neighborType = this.getNode(neighborPos).getType();
                if (currentType == CastleNodeType.TOWER && neighborType == CastleNodeType.WALK) {
                    this.setConnection((PositionXZ)pos, dir, ConnectionState.MUST_EXIST);
                }
                if (currentType == CastleNodeType.TOWER && neighborType == CastleNodeType.HALLWAY) {
                    this.setConnection((PositionXZ)pos, dir, ConnectionState.MUST_EXIST);
                }
                if (currentType != CastleNodeType.WALK || neighborType != CastleNodeType.WALK) continue;
                this.setConnection((PositionXZ)pos, dir, ConnectionState.MUST_EXIST);
            }
        });
    }

    public void fixOutside() {
        this.metrics.streamConnectionsOutside().forEach(posDir -> this.setConnection(posDir.pos(), posDir.dir(), ConnectionState.CANNOT_EXISTS));
    }

    public void placeMissingStairs(CastleLayer belowLayer, Random random) {
        if (this.isAnyTowerBelowAdjacentToCutBounds(belowLayer)) {
            return;
        }
        PositionXZ pos = Util.pickRandom(this.metrics.streamPositionsInCutBounds().toList(), random).orElseThrow();
        belowLayer.getNode(pos).setStairs(true);
    }

    public boolean isAnyTowerBelowAdjacentToCutBounds(CastleLayer belowLayer) {
        return Arrays.stream(Direction4XZ.values()).anyMatch(dir -> this.metrics.streamPositionsOnCutEdge((Direction4XZ)((Object)dir)).map(pos -> dir.toPos().add((PositionXZ)pos)).filter(Predicate.not(this.metrics::isOutsideBounds)).anyMatch(pos -> belowLayer.getNode((PositionXZ)pos).getType() == CastleNodeType.TOWER));
    }

    public Stream<PositionXZ> streamPossibleTowerPositions() {
        return this.metrics.streamPositionsInBounds().filter(pos -> {
            if (this.getNode((PositionXZ)pos).getType() != CastleNodeType.WALK) {
                return false;
            }
            PositionXZ result = Arrays.stream(Direction4XZ.values()).filter(dir -> {
                PositionXZ neighborPos = dir.toPos().add((PositionXZ)pos);
                if (this.metrics.isOutsideBounds(neighborPos)) {
                    return false;
                }
                return this.getNode(neighborPos).getType() == CastleNodeType.WALK;
            }).map(dir -> dir.toPos().abs()).reduce(new PositionXZ(), (prev, next) -> prev.add(next.abs()));
            return Math.max(result.getX(), result.getZ()) == 1;
        });
    }

    private boolean canPlaceRoof(PositionXZ pos) {
        return Arrays.stream(Direction8XZ.values()).map(dir -> dir.toPos().add(pos)).filter(Predicate.not(this.metrics::isOutsideBounds)).noneMatch(neighborPos -> this.getNode((PositionXZ)neighborPos).getType() != CastleNodeType.EMPTY);
    }

    public boolean tryPlaceRoof(PositionXZ pos) {
        if (this.canPlaceRoof(pos)) {
            this.getNode(pos).setType(CastleNodeType.ROOF);
            return true;
        }
        return false;
    }

    public void placeEntrance(Random random) {
        Direction4XZ dir = Util.pickRandom(Arrays.asList(Direction4XZ.values()), random).orElseThrow();
        PositionXZ pos = this.getRandomMiddleOnEdge(dir, random);
        this.getNode(pos).setEntrance(true);
        this.setConnection(pos, dir, ConnectionState.MUST_EXIST);
    }

    private PositionXZ getRandomMiddleOnEdge(Direction4XZ dir, Random random) {
        return switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case Direction4XZ.NEGATIVE_X -> new PositionXZ(this.metrics.getNegativeXCut(), this.metrics.getNegativeZCut() + this.getRandomMiddle(this.metrics.getCutSizeZ(), random));
            case Direction4XZ.NEGATIVE_Z -> new PositionXZ(this.metrics.getNegativeXCut() + this.getRandomMiddle(this.metrics.getCutSizeX(), random), this.metrics.getNegativeZCut());
            case Direction4XZ.POSITIVE_X -> new PositionXZ(this.metrics.getSizeX() - this.metrics.getPositiveXCut() - 1, this.metrics.getNegativeZCut() + this.getRandomMiddle(this.metrics.getCutSizeZ(), random));
            case Direction4XZ.POSITIVE_Z -> new PositionXZ(this.metrics.getNegativeXCut() + this.getRandomMiddle(this.metrics.getCutSizeX(), random), this.metrics.getSizeZ() - this.metrics.getPositiveZCut() - 1);
        };
    }

    private int getRandomMiddle(int x, Random random) {
        return (random.nextBoolean() ? x - 1 : x) / 2;
    }

    public void placeTower(PositionXZ pos) {
        CastleNode node = this.getNode(pos);
        node.setType(CastleNodeType.TOWER);
        node.setStairs(true);
    }

    public boolean tryCut(Random random) {
        if (this.metrics.isSmall()) {
            return false;
        }
        Optional<Direction4XZ> optDir = Util.pickRandom(Arrays.stream(Direction4XZ.values()).filter(dir -> this.metrics.copy().cut((Direction4XZ)((Object)dir)).isValid()).toList(), random);
        optDir.ifPresent(dir -> {
            this.metrics.streamPositionsOnCutEdge((Direction4XZ)((Object)dir)).forEach(pos -> {
                this.getNode((PositionXZ)pos).setType(CastleNodeType.WALK);
                this.setConnection((PositionXZ)pos, dir.getOpposite(), ConnectionState.CANNOT_EXISTS);
            });
            this.metrics.cut((Direction4XZ)((Object)dir));
        });
        return optDir.isPresent();
    }

    public boolean getDoors(PositionXZ pos, Direction4XZ dir) {
        return this.doors.get(pos, dir);
    }

    public void setDoors(PositionXZ pos, Direction4XZ dir, boolean value) {
        this.doors.set(pos, dir, value);
    }

    public ConnectionState getConnection(PositionXZ pos, Direction4XZ dir) {
        return this.connections.get(pos, dir);
    }

    public void setConnection(PositionXZ pos, Direction4XZ dir, ConnectionState state) {
        this.connections.set(pos, dir, state);
    }

    public CastleNode getNode(PositionXZ pos) {
        return this.nodes.get(pos);
    }

    public CastleLayerMetrics getMetrics() {
        return this.metrics;
    }
}

