/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castlemod.structure;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.puffish.castlemod.generator.Castle;
import net.puffish.castlemod.generator.CastleLayer;
import net.puffish.castlemod.generator.CastleNode;
import net.puffish.castlemod.generator.CastleNodeType;
import net.puffish.castlemod.generator.CastleRoom;
import net.puffish.castlemod.generator.CastleRoomTemplate;
import net.puffish.castlemod.generator.ConnectionState;
import net.puffish.castlemod.structure.CastlePiece;
import net.puffish.castlemod.structure.StructurePieces;
import net.puffish.castlemod.structure.StructureRoomTemplate;
import net.puffish.castlemod.util.Direction4XZ;
import net.puffish.castlemod.util.MirrorXZ;
import net.puffish.castlemod.util.PositionXYZ;
import net.puffish.castlemod.util.PositionXZ;
import net.puffish.castlemod.util.Rotation4XZ;

class CastleGenerator {
    private final PositionXYZ pos;
    private final Castle castle;
    private final Random random;
    private final StructurePieces pieces;
    private final Holder<StructureProcessorList> processors;
    private final Structure.GenerationContext context;
    private final StructurePiecesBuilder collector;

    private CastleGenerator(PositionXYZ pos, Castle castle, Random random, StructurePieces pieces, Holder<StructureProcessorList> processors, Structure.GenerationContext context, StructurePiecesBuilder collector) {
        this.pos = pos;
        this.castle = castle;
        this.random = random;
        this.pieces = pieces;
        this.processors = processors;
        this.context = context;
        this.collector = collector;
    }

    public static void generate(PositionXYZ pos, Castle castle, Random random, StructurePieces pieces, Holder<StructureProcessorList> processors, Structure.GenerationContext context, StructurePiecesBuilder collector) {
        CastleGenerator generator = new CastleGenerator(pos, castle, random, pieces, processors, context, collector);
        generator.run();
    }

    private void run() {
        CastleLayer layer;
        int layerY;
        int y = 0;
        while (y < this.castle.getLayers().size()) {
            layerY = y++;
            layer = this.castle.getLayers().get(layerY);
            layer.getMetrics().streamPositionsInBounds().forEach(pos -> {
                CastleNode node = layer.getNode((PositionXZ)pos);
                if (node.getType() == CastleNodeType.WALK) {
                    this.addPiece(this.pieces.walk(), this.centerPos(layerY, (PositionXZ)pos, 0), MirrorXZ.random(this.random), Rotation4XZ.random(this.random));
                }
            });
            layer.getMetrics().streamConnectionsInside().forEach(posDir -> {
                PositionXZ pos = posDir.pos();
                Direction4XZ dir = posDir.dir();
                this.placeBalustrade(layerY, layer.getNode(pos).getType(), layer.getNode(dir.toPos().add(pos)).getType(), pos, dir);
            });
            layer.getMetrics().streamConnectionsOutside().forEach(posDir -> {
                PositionXZ pos = posDir.pos();
                Direction4XZ dir = posDir.dir();
                this.placeBalustrade(layerY, layer.getNode(pos).getType(), CastleNodeType.EMPTY, pos, dir);
            });
        }
        y = 0;
        while (y < this.castle.getLayers().size()) {
            layerY = y++;
            layer = this.castle.getLayers().get(layerY);
            layer.getMetrics().streamPositionsInBounds().forEach(pos -> {
                ResourceLocation structure;
                CastleNode node = layer.getNode((PositionXZ)pos);
                switch (node.getType()) {
                    case HALLWAY: 
                    case TOWER: {
                        ResourceLocation resourceLocation = this.pieces.hallway();
                        break;
                    }
                    case ROOM: {
                        ResourceLocation resourceLocation = this.pieces.room();
                        break;
                    }
                    case ROOF: {
                        ResourceLocation resourceLocation = this.pieces.tower();
                        break;
                    }
                    default: {
                        ResourceLocation resourceLocation = structure = null;
                    }
                }
                if (structure != null) {
                    this.addPiece(structure, this.centerPos(layerY, (PositionXZ)pos, 0), MirrorXZ.random(this.random), Rotation4XZ.random(this.random));
                }
            });
        }
        y = 0;
        while (y < this.castle.getLayers().size()) {
            layerY = y++;
            layer = this.castle.getLayers().get(layerY);
            layer.getMetrics().streamPositionsInBounds().forEach(pos -> {
                CastleNode node = layer.getNode((PositionXZ)pos);
                if (node.hasStairs()) {
                    for (int i = 1; i < 6; ++i) {
                        this.addPiece(this.pieces.stairs(), this.centerPos(layerY, (PositionXZ)pos, i), MirrorXZ.NONE, Rotation4XZ.values()[(layerY * 5 + i) % 4]);
                    }
                }
            });
            layer.getMetrics().streamConnectionsInsideNoDuplicates(this.random).forEach(posDir -> {
                PositionXZ pos = posDir.pos();
                Direction4XZ dir = posDir.dir();
                this.placeWallsAndDoors(layerY, layer, layer.getNode(pos).getType(), layer.getNode(dir.toPos().add(pos)).getType(), pos, dir);
            });
            layer.getMetrics().streamConnectionsInside().forEach(posDir -> {
                PositionXZ pos = posDir.pos();
                Direction4XZ dir = posDir.dir();
                this.placeEntrancesAndWindows(layerY, layer, layer.getNode(pos).getType(), layer.getNode(dir.toPos().add(pos)).getType(), pos, dir);
            });
            layer.getMetrics().streamConnectionsOutside().forEach(posDir -> {
                PositionXZ pos = posDir.pos();
                Direction4XZ dir = posDir.dir();
                this.placeWallsAndDoors(layerY, layer, layer.getNode(pos).getType(), CastleNodeType.EMPTY, pos, dir);
                this.placeEntrancesAndWindows(layerY, layer, layer.getNode(pos).getType(), CastleNodeType.EMPTY, pos, dir);
            });
        }
        for (CastleRoom room : this.castle.getRooms()) {
            CastleRoomTemplate castleRoomTemplate = room.getRoomTemplate();
            if (!(castleRoomTemplate instanceof StructureRoomTemplate)) continue;
            StructureRoomTemplate namedRoomTemplate = (StructureRoomTemplate)castleRoomTemplate;
            this.addPiece(namedRoomTemplate.getStructure(), this.roomPos(room.getPosition(), room.getRotation(), namedRoomTemplate), room.getMirror(), room.getRotation());
        }
    }

    private void placeBalustrade(int layerY, CastleNodeType currentType, CastleNodeType neighborType, PositionXZ pos, Direction4XZ dir) {
        if (neighborType == CastleNodeType.EMPTY) {
            ResourceLocation structure;
            switch (currentType) {
                case WALK: {
                    ResourceLocation resourceLocation = this.pieces.walkBalustrade();
                    break;
                }
                case ROOF: {
                    ResourceLocation resourceLocation = this.pieces.towerBalustrade();
                    break;
                }
                default: {
                    ResourceLocation resourceLocation = structure = null;
                }
            }
            if (structure != null) {
                this.addPiece(structure, this.rotAroundCenterPos(layerY, pos, dir, 4, -1), MirrorXZ.NONE, this.dirToRot(dir));
            }
        }
    }

    private void placeEntrancesAndWindows(int layerY, CastleLayer layer, CastleNodeType currentType, CastleNodeType neighborType, PositionXZ pos, Direction4XZ dir) {
        Rotation4XZ rot = this.dirToRot(dir);
        if (layer.getConnection(pos, dir) == ConnectionState.MUST_EXIST) {
            switch (currentType) {
                case HALLWAY: 
                case TOWER: {
                    switch (neighborType) {
                        case WALK: 
                        case EMPTY: {
                            ResourceLocation structure = this.castle.getTowers().get(pos) != false ? this.pieces.towerEntrance() : this.pieces.hallwayEntrance();
                            this.addPiece(structure, this.rotAroundCenterPos(layerY, pos, dir, 3, 0), MirrorXZ.NONE, rot);
                        }
                    }
                }
            }
        } else if (!this.isOpenAir(currentType) && this.isOpenAir(neighborType)) {
            ResourceLocation structure = this.castle.getTowers().get(pos) != false ? this.pieces.towerWindow() : this.pieces.hallwayWindow();
            this.addPiece(structure, this.rotAroundCenterPos(layerY, pos, dir, 3, 0), MirrorXZ.NONE, rot);
        }
    }

    private void placeWallsAndDoors(int layerY, CastleLayer layer, CastleNodeType currentType, CastleNodeType neighborType, PositionXZ pos, Direction4XZ dir) {
        if (layer.getDoors(pos, dir)) {
            this.addPiece(this.pieces.door(), this.rotAroundCenterPos(layerY, pos, dir, 3, 0), MirrorXZ.NONE, this.dirToRot(dir));
        } else if (!this.isOpenAir(currentType) && !this.isOpenAir(neighborType)) {
            if (layer.getConnection(pos, dir) == ConnectionState.MUST_EXIST) {
                if (currentType != CastleNodeType.ROOM && neighborType != CastleNodeType.ROOM) {
                    this.addPiece(this.pieces.passage(), this.rotAroundCenterPos(layerY, pos, dir, 3, 0), MirrorXZ.NONE, this.dirToRot(dir));
                }
            } else {
                this.addPiece(this.pieces.wall(), this.rotAroundCenterPos(layerY, pos, dir, 3, 0), MirrorXZ.NONE, this.dirToRot(dir));
            }
        }
    }

    private boolean isOpenAir(CastleNodeType type) {
        return type == CastleNodeType.EMPTY || type == CastleNodeType.WALK || type == CastleNodeType.ROOF;
    }

    private Rotation4XZ dirToRot(Direction4XZ dir) {
        return switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case Direction4XZ.POSITIVE_X -> Rotation4XZ.DEGREES_90;
            case Direction4XZ.POSITIVE_Z -> Rotation4XZ.DEGREES_180;
            case Direction4XZ.NEGATIVE_X -> Rotation4XZ.DEGREES_270;
            case Direction4XZ.NEGATIVE_Z -> Rotation4XZ.DEGREES_0;
        };
    }

    private PositionXYZ rotAroundCenterPos(int layerY, PositionXZ pos, Direction4XZ dir, int radius, int y) {
        return new PositionXYZ(pos.getX() * 6 - 3 + dir.getX() * radius, layerY * 5 + y, pos.getZ() * 6 - 3 + dir.getZ() * radius);
    }

    private PositionXYZ centerPos(int layerY, PositionXZ pos, int y) {
        return new PositionXYZ(pos.getX() * 6 - 3, layerY * 5 + y, pos.getZ() * 6 - 3);
    }

    private PositionXYZ roomPos(PositionXYZ pos, Rotation4XZ rot, StructureRoomTemplate template) {
        return switch (rot) {
            default -> throw new IncompatibleClassChangeError();
            case Rotation4XZ.DEGREES_0, Rotation4XZ.DEGREES_180 -> new PositionXYZ(pos.getX() * 6 + template.getSizeX() * 3 - 6, pos.getY() * 5, pos.getZ() * 6 + template.getSizeZ() * 3 - 6);
            case Rotation4XZ.DEGREES_90, Rotation4XZ.DEGREES_270 -> new PositionXYZ(pos.getX() * 6 + template.getSizeZ() * 3 - 6, pos.getY() * 5, pos.getZ() * 6 + template.getSizeX() * 3 - 6);
        };
    }

    private void addPiece(ResourceLocation structure, PositionXYZ pos, MirrorXZ mir, Rotation4XZ rot) {
        this.collector.m_142679_((StructurePiece)CastlePiece.create(this.context.f_226625_(), structure, this.processors, new BlockPos(this.pos.getX() + pos.getX(), this.pos.getY() + pos.getY(), this.pos.getZ() + pos.getZ()), mir, rot));
    }
}

