/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castlemod.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.puffish.castlemod.CastleMod;
import net.puffish.castlemod.generator.Castle;
import net.puffish.castlemod.generator.CastleTemplate;
import net.puffish.castlemod.structure.CastleGenerator;
import net.puffish.castlemod.structure.RoomTemplate;
import net.puffish.castlemod.structure.StructurePieces;
import net.puffish.castlemod.structure.StructureRoomTemplate;
import net.puffish.castlemod.util.PositionXYZ;

public class CastleStructure
extends Structure {
    public static final Codec<CastleStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Structure.m_226567_((RecordCodecBuilder.Instance)instance), (App)ExtraCodecs.f_144629_.fieldOf("min_size").forGetter(CastleStructure::getMinSize), (App)ExtraCodecs.f_144629_.fieldOf("max_size").forGetter(CastleStructure::getMaxSize), (App)StructurePieces.CODEC.fieldOf("pieces").forGetter(CastleStructure::getPieces), (App)RoomTemplate.CODEC.listOf().fieldOf("rooms").forGetter(CastleStructure::getRooms), (App)StructureProcessorType.f_74468_.fieldOf("processors").forGetter(CastleStructure::getProcessors)).apply((Applicative)instance, CastleStructure::new));
    private final int minSize;
    private final int maxSize;
    private final StructurePieces pieces;
    private final List<RoomTemplate> rooms;
    private final Holder<StructureProcessorList> processors;

    protected CastleStructure(Structure.StructureSettings config, int minSize, int maxSize, StructurePieces pieces, List<RoomTemplate> rooms, Holder<StructureProcessorList> processors) {
        super(config);
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.pieces = pieces;
        this.rooms = rooms;
        this.processors = processors;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        int z;
        Random random = new Random(context.f_226626_().m_188505_());
        StructureTemplateManager manager = context.f_226625_();
        List<StructureRoomTemplate> roomTemplates = this.rooms.stream().map(room -> StructureRoomTemplate.create(manager, room)).toList();
        int sizeX = random.nextInt(this.maxSize - this.minSize + 1) + this.minSize;
        int sizeZ = random.nextInt(this.maxSize - this.minSize + 1) + this.minSize;
        Castle castle = Castle.generate(new CastleTemplate(sizeX, sizeZ, roomTemplates), random).orElseThrow();
        ChunkPos chunkPos = context.f_226628_();
        int x = chunkPos.m_45604_();
        int y = Structure.m_226576_((Structure.GenerationContext)context, (int)x, (int)(z = chunkPos.m_45605_()), (int)(castle.getMetrics().getSizeX() * 6 + 3), (int)(castle.getMetrics().getSizeZ() * 6 + 3));
        if (y < context.f_226622_().m_6337_()) {
            return Optional.empty();
        }
        return Structure.m_226585_((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, collector -> CastleGenerator.generate(new PositionXYZ(x, y + 1, z), castle, random, this.pieces, this.processors, context, collector));
    }

    public StructureType<?> m_213658_() {
        return CastleMod.CASTLE_STRUCTURE_TYPE;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public StructurePieces getPieces() {
        return this.pieces;
    }

    public List<RoomTemplate> getRooms() {
        return this.rooms;
    }

    public Holder<StructureProcessorList> getProcessors() {
        return this.processors;
    }
}

