/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castlemod.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.puffish.castlemod.CastleMod;

public class MossyCrackedStructureProcessor
extends StructureProcessor {
    public static final Codec<MossyCrackedStructureProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("mossiness").forGetter(MossyCrackedStructureProcessor::getMossiness), (App)Codec.FLOAT.fieldOf("crackiness").forGetter(MossyCrackedStructureProcessor::getCrackiness)).apply((Applicative)instance, MossyCrackedStructureProcessor::new));
    private final float mossiness;
    private final float crackiness;

    public MossyCrackedStructureProcessor(float mossiness, float crackiness) {
        this.mossiness = mossiness;
        this.crackiness = crackiness;
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader world, BlockPos pos, BlockPos pivot, StructureTemplate.StructureBlockInfo originalBlockInfo, StructureTemplate.StructureBlockInfo currentBlockInfo, StructurePlaceSettings data) {
        RandomSource random = data.m_230326_(currentBlockInfo.f_74675_);
        BlockState state = currentBlockInfo.f_74676_;
        if (state.m_60713_(Blocks.f_50222_)) {
            state = this.processMossyCracked(state, Blocks.f_50223_, Blocks.f_50224_, random);
        }
        if (state.m_60713_(Blocks.f_50411_)) {
            state = this.processMossy(state, Blocks.f_50645_, random);
        }
        if (state.m_60713_(Blocks.f_50194_)) {
            state = this.processMossy(state, Blocks.f_50631_, random);
        }
        if (state.m_60713_(Blocks.f_50609_)) {
            state = this.processMossy(state, Blocks.f_50607_, random);
        }
        if (state.m_60713_(Blocks.f_50652_)) {
            state = this.processMossy(state, Blocks.f_50079_, random);
        }
        if (state.m_60713_(Blocks.f_50409_)) {
            state = this.processMossy(state, Blocks.f_50647_, random);
        }
        if (state.m_60713_(Blocks.f_50157_)) {
            state = this.processMossy(state, Blocks.f_50633_, random);
        }
        if (state.m_60713_(Blocks.f_50274_)) {
            state = this.processMossy(state, Blocks.f_50275_, random);
        }
        return new StructureTemplate.StructureBlockInfo(currentBlockInfo.f_74675_, state, currentBlockInfo.f_74677_);
    }

    private BlockState processMossyCracked(BlockState state, Block mossyBlock, Block crackedBlock, RandomSource random) {
        if (random.m_188501_() < this.mossiness) {
            return mossyBlock.m_152465_(state);
        }
        if (random.m_188501_() < this.crackiness) {
            return crackedBlock.m_152465_(state);
        }
        return state;
    }

    private BlockState processMossy(BlockState state, Block mossyBlock, RandomSource random) {
        if (random.m_188501_() < this.mossiness) {
            return mossyBlock.m_152465_(state);
        }
        return state;
    }

    protected StructureProcessorType<?> m_6953_() {
        return CastleMod.MOSSY_CRACKED_STRUCTURE_PROCESSOR_TYPE;
    }

    public float getMossiness() {
        return this.mossiness;
    }

    public float getCrackiness() {
        return this.crackiness;
    }
}

