/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castlemod.util;

import net.puffish.castlemod.util.MirrorXZ;
import net.puffish.castlemod.util.PositionXZ;
import net.puffish.castlemod.util.Rotation4XZ;

public enum Direction4XZ {
    POSITIVE_X(1, 0),
    POSITIVE_Z(0, 1),
    NEGATIVE_X(-1, 0),
    NEGATIVE_Z(0, -1);

    private final int x;
    private final int z;

    private Direction4XZ(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public Direction4XZ getOpposite() {
        return Direction4XZ.values()[(this.ordinal() + 2) % 4];
    }

    public Direction4XZ getRotatedClockwise(Rotation4XZ rot) {
        return Direction4XZ.values()[(this.ordinal() + rot.ordinal()) % 4];
    }

    public Direction4XZ getRotatedCounterClockwise(Rotation4XZ rot) {
        return Direction4XZ.values()[(this.ordinal() + 4 - rot.ordinal()) % 4];
    }

    public Direction4XZ getMirrored(MirrorXZ mirrorXZ) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case POSITIVE_X -> {
                if (mirrorXZ == MirrorXZ.ALONG_Z) {
                    yield NEGATIVE_X;
                }
                yield POSITIVE_X;
            }
            case POSITIVE_Z -> {
                if (mirrorXZ == MirrorXZ.ALONG_X) {
                    yield NEGATIVE_Z;
                }
                yield POSITIVE_Z;
            }
            case NEGATIVE_X -> {
                if (mirrorXZ == MirrorXZ.ALONG_Z) {
                    yield POSITIVE_X;
                }
                yield NEGATIVE_X;
            }
            case NEGATIVE_Z -> mirrorXZ == MirrorXZ.ALONG_X ? POSITIVE_Z : NEGATIVE_Z;
        };
    }

    public PositionXZ toPos() {
        return new PositionXZ(this.x, this.z);
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }
}

