/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castlemod.generator;

import java.util.Random;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.puffish.castlemod.util.Direction4XZ;
import net.puffish.castlemod.util.PositionDirection4XZ;
import net.puffish.castlemod.util.PositionXZ;

public class CastleMetrics {
    protected final int sizeX;
    protected final int sizeZ;

    public CastleMetrics(int sizeX, int sizeZ) {
        this.sizeX = sizeX;
        this.sizeZ = sizeZ;
    }

    public CastleMetrics copy() {
        return new CastleMetrics(this.sizeX, this.sizeZ);
    }

    public boolean isOutsideBounds(PositionXZ pos) {
        return pos.getX() < 0 || pos.getZ() < 0 || pos.getX() >= this.sizeX || pos.getZ() >= this.sizeZ;
    }

    public Stream<PositionXZ> streamPositionsInBounds() {
        return this.streamPositionsInCustomBounds(0, this.sizeX, 0, this.sizeZ);
    }

    public Stream<PositionXZ> streamPositionsInCustomBounds(int startX, int endX, int startZ, int endZ) {
        return IntStream.range(startX, endX).mapToObj(x -> IntStream.range(startZ, endZ).mapToObj(z -> new PositionXZ(x, z))).flatMap(Function.identity());
    }

    public Stream<PositionDirection4XZ> streamConnectionsInsideNoDuplicates(Random random) {
        return Stream.concat(IntStream.range(0, this.sizeX - 1).mapToObj(x -> IntStream.range(0, this.sizeZ).mapToObj(z -> {
            if (random.nextBoolean()) {
                return new PositionDirection4XZ(new PositionXZ(x, z), Direction4XZ.POSITIVE_X);
            }
            return new PositionDirection4XZ(new PositionXZ(x + 1, z), Direction4XZ.NEGATIVE_X);
        })).flatMap(Function.identity()), IntStream.range(0, this.sizeZ - 1).mapToObj(z -> IntStream.range(0, this.sizeX).mapToObj(x -> {
            if (random.nextBoolean()) {
                return new PositionDirection4XZ(new PositionXZ(x, z), Direction4XZ.POSITIVE_Z);
            }
            return new PositionDirection4XZ(new PositionXZ(x, z + 1), Direction4XZ.NEGATIVE_Z);
        })).flatMap(Function.identity()));
    }

    public Stream<PositionDirection4XZ> streamConnectionsInside() {
        return Stream.concat(IntStream.range(0, this.sizeX - 1).mapToObj(x -> IntStream.range(0, this.sizeZ).mapToObj(z -> Stream.of(new PositionDirection4XZ(new PositionXZ(x, z), Direction4XZ.POSITIVE_X), new PositionDirection4XZ(new PositionXZ(x + 1, z), Direction4XZ.NEGATIVE_X))).flatMap(Function.identity())).flatMap(Function.identity()), IntStream.range(0, this.sizeZ - 1).mapToObj(z -> IntStream.range(0, this.sizeX).mapToObj(x -> Stream.of(new PositionDirection4XZ(new PositionXZ(x, z), Direction4XZ.POSITIVE_Z), new PositionDirection4XZ(new PositionXZ(x, z + 1), Direction4XZ.NEGATIVE_Z))).flatMap(Function.identity())).flatMap(Function.identity()));
    }

    public Stream<PositionDirection4XZ> streamConnectionsOutside() {
        return Stream.concat(IntStream.range(0, this.sizeX).mapToObj(x -> Stream.of(new PositionDirection4XZ(new PositionXZ(x, 0), Direction4XZ.NEGATIVE_Z), new PositionDirection4XZ(new PositionXZ(x, this.sizeZ - 1), Direction4XZ.POSITIVE_Z))).flatMap(Function.identity()), IntStream.range(0, this.sizeZ).mapToObj(z -> Stream.of(new PositionDirection4XZ(new PositionXZ(0, z), Direction4XZ.NEGATIVE_X), new PositionDirection4XZ(new PositionXZ(this.sizeX - 1, z), Direction4XZ.POSITIVE_X))).flatMap(Function.identity()));
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public int getSizeZ() {
        return this.sizeZ;
    }
}

