/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castlemod.generator;

import net.puffish.castlemod.generator.CastleRoomTemplate;
import net.puffish.castlemod.util.Direction4XZ;
import net.puffish.castlemod.util.MirrorXZ;
import net.puffish.castlemod.util.PositionXYZ;
import net.puffish.castlemod.util.PositionXZ;
import net.puffish.castlemod.util.Rotation4XZ;

public record RoomPlacement(PositionXYZ position, MirrorXZ mirror, Rotation4XZ rotation, CastleRoomTemplate roomTemplate) {
    public int getRotatedSizeX() {
        if (this.rotation == Rotation4XZ.DEGREES_0 || this.rotation == Rotation4XZ.DEGREES_180) {
            return this.roomTemplate.getSizeX();
        }
        return this.roomTemplate.getSizeZ();
    }

    public int getRotatedSizeZ() {
        if (this.rotation == Rotation4XZ.DEGREES_0 || this.rotation == Rotation4XZ.DEGREES_180) {
            return this.roomTemplate.getSizeZ();
        }
        return this.roomTemplate.getSizeX();
    }

    public int getDoorIndex(PositionXZ pos, Direction4XZ dir) {
        boolean flip = switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case Direction4XZ.NEGATIVE_X, Direction4XZ.POSITIVE_Z -> {
                if (this.mirror == MirrorXZ.NONE) {
                    yield true;
                }
                yield false;
            }
            case Direction4XZ.NEGATIVE_Z, Direction4XZ.POSITIVE_X -> this.mirror != MirrorXZ.NONE;
        };
        return switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case Direction4XZ.NEGATIVE_X, Direction4XZ.POSITIVE_X -> {
                int z = pos.getZ() - this.position.getZ();
                if (flip) {
                    yield this.getRotatedSizeZ() - z - 1;
                }
                yield z;
            }
            case Direction4XZ.POSITIVE_Z, Direction4XZ.NEGATIVE_Z -> {
                int x = pos.getX() - this.position.getX();
                if (flip) {
                    yield this.getRotatedSizeX() - x - 1;
                }
                yield x;
            }
        };
    }

    public Direction4XZ getDoorSide(Direction4XZ dir) {
        return dir.getRotatedCounterClockwise(this.rotation).getMirrored(this.mirror);
    }
}

