/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.block;

import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.cursegame.minecraft.dt.tileentity.TileEntityCrystalTable;

public class BlockCrystalTable
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    public static final IntegerProperty LEVEL = BlockStateProperties.field_208132_ag;
    private final Map<Direction, VoxelShape> shapes = new EnumMap<Direction, VoxelShape>(Direction.class);
    public static final VoxelShape SHELL = Block.func_208617_a((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
    public static final VoxelShape SHAPE_U = VoxelShapes.func_197872_a((VoxelShape)SHELL, (VoxelShape)Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0));
    public static final VoxelShape SHAPE_D = VoxelShapes.func_197872_a((VoxelShape)SHELL, (VoxelShape)Block.func_208617_a((double)2.0, (double)14.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0));
    public static final VoxelShape SHAPE_N = VoxelShapes.func_197872_a((VoxelShape)SHELL, (VoxelShape)Block.func_208617_a((double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0, (double)16.0));
    public static final VoxelShape SHAPE_S = VoxelShapes.func_197872_a((VoxelShape)SHELL, (VoxelShape)Block.func_208617_a((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)2.0));
    public static final VoxelShape SHAPE_E = VoxelShapes.func_197872_a((VoxelShape)SHELL, (VoxelShape)Block.func_208617_a((double)0.0, (double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0));
    public static final VoxelShape SHAPE_W = VoxelShapes.func_197872_a((VoxelShape)SHELL, (VoxelShape)Block.func_208617_a((double)14.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0));

    public BlockCrystalTable() {
        super(BlockCrystalTable.getBuilder());
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.UP)).func_206870_a((Property)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public static VoxelShape getVoxelShape(BlockState blockState) {
        switch ((Direction)blockState.func_177229_b((Property)FACING)) {
            case UP: {
                return SHAPE_U;
            }
            case DOWN: {
                return SHAPE_D;
            }
            case NORTH: {
                return SHAPE_N;
            }
            case SOUTH: {
                return SHAPE_S;
            }
            case WEST: {
                return SHAPE_W;
            }
            case EAST: {
                return SHAPE_E;
            }
        }
        return SHELL;
    }

    public VoxelShape func_220053_a(BlockState blockState, IBlockReader blockGetter, BlockPos blockPos, ISelectionContext context) {
        return BlockCrystalTable.getVoxelShape(blockState);
    }

    public String func_149739_a() {
        return "corail_dt.block.crystal_table";
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        TileEntity tileEntity;
        if (stack.func_82837_s() && (tileEntity = world.func_175625_s(pos)) instanceof TileEntityCrystalTable) {
            ((TileEntityCrystalTable)tileEntity).setCustomName(stack.func_151000_E());
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        if (context.func_221531_n() != Hand.MAIN_HAND) {
            return null;
        }
        BlockState state = this.func_176223_P();
        for (Direction direction : context.func_196009_e()) {
            BlockState blockState = (BlockState)state.func_206870_a((Property)FACING, (Comparable)direction.func_176734_d());
            if (!blockState.func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a())) continue;
            return blockState;
        }
        return null;
    }

    public BlockRenderType func_149645_b(BlockState blockState) {
        return BlockRenderType.MODEL;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, LEVEL});
    }

    public TileEntityCrystalTable createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityCrystalTable();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public static AbstractBlock.Properties getBuilder() {
        return AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151677_p).func_235861_h_().func_200947_a(SoundType.field_185853_f).func_200943_b(0.8f).func_226896_b_().func_235838_a_(s -> (Integer)s.func_177229_b((Property)LEVEL));
    }
}

