/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.block;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.IContainerProvider;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import org.cursegame.minecraft.dt.tileentity.TileEntityDTBase;

public class BlockDTBase
extends Block {
    public static final DirectionProperty FACING = DirectionProperty.func_177712_a((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);

    protected BlockDTBase(AbstractBlock.Properties properties) {
        super(properties);
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos blockPos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntityDTBase tileEntityBase;
        if (level.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tileEntity = level.func_175625_s(blockPos);
        if (tileEntity instanceof TileEntityDTBase && (tileEntityBase = (TileEntityDTBase)tileEntity).getContainer(player) != null) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new SimpleNamedContainerProvider((IContainerProvider)tileEntityBase, tileEntityBase.func_145748_c_()), (BlockPos)blockPos);
        }
        return ActionResultType.CONSUME;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        TileEntity tileEntity;
        if (stack.func_82837_s() && (tileEntity = world.func_175625_s(pos)) instanceof TileEntityDTBase) {
            ((TileEntityDTBase)tileEntity).setCustomName(stack.func_200301_q());
        }
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext blockPlaceContext) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)blockPlaceContext.func_195992_f().func_176734_d());
    }

    public void func_196243_a(BlockState oldState, World world, BlockPos blockPos, BlockState newState, boolean isMoving) {
        TileEntity blockEntity;
        if (oldState.func_177230_c() != newState.func_177230_c() && (blockEntity = world.func_175625_s(blockPos)) instanceof TileEntityDTBase) {
            ((TileEntityDTBase)blockEntity).dropContents(world, blockPos);
        }
        super.func_196243_a(oldState, world, blockPos, newState, isMoving);
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }
}

