/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.configuration;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.tuple.Pair;
import org.cursegame.minecraft.dt.ModDT;
import org.cursegame.minecraft.dt.recipe.ReversedRecipeOverrides;

public class Configuration {
    private static Configuration instance;
    public final File CONFIG_DIR = new File(FMLPaths.CONFIGDIR.get().toFile(), "corail_dt");
    private final File overridesFile = new File(this.CONFIG_DIR, "overrides.json");
    public final ConfigurationClient client;
    public final ConfigurationServer server;
    private ReversedRecipeOverrides overrides;

    public static Configuration getInstance() {
        if (instance == null) {
            instance = new Configuration();
        }
        return instance;
    }

    private Configuration() {
        Pair resultClient = new ForgeConfigSpec.Builder().configure(ConfigurationClient::new);
        this.client = (ConfigurationClient)resultClient.getKey();
        this.client.specification = (ForgeConfigSpec)resultClient.getValue();
        Pair resultServer = new ForgeConfigSpec.Builder().configure(ConfigurationServer::new);
        this.server = (ConfigurationServer)resultServer.getKey();
        this.server.specification = (ForgeConfigSpec)resultServer.getValue();
        if (!this.CONFIG_DIR.exists() && !this.CONFIG_DIR.mkdir()) {
            ModDT.LOGGER.warn("Unable to create config folder {}", (Object)this.CONFIG_DIR);
        }
    }

    public ReversedRecipeOverrides loadOverrides() {
        if (this.overrides == null) {
            this.overrides = Configuration.loadAsJson(this.overridesFile, ReversedRecipeOverrides::asJson);
        }
        return this.overrides;
    }

    public void saveOverrides() {
        if (this.overrides != null) {
            Configuration.saveAsJson(this.overridesFile, this.overrides, ReversedRecipeOverrides::toJson);
        }
    }

    private static <T> void saveAsJson(File file, T t, Function<T, JsonElement> converter) {
        try (FileWriter fw = new FileWriter(file);){
            JsonElement json = converter.apply(t);
            ModDT.GSON.toJson(json, (Appendable)fw);
        }
        catch (IOException e) {
            ModDT.LOGGER.error("Unable to save {}", (Object)file, (Object)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static <T> T loadAsJson(File file, Function<JsonElement, T> converter) {
        if (!file.exists()) {
            if (!file.canRead()) return (T)converter.apply((JsonElement)new JsonObject());
        }
        try (FileReader reader = new FileReader(file);){
            JsonElement json = (JsonElement)ModDT.GSON.fromJson((Reader)reader, JsonElement.class);
            if (json == null) return (T)converter.apply((JsonElement)new JsonObject());
            JsonElement t = converter.apply(json);
            return (T)t;
        }
        catch (IOException e) {
            ModDT.LOGGER.error("Unable to load {}", (Object)file, (Object)e);
        }
        return (T)converter.apply((JsonElement)new JsonObject());
    }

    public static String getTranslation(String name) {
        return "corail_dt.config." + name;
    }

    public static class ConfigurationServer
    extends ConfigurationBase {
        public final ForgeConfigSpec.IntValue tagLimit;

        public ConfigurationServer(ForgeConfigSpec.Builder builder) {
            builder.push("Server");
            this.tagLimit = builder.comment("Limit item tags to particular size. \nIt prevents a huge Cartesian multiplication for recipes consist of several long tags. \nZero means no limitation. \nDefault: 1").defineInRange("tag_limit", 1, 0, 5);
            builder.pop();
        }
    }

    public static class ConfigurationClient
    extends ConfigurationBase {
        public final ForgeConfigSpec.BooleanValue allowIntegration;

        public ConfigurationClient(ForgeConfigSpec.Builder builder) {
            builder.push("Client");
            this.allowIntegration = builder.comment("allow_integration [false/true|default:false]").translation(Configuration.getTranslation("allow_integration")).define("allow_integration", false);
            builder.pop();
        }
    }

    public static class ConfigurationBase {
        public ForgeConfigSpec specification;
    }
}

