/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Predicate;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cursegame.minecraft.dt.gui.Button;
import org.cursegame.minecraft.dt.gui.Gui;
import org.cursegame.minecraft.dt.gui.Tile;

@OnlyIn(value=Dist.CLIENT)
public class ButtonTile
extends Button {
    private final Tile tile;
    private final Gui<?> screen;
    private final Offset[] offsets;
    private final int x;
    private final int y;

    public ButtonTile(Gui<?> screen, Tile tile, int x, int y, String text, Offset[] offsets, Button.IPressable pressable) {
        super(screen.getX() + tile.getDX() + x, screen.getY() + tile.getDY() + y, tile.getW(), tile.getH(), (ITextComponent)new StringTextComponent(text), pressable);
        this.tile = tile;
        this.screen = screen;
        this.offsets = offsets;
        this.x = x;
        this.y = y;
    }

    public ButtonTile(Gui<?> screen, Tile tile, String text, Offset[] offsets, Button.IPressable pressable) {
        this(screen, tile, 0, 0, text, offsets, pressable);
    }

    @Override
    protected void doRenderButton(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        int offsetX = 0;
        int offsetY = 0;
        for (Offset offset : this.offsets) {
            if (!offset.predicate.test(this)) continue;
            offsetX = this.tile.getW() * offset.fx;
            offsetY = this.tile.getH() * offset.fy;
            break;
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.tile.renderBG(this.screen, ms, this.x, this.y, offsetX, offsetY);
        this.doRenderBg(ms, this.screen.getMinecraft(), mouseX, mouseY);
    }

    public static class Offset {
        final Predicate<Button> predicate;
        final int fx;
        final int fy;

        public Offset(int fx, int fy, Predicate<Button> predicate) {
            this.fx = fx;
            this.fy = fy;
            this.predicate = predicate;
        }

        static Offset of(int fx, int fy, Predicate<Button> predicate) {
            return new Offset(fx, fy, predicate);
        }
    }
}

