/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.gui;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.tuple.Pair;
import org.cursegame.minecraft.dt.ModDT;
import org.cursegame.minecraft.dt.gui.SlotDT;
import org.cursegame.minecraft.dt.registry.ModContainers;
import org.cursegame.minecraft.dt.tileentity.DTContainer;
import org.cursegame.minecraft.dt.tileentity.DTContainerProvider;

public class ContainerDT
extends Container {
    private final DTContainer dtContainer;
    private final IIntArray dtData;
    private int clickSlotId;
    private long clickSlotTimestamp;
    private long clickSlotDelay = 300L;
    private int iSize;
    private int wSize;
    private int vSize;
    private int oSize;
    private int pSize;
    private int diskSlot;
    private int bookSlot;
    private int vialSlot;
    private int fuelSlot;
    private int bondSlot;
    private int wIndex;
    private int iIndex;
    private int oIndex;
    private int vIndex;
    private int pIndex;
    protected Map<Pair<Integer, Integer>, Slot> slotByXYMap = new HashMap<Pair<Integer, Integer>, Slot>();
    static int[][] inventory3x3;
    static int[][] inventory9x3;

    public ContainerDT(int windowId, PlayerInventory playerInventory, DTContainer dtContainer) {
        super(ModContainers.DT, windowId);
        this.dtContainer = dtContainer;
        this.dtData = dtContainer.newTrackedData();
        this.func_216961_a(this.dtData);
        if (playerInventory.field_70458_d.field_70170_p.field_72995_K) {
            for (int i = 0; i < this.dtData.func_221478_a(); ++i) {
                this.dtData.func_221477_a(i, 0);
            }
        }
        this.addSlots(playerInventory);
    }

    public ContainerDT(int windowId, PlayerInventory pi, PacketBuffer dtData) {
        this(windowId, pi, ContainerDT.getContainer(pi, dtData));
    }

    private static DTContainer getContainer(PlayerInventory pi, PacketBuffer dtData) {
        BlockPos blockPos = dtData.func_179259_c();
        DTContainerProvider dtContainerProvider = (DTContainerProvider)pi.field_70458_d.field_70170_p.func_175625_s(blockPos);
        return dtContainerProvider.getContainer(pi.field_70458_d);
    }

    public BlockPos getPosition() {
        return this.dtContainer.getPos();
    }

    public DTContainer getDTContainer() {
        return this.dtContainer;
    }

    public SlotDT getItemSlot() {
        return (SlotDT)((Object)this.field_75151_b.get(this.iIndex));
    }

    public SlotDT getDiskSlot() {
        return (SlotDT)((Object)this.field_75151_b.get(this.diskSlot));
    }

    public SlotDT getBookSlot() {
        return (SlotDT)((Object)this.field_75151_b.get(this.bookSlot));
    }

    public SlotDT getVialSlot() {
        return (SlotDT)((Object)this.field_75151_b.get(this.vialSlot));
    }

    public SlotDT getFuelSlot() {
        return (SlotDT)((Object)this.field_75151_b.get(this.fuelSlot));
    }

    public SlotDT getBondSlot() {
        return (SlotDT)((Object)this.field_75151_b.get(this.bondSlot));
    }

    public boolean func_75145_c(PlayerEntity player) {
        return this.dtContainer.canInteract(player);
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        this.dtContainer.disarm(player);
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        if (this.clickSlotTimestamp < System.currentTimeMillis() - this.clickSlotDelay) {
            this.clickSlotId = slotId;
        }
        this.clickSlotTimestamp = System.currentTimeMillis();
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack itemStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemStack1 = slot.func_75211_c();
            itemStack = itemStack1.func_77946_l();
            if ((this.clickSlotId >= this.wIndex && this.clickSlotId < this.wIndex + this.wSize && index >= this.wIndex && index < this.wIndex + this.wSize || this.clickSlotId >= this.iIndex && this.clickSlotId < this.iIndex + this.iSize && index >= this.iIndex && index < this.iIndex + this.iSize || this.clickSlotId >= this.oIndex && this.clickSlotId < this.oIndex + this.oSize && index >= this.oIndex && index < this.oIndex + this.oSize) && !this.func_75135_a(itemStack1, this.pIndex, this.pIndex + this.pSize, true)) {
                return ItemStack.field_190927_a;
            }
            if (this.clickSlotId >= this.pIndex && this.clickSlotId < this.pIndex + this.pSize && index >= this.pIndex && index < this.pIndex + this.pSize) {
                if (this.func_75135_a(itemStack1, this.wIndex, this.wIndex + this.wSize, false) || this.func_75135_a(itemStack1, this.iIndex, this.iIndex + this.iSize, false)) {
                    this.dtContainer.requestUpdateRecipe();
                } else {
                    return ItemStack.field_190927_a;
                }
            }
            if (itemStack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemStack1.func_190916_E() == itemStack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
        }
        return itemStack;
    }

    public void commandHeadS(PlayerEntity player) {
        int i;
        ModDT.LOGGER.debug("commandHeadS");
        NonNullList items = NonNullList.func_191196_a();
        for (i = 0; i < this.oSize; ++i) {
            Slot slot = this.func_75139_a(this.oIndex + i);
            items.add((Object)slot.func_75211_c());
            slot.func_75215_d(ItemStack.field_190927_a);
        }
        items.sort(Comparator.comparing(ItemStack::func_77977_a));
        for (i = 0; i < this.oSize; ++i) {
            this.func_75135_a((ItemStack)items.get(i), this.oIndex, this.oIndex + this.oSize, false);
        }
    }

    public void commandHeadD(PlayerEntity player) {
        ModDT.LOGGER.debug("commandHeadD");
        for (int i = this.oIndex; i < this.oIndex + this.oSize; ++i) {
            this.clickSlotId = i;
            this.func_82846_b(player, i);
        }
    }

    private void addSlots(PlayerInventory playerInventory) {
        int i;
        int index;
        this.iSize = this.dtContainer.getInventoryI().func_70302_i_();
        this.wSize = this.dtContainer.getInventoryW().func_70302_i_();
        this.vSize = this.dtContainer.getInventoryV().func_70302_i_();
        this.oSize = this.dtContainer.getInventoryO().func_70302_i_();
        this.pSize = 36;
        this.iIndex = index = 0;
        this.func_75146_a(new SlotDT(this.dtContainer.getInventoryI(), index++ - this.iIndex, 56, 36));
        if (this.dtContainer.getMode().hasISlots()) {
            for (int[] i2 : inventory9x3) {
                if (index == 8) {
                    SlotDT slotDT = new SlotDT(this.dtContainer.getInventoryI(), index++ - this.iIndex, inventory3x3[2][0] + 115 + 1, inventory3x3[2][1] + 17 + 1);
                    slotDT.setActive(false);
                    this.func_75146_a(slotDT);
                }
                this.func_75146_a(new SlotDT(this.dtContainer.getInventoryI(), index++ - this.iIndex, i2[0] + -61 + 1, i2[1] + 17 + 1));
            }
        } else {
            for (int i3 = 1; i3 < this.dtContainer.getInventoryI().func_70302_i_(); ++i3) {
                this.func_75146_a(new SlotDT(this.dtContainer.getInventoryI(), index++ - this.iIndex, Integer.MIN_VALUE, Integer.MIN_VALUE).setActive(false));
            }
        }
        this.wIndex = index;
        if (this.dtContainer.getMode().hasWSlots()) {
            this.diskSlot = index++;
            this.func_75146_a(new SlotDT(this.dtContainer.getInventoryW(), this.diskSlot - this.wIndex, 32, 54));
            this.bookSlot = index++;
            this.func_75146_a(new SlotDT(this.dtContainer.getInventoryW(), this.bookSlot - this.wIndex, 8, 54));
            this.vialSlot = index++;
            this.func_75146_a(new SlotDT(this.dtContainer.getInventoryW(), this.vialSlot - this.wIndex, 8, 36));
            this.fuelSlot = index++;
            this.func_75146_a(new SlotDT(this.dtContainer.getInventoryW(), this.fuelSlot - this.wIndex, 80, 54).setActive(this.dtContainer.getMode().hasFuelFlame() || this.dtContainer.getMode().hasFuelBlaze()));
            this.bondSlot = index++;
            this.func_75146_a(new SlotDT(this.dtContainer.getInventoryW(), this.bondSlot - this.wIndex, 8, 18){

                public int func_75219_a() {
                    return 1;
                }
            });
            for (i = 0; i < 5; ++i) {
                this.func_75146_a(new SlotDT(this.dtContainer.getInventoryW(), index++ - this.wIndex, 7 + 18 * i + 1, 90));
            }
        } else {
            for (i = 0; i < this.dtContainer.getInventoryW().func_70302_i_(); ++i) {
                this.func_75146_a(new SlotDT(this.dtContainer.getInventoryW(), index++ - this.wIndex, Integer.MIN_VALUE, Integer.MIN_VALUE).setActive(false));
            }
        }
        this.oIndex = index;
        if (this.dtContainer.getMode().hasOSlots()) {
            for (int[] i2 : inventory9x3) {
                this.func_75146_a(new SlotDT(this.dtContainer.getInventoryO(), index++ - this.oIndex, i2[0] + 183 + 1, i2[1] + 17 + 1));
            }
        } else {
            for (i = 0; i < this.dtContainer.getInventoryO().func_70302_i_(); ++i) {
                this.func_75146_a(new SlotDT(this.dtContainer.getInventoryO(), index++ - this.oIndex, Integer.MIN_VALUE, Integer.MIN_VALUE).setActive(false));
            }
        }
        this.vIndex = index;
        for (int[] i2 : inventory3x3) {
            this.func_75146_a(new SlotDT(this.dtContainer.getInventoryV(), index++ - this.vIndex, i2[0] + 115 + 1, i2[1] + 17 + 1, false));
        }
        this.pIndex = index;
        for (int y = -1; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new SlotDT((IInventory)playerInventory, index++ - this.pIndex, x * 18 + 7 + 1, y == -1 ? 184 : y * 18 + 125 + 1));
            }
        }
    }

    protected Slot func_75146_a(Slot slot) {
        this.slotByXYMap.put((Pair<Integer, Integer>)Pair.of((Object)slot.field_75223_e, (Object)slot.field_75221_f), slot);
        return super.func_75146_a(slot);
    }

    static {
        int x;
        int y;
        inventory3x3 = new int[9][2];
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 3; ++x) {
                ContainerDT.inventory3x3[x + y * 3][0] = x * 18;
                ContainerDT.inventory3x3[x + y * 3][1] = y * 18;
            }
        }
        inventory9x3 = new int[27][2];
        for (y = 0; y < 9; ++y) {
            for (x = 0; x < 3; ++x) {
                ContainerDT.inventory9x3[x + y * 3][0] = x * 18;
                ContainerDT.inventory9x3[x + y * 3][1] = y * 18;
            }
        }
    }
}

