/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;
import org.cursegame.minecraft.dt.configuration.Configuration;
import org.cursegame.minecraft.dt.gui.Button;
import org.cursegame.minecraft.dt.gui.ButtonTile;

public abstract class Gui<T extends Container>
extends ContainerScreen<T> {
    static ButtonTile.Offset[] OFFSET_H = new ButtonTile.Offset[]{ButtonTile.Offset.of(2, 0, Button::isDisabled), ButtonTile.Offset.of(1, 0, Button::func_230449_g_)};
    static ButtonTile.Offset[] OFFSET_V = new ButtonTile.Offset[]{ButtonTile.Offset.of(0, 2, Button::isDisabled), ButtonTile.Offset.of(0, 1, Button::func_230449_g_)};
    private Container dummy;
    private int oSize;
    private int oLeft;

    Gui(T sc, PlayerInventory i, ITextComponent titleIn) {
        super(sc, i, titleIn);
    }

    public T func_212873_a_() {
        String callerClassName = null;
        if (((Boolean)Configuration.getInstance().client.allowIntegration.get()).booleanValue()) {
            return (T)super.func_212873_a_();
        }
        callerClassName = Thread.currentThread().getStackTrace()[2].getClassName();
        if (callerClassName.startsWith("net.minecraft.") || callerClassName.startsWith("net.minecraftforge.") || callerClassName.startsWith("org.cursegame.minecraft.")) {
            return (T)super.func_212873_a_();
        }
        if (this.dummy == null) {
            this.dummy = new Container(null, this.field_147002_h.field_75152_c){

                public boolean func_75145_c(PlayerEntity player) {
                    return false;
                }
            };
        }
        return (T)this.dummy;
    }

    public void setOSize(int oSize) {
        this.oSize = oSize;
    }

    public int getXSize() {
        return this.field_146999_f + this.oSize;
    }

    public int getGuiLeft() {
        String callerClassName;
        if (((Boolean)Configuration.getInstance().client.allowIntegration.get()).booleanValue() && (callerClassName = Thread.currentThread().getStackTrace()[2].getClassName()).startsWith("vazkii.quark")) {
            return this.field_147003_i;
        }
        return this.field_147003_i + this.oLeft;
    }

    public void setOLeft(int oLeft) {
        this.oLeft = oLeft;
    }

    public int getX() {
        return this.field_147003_i;
    }

    public void setX(int x) {
        this.field_147003_i = x;
    }

    public int getY() {
        return this.field_147009_r;
    }

    public void setY(int y) {
        this.field_147009_r = y;
    }

    public int getW() {
        return this.field_146999_f;
    }

    public void setW(int w) {
        this.field_146999_f = w;
    }

    public int getH() {
        return this.field_147000_g;
    }

    public void setH(int h) {
        this.field_147000_g = h;
    }

    public void setPlayerInventoryTitleX(int playerInventoryTitleX) {
        this.field_238744_r_ = playerInventoryTitleX;
    }

    public void setPlayerInventoryTitleY(int playerInventoryTitleY) {
        this.field_238745_s_ = playerInventoryTitleY;
    }

    protected FontRenderer getFont() {
        return this.field_230712_o_;
    }

    protected String abbreviate(String text, int width) {
        String string = text;
        while (this.getFont().func_78256_a(string) > width) {
            string = StringUtils.abbreviate((String)string, (int)(string.length() - 1));
        }
        return string;
    }

    protected void doDrawString(MatrixStack ms, String text, int x, int y, int color) {
        this.getFont().func_238421_b_(ms, text, (float)x, (float)y, color);
    }

    protected void doDrawCenteredString(MatrixStack ms, String text, int x, int y, int color) {
        this.getFont().func_238421_b_(ms, text, (float)Math.round((float)x - (float)this.getFont().func_78256_a(text) / 2.0f), (float)Math.round(y), color);
    }

    protected void doDrawRightAlignedString(MatrixStack ms, String text, int x, int y, int color) {
        this.getFont().func_238421_b_(ms, text, (float)(x - this.getFont().func_78256_a(text)), (float)y, color);
    }

    protected void doDrawStringWithShadow(MatrixStack ms, String text, float x, float y, int color) {
        this.getFont().func_243246_a(ms, (ITextComponent)new StringTextComponent(text), x, y, color);
    }

    protected void doDrawCenteredStringWithShadow(MatrixStack ms, String text, float x, float y, int color) {
        this.getFont().func_243246_a(ms, (ITextComponent)new StringTextComponent(text), x - (float)this.getFont().func_78256_a(text) / 2.0f, y, color);
    }

    protected void setVisibility(Widget button, boolean visible, boolean active) {
        button.field_230694_p_ = visible;
        button.field_230693_o_ = active;
    }

    protected void setPressed(ButtonTile button, boolean pressed) {
        button.setPressed(pressed);
    }

    public boolean func_231177_au__() {
        return false;
    }

    protected <U extends Button> U add(U button) {
        return (U)((Object)((Button)super.func_230480_a_(button)));
    }

    protected void enableRepeatEvents(boolean enable) {
        this.field_230706_i_.field_195559_v.func_197967_a(enable);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.enableRepeatEvents(true);
        this.doInit();
    }

    protected void doInit() {
    }

    protected final void func_230450_a_(MatrixStack ms, float partialTicks, int mouseX, int mouseY) {
        this.doDrawBackground(ms, mouseX, mouseY);
    }

    protected void doDrawBackground(MatrixStack ms, int mouseX, int mouseY) {
    }

    protected final void func_230451_b_(MatrixStack ms, int mouseX, int mouseY) {
        this.doDrawForeground(ms, mouseX, mouseY);
    }

    protected void doDrawForeground(MatrixStack ms, int mouseX, int mouseY) {
        super.func_230451_b_(ms, mouseX, mouseY);
    }

    protected void doRenderBackgroundBacklit(MatrixStack ms) {
        super.func_230446_a_(ms);
    }

    public final boolean func_231044_a_(double mouseX, double mouseY, int button) {
        return this.isMouseClicked(mouseX, mouseY, button);
    }

    protected boolean isMouseClicked(double mouseX, double mouseY, int button) {
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public final boolean func_231042_a_(char codePoint, int modifiers) {
        return this.isCharTyped(codePoint, modifiers);
    }

    protected boolean isCharTyped(char codePoint, int modifiers) {
        return super.func_231042_a_(codePoint, modifiers);
    }

    public final boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        return this.isKeyPressed(keyCode, scanCode, modifiers);
    }

    protected boolean isKeyPressed(int keyCode, int scanCode, int modifiers) {
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    @OnlyIn(value=Dist.CLIENT)
    public final void func_231023_e_() {
        this.doTick();
    }

    protected void doTick() {
    }

    public final void func_231175_as__() {
        super.func_231175_as__();
        this.enableRepeatEvents(false);
    }

    public final void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.doUpdateControls();
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.doRenderTooltip(matrixStack, mouseX, mouseY);
    }

    protected final void func_230459_a_(MatrixStack ms, int mouseX, int mouseY) {
        this.doRenderTooltip(ms, mouseX, mouseY);
    }

    protected void doRenderTooltip(MatrixStack ms, int mouseX, int mouseY) {
        super.func_230459_a_(ms, mouseX, mouseY);
    }

    public final void func_238652_a_(MatrixStack matrixStack, ITextComponent text, int mouseX, int mouseY) {
        this.doRenderTooltip(matrixStack, text, mouseX, mouseY);
    }

    protected void doRenderTooltip(MatrixStack matrixStack, ITextComponent text, int mouseX, int mouseY) {
        super.func_238652_a_(matrixStack, text, mouseX, mouseY);
    }

    protected void doUpdateControls() {
    }
}

