/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.cursegame.minecraft.dt.ModDT;
import org.cursegame.minecraft.dt.gui.Button;
import org.cursegame.minecraft.dt.gui.ButtonTile;
import org.cursegame.minecraft.dt.gui.ContainerDT;
import org.cursegame.minecraft.dt.gui.Gui;
import org.cursegame.minecraft.dt.gui.GuiConstants;
import org.cursegame.minecraft.dt.gui.SlotDT;
import org.cursegame.minecraft.dt.network.PacketHandler;
import org.cursegame.minecraft.dt.network.ServerMessageDT;
import org.cursegame.minecraft.dt.tileentity.DTContainer;
import org.cursegame.minecraft.dt.util.I18N;

@OnlyIn(value=Dist.CLIENT)
public class GuiDT
extends Gui<ContainerDT>
implements GuiConstants {
    private static final int C_TEXT = 0xA8A8A8;
    private static final int C_WARN = 0xA80000;
    private static final int C_INFO = 43008;
    private ButtonTile bS;
    private ButtonTile bC;
    private ButtonTile bA;
    private ButtonTile bN;
    private ButtonTile bB;
    private ButtonTile bHS;
    private ButtonTile bHD;
    private ButtonTile.Offset[] normalOffsets = new ButtonTile.Offset[]{ButtonTile.Offset.of(1, 1, Button::isDisabled), ButtonTile.Offset.of(1, 0, Button::func_230449_g_)};
    private ButtonTile.Offset[] toggleOffsets = new ButtonTile.Offset[]{ButtonTile.Offset.of(1, 1, Button::isDisabled), ButtonTile.Offset.of(0, 1, Button::isPressed), ButtonTile.Offset.of(1, 0, Button::func_230449_g_)};
    private Slot hoveringSlot;

    public GuiDT(ContainerDT container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        this.setH(208);
        this.setPlayerInventoryTitleX(8);
        this.setPlayerInventoryTitleY(114);
        int oSize = 0;
        if (container.getDTContainer().getMode().hasISlots()) {
            oSize += SCREEN_L_SIDE.getW();
        }
        if (container.getDTContainer().getMode().hasOSlots()) {
            oSize += SCREEN_R_SIDE.getW();
        }
        this.setOSize(oSize);
        if (container.getDTContainer().getMode().hasISlots()) {
            this.setOLeft(-SCREEN_L_SIDE.getW());
        }
    }

    @Override
    public void doInit() {
        DTContainer dtContainer = ((ContainerDT)this.field_147002_h).getDTContainer();
        this.bS = new ButtonTile(this, B_1, I18n.func_135052_a((String)I18N.BUTTON_START.getKey(), (Object[])new Object[0]), this.normalOffsets, this.commandStart());
        this.add(this.bS);
        this.bC = new ButtonTile(this, B_1, I18n.func_135052_a((String)I18N.BUTTON_CANCEL.getKey(), (Object[])new Object[0]), this.normalOffsets, this.commandCancel());
        this.add(this.bC);
        this.bA = new ButtonTile(this, B_2, I18n.func_135052_a((String)I18N.BUTTON_AUTO.getKey(), (Object[])new Object[0]), this.toggleOffsets, this.commandToggleAuto());
        this.add(this.bA);
        this.bN = new ButtonTile(this, B_NEXT, "", OFFSET_H, this.commandNext());
        this.add(this.bN);
        this.bB = new ButtonTile(this, B_BOOK, "", OFFSET_V, this.commandBook());
        this.add(this.bB);
        if (dtContainer.getMode().hasOSlots()) {
            this.bHS = new ButtonTile(this, B_HEAD_S, "", OFFSET_V, this.commandHeadS());
            this.add(this.bHS);
            this.bHD = new ButtonTile(this, B_HEAD_D, "", OFFSET_V, this.commandHeadD());
            this.add(this.bHD);
        }
    }

    protected Button.IPressable commandStart() {
        return pressable -> PacketHandler.sendToServer(new ServerMessageDT(ServerMessageDT.Action.START, ((ContainerDT)this.field_147002_h).getPosition()));
    }

    protected Button.IPressable commandCancel() {
        return pressable -> PacketHandler.sendToServer(new ServerMessageDT(ServerMessageDT.Action.CANCEL, ((ContainerDT)this.field_147002_h).getPosition()));
    }

    protected Button.IPressable commandToggleAuto() {
        return pressable -> PacketHandler.sendToServer(new ServerMessageDT(ServerMessageDT.Action.TOGGLE_AUTO, ((ContainerDT)this.field_147002_h).getPosition()));
    }

    protected Button.IPressable commandNext() {
        return pressable -> PacketHandler.sendToServer(new ServerMessageDT(ServerMessageDT.Action.BROWSE_RECIPE, ((ContainerDT)this.field_147002_h).getPosition()));
    }

    protected Button.IPressable commandHeadS() {
        return pressable -> PacketHandler.sendToServer(new ServerMessageDT(ServerMessageDT.Action.HEAD_S, ((ContainerDT)this.field_147002_h).getPosition()));
    }

    protected Button.IPressable commandHeadD() {
        return pressable -> PacketHandler.sendToServer(new ServerMessageDT(ServerMessageDT.Action.HEAD_D, ((ContainerDT)this.field_147002_h).getPosition()));
    }

    protected Button.IPressable commandBook() {
        return pressable -> {};
    }

    protected boolean func_195359_a(int x, int y, int w, int h, double p_97772_, double p_97773_) {
        boolean hovering = super.func_195359_a(x, y, w, h, p_97772_, p_97773_);
        this.hoveringSlot = hovering ? ((ContainerDT)((Object)this.func_212873_a_())).slotByXYMap.get(Pair.of((Object)x, (Object)y)) : null;
        return hovering;
    }

    public int getSlotColor(int index) {
        Slot slot = this.hoveringSlot;
        if (slot != null && slot.field_75224_c == ((ContainerDT)((Object)this.func_212873_a_())).getDTContainer().getInventoryV()) {
            return 0;
        }
        return super.getSlotColor(index);
    }

    protected boolean func_195361_a(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        if (super.func_195361_a(mouseX, mouseY, guiLeftIn, guiTopIn, mouseButton)) {
            int pointX = (int)mouseX;
            int pointY = (int)mouseY;
            if (((ContainerDT)((Object)this.func_212873_a_())).getDTContainer().getMode().hasISlots() && SCREEN_L_SIDE.isPointIn(pointX, pointY, guiLeftIn, guiTopIn)) {
                return false;
            }
            return !((ContainerDT)((Object)this.func_212873_a_())).getDTContainer().getMode().hasOSlots() || !SCREEN_R_SIDE.isPointIn(pointX, pointY, guiLeftIn, guiTopIn);
        }
        return false;
    }

    @Override
    protected void doDrawBackground(MatrixStack ms, int mouseX, int mouseY) {
        this.doRenderBackgroundBacklit(ms);
        DTContainer dtContainer = ((ContainerDT)this.field_147002_h).getDTContainer();
        SCREEN_BASE.renderBG(this, ms);
        if (dtContainer.getMode().hasISlots()) {
            SCREEN_L_SIDE.renderBG(this, ms);
        }
        if (dtContainer.getMode().hasOSlots()) {
            SCREEN_R_SIDE.renderBG(this, ms);
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        ITEM_SLOT.renderBG(this, ms);
        if (dtContainer.getMode().hasWSlots()) {
            DISK_SLOT.renderBG(this, ms);
            BOOK_SLOT.renderBG(this, ms);
            if (dtContainer.getMode().hasFuelFlame() || dtContainer.getMode().hasFuelBlaze()) {
                FUEL_SLOT.renderBG(this, ms);
            }
        }
        if (dtContainer.getMode().hasWSlots()) {
            WORK.renderBG(this, ms);
        }
        for (Slot slot : ((ContainerDT)this.field_147002_h).field_75151_b) {
            if (slot.field_75224_c == dtContainer.getInventoryV() && dtContainer.isRecipeDisabled()) {
                SLOT_DISABLED.renderBG(this, ms, slot.field_75223_e, slot.field_75221_f);
            }
            if (slot == ((ContainerDT)this.field_147002_h).getItemSlot() && slot.func_75211_c().func_190926_b()) {
                W_MARK_I0.renderBG(this, ms, slot.field_75223_e, slot.field_75221_f);
            }
            if (slot.field_75224_c != dtContainer.getInventoryW()) continue;
            if (slot == ((ContainerDT)this.field_147002_h).getDiskSlot() && slot.func_75211_c().func_190926_b()) {
                W_MARK_W0.renderBG(this, ms, slot.field_75223_e, slot.field_75221_f);
            }
            if (slot == ((ContainerDT)this.field_147002_h).getBookSlot() && slot.func_75211_c().func_190926_b()) {
                W_MARK_W1.renderBG(this, ms, slot.field_75223_e, slot.field_75221_f);
            }
            if (slot == ((ContainerDT)this.field_147002_h).getVialSlot() && slot.func_111238_b()) {
                VIAL_SLOT.renderBG(this, ms);
                if (slot.func_75211_c().func_190926_b()) {
                    W_MARK_W2.renderBG(this, ms, slot.field_75223_e, slot.field_75221_f);
                }
            }
            if (slot == ((ContainerDT)this.field_147002_h).getBondSlot() && slot.func_111238_b()) {
                BOND_SLOT.renderBG(this, ms);
                if (slot.func_75211_c().func_190926_b()) {
                    W_MARK_W5.renderBG(this, ms, slot.field_75223_e, slot.field_75221_f);
                }
            }
            if (slot != ((ContainerDT)this.field_147002_h).getFuelSlot() || !slot.func_75211_c().func_190926_b()) continue;
            if (dtContainer.getMode().hasFuelFlame()) {
                W_MARK_W3.renderBG(this, ms, slot.field_75223_e, slot.field_75221_f);
            }
            if (!dtContainer.getMode().hasFuelBlaze()) continue;
            W_MARK_W4.renderBG(this, ms, slot.field_75223_e, slot.field_75221_f);
        }
        if (dtContainer.isRecipeXpInflation() && ((ContainerDT)this.field_147002_h).getVialSlot().func_111238_b()) {
            SPIRAL_BOND.renderBG(this, ms);
            SPIRAL_VIAL.renderBG(this, ms);
        }
        if (dtContainer.isRecipeXpDeflation() && ((ContainerDT)this.field_147002_h).getBondSlot().func_111238_b()) {
            SPIRAL_BOND.renderBG(this, ms);
        }
        PROGRESS_BASE.renderBG(this, ms);
        if (dtContainer.getMode().hasWSlots()) {
            if (dtContainer.getMode().hasFuelFlame()) {
                FUEL_BASE.renderBG(this, ms);
                THERMOMETER_BASE.renderBG(this, ms);
                FIRE_BASE.renderBG(this, ms);
            }
            if (dtContainer.getMode().hasFuelBlaze()) {
                FUEL_BASE.renderBG(this, ms);
                SMOG_BASE.renderBG(this, ms);
            }
        }
    }

    @Override
    protected void doDrawForeground(MatrixStack ms, int mouseX, int mouseY) {
        int count;
        super.doDrawForeground(ms, mouseX, mouseY);
        DTContainer dtContainer = ((ContainerDT)this.field_147002_h).getDTContainer();
        if (dtContainer.getStateProgress() > 0) {
            PROGRESS.renderFGPartHL((Screen)this, ms, dtContainer.getStateProgress(), dtContainer.getStateProgressMax() + 1);
        }
        if (dtContainer.getMode().hasWSlots()) {
            if (dtContainer.getMode().hasFuelFlame()) {
                if (dtContainer.getStateTemperature() > 0) {
                    THERMOMETER_PART.renderFGPartVD((Screen)this, ms, dtContainer.getStateTemperature(), dtContainer.getStateTemperatureMax());
                }
                if (dtContainer.getStateBurn() > 0) {
                    FIRE_PART.renderFGPartVD((Screen)this, ms, dtContainer.getStateBurn(), dtContainer.getStateBurnMax() + 1);
                }
            }
            if (dtContainer.getMode().hasFuelBlaze()) {
                if (dtContainer.getStateBurn() > 0) {
                    SMOG_PART.renderFGPartVD((Screen)this, ms, dtContainer.getStateBurn(), dtContainer.getStateBurnMax() + 1);
                }
                if (dtContainer.getStateFuel() > 0) {
                    FUEL_PART.renderFGPartHL((Screen)this, ms, dtContainer.getStateFuel(), dtContainer.getStateFuelMax() + 1);
                }
            }
        }
        if (dtContainer.isRecipeNestedContent()) {
            this.doDrawRightAlignedString(ms, "Nc", 114, 58, 0xA8A8A8);
        } else {
            if (dtContainer.isRecipeRequireXp()) {
                this.doDrawRightAlignedString(ms, "Xp", 114, 58, 0xA80000);
            }
            if (dtContainer.isRecipeProduceXp()) {
                this.doDrawRightAlignedString(ms, "Xp", 114, 58, 43008);
            }
        }
        SlotDT itemSlot = ((ContainerDT)this.field_147002_h).getItemSlot();
        if (!itemSlot.func_75211_c().func_190926_b() && dtContainer.getRecipeItemInput() > 0 && (count = itemSlot.func_75211_c().func_190916_E()) < dtContainer.getRecipeItemInput()) {
            this.doDrawCenteredString(ms, count + "/" + dtContainer.getRecipeItemInput(), itemSlot.field_75223_e + 8, itemSlot.field_75221_f - 9, 0xA80000);
        }
    }

    @Override
    protected void doUpdateControls() {
        DTContainer dtContainer = ((ContainerDT)this.field_147002_h).getDTContainer();
        ((ContainerDT)((Object)this.func_212873_a_())).getBondSlot().setActive(dtContainer.getVialStack().func_190926_b());
        ((ContainerDT)((Object)this.func_212873_a_())).getVialSlot().setActive(dtContainer.getBondStack().func_190926_b());
        boolean canControl = !dtContainer.isStateStartedAutomatically();
        this.setVisibility((Widget)this.bS, !canControl || !dtContainer.isStateStarted(), canControl && dtContainer.isStartEnabled());
        this.setVisibility((Widget)this.bC, canControl && dtContainer.isStateStarted(), canControl);
        this.setVisibility((Widget)this.bA, dtContainer.getMode().hasAutomation(), dtContainer.isStartAutomationEnabled());
        this.setPressed(this.bA, dtContainer.isStateStartedAutomatically());
        this.setVisibility((Widget)this.bN, dtContainer.isRecipeAmbiguous() && dtContainer.isRecipeAvailable() && !((ContainerDT)this.field_147002_h).getDTContainer().getInventoryV().func_70301_a(0).func_190926_b(), dtContainer.isRecipeAmbiguous() && canControl && !dtContainer.isStateStarted());
        this.setVisibility((Widget)this.bB, false, false);
    }

    @Override
    public boolean isKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            return super.isKeyPressed(keyCode, scanCode, modifiers);
        }
        if (keyCode == 73 && (modifiers & 2) == 2) {
            DTContainer dtContainer = ((ContainerDT)this.field_147002_h).getDTContainer();
            ModDT.LOGGER.info("Container state: ii={}, id={}, ib={}, iv={}, ra={}, rb={}, rd={}, rx={}, xi={}, xd={}, bc={}, bm={}, fc={}, fm={}, tc={}, tm={}, pc={}, pm={}, ss={}, rs={}", new Object[]{dtContainer.getRecipeItemInput(), dtContainer.getRecipeDiskInput(), dtContainer.getRecipeBookInput(), dtContainer.getRecipeVialInput(), dtContainer.isRecipeAvailable(), dtContainer.isRecipeAmbiguous(), dtContainer.isRecipeDisabled(), dtContainer.isRecipeRequireXp(), dtContainer.isRecipeXpInflation(), dtContainer.isRecipeXpDeflation(), dtContainer.getStateBurn(), dtContainer.getStateBurnMax(), dtContainer.getStateFuel(), dtContainer.getStateFuelMax(), dtContainer.getStateTemperature(), dtContainer.getStateTemperatureMax(), dtContainer.getStateProgress(), dtContainer.getStateProgressMax(), dtContainer.getState(), dtContainer.getRecipeState()});
            return true;
        }
        return false;
    }
}

