/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.cursegame.minecraft.dt.gui.Gui;

public class Tile {
    private final int s_x;
    private final int s_y;
    private final int s_w;
    private final int s_h;
    private final int d_x;
    private final int d_y;
    private ResourceLocation texture;

    public Tile(int s_x, int s_y, int s_w, int s_h) {
        this(s_x, s_y, s_w, s_h, 0, 0);
    }

    public Tile(int s_x, int s_y, int s_w, int s_h, int d_x, int d_y) {
        this.s_x = s_x;
        this.s_y = s_y;
        this.s_w = s_w;
        this.s_h = s_h;
        this.d_x = d_x;
        this.d_y = d_y;
    }

    public int getDX() {
        return this.d_x;
    }

    public int getDY() {
        return this.d_y;
    }

    public int getSX() {
        return this.s_x;
    }

    public int getSY() {
        return this.s_y;
    }

    public int getW() {
        return this.s_w;
    }

    public int getH() {
        return this.s_h;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public Tile bind(ResourceLocation texture) {
        this.texture = texture;
        return this;
    }

    public Tile offset(int x, int y) {
        return new Tile(this.s_x, this.s_y, this.s_w, this.s_h, x, y).bind(this.texture);
    }

    private void render(Screen screen, MatrixStack ms, int x, int y, int u_x, int u_y, int u_w, int u_h) {
        if (this.texture != null) {
            screen.getMinecraft().func_110434_K().func_110577_a(this.texture);
        }
        screen.func_238474_b_(ms, x, y, u_x, u_y, u_w, u_h);
    }

    public void render(Gui<?> screen, MatrixStack ms, int x, int y) {
        this.render(screen, ms, x, y, 0, 0);
    }

    public void render(Gui<?> screen, MatrixStack ms, int x, int y, int o_x, int o_y) {
        this.render((Screen)screen, ms, x + this.d_x, y + this.d_y, this.s_x + o_x, this.s_y + o_y, this.s_w, this.s_h);
    }

    public void renderBG(Gui<?> screen, MatrixStack ms) {
        this.renderBG(screen, ms, 0, 0);
    }

    public void renderBG(Gui<?> screen, MatrixStack ms, int x, int y) {
        this.renderBG(screen, ms, x, y, 0, 0);
    }

    public void renderBG(Gui<?> screen, MatrixStack ms, int x, int y, int o_x, int o_y) {
        this.render((Screen)screen, ms, screen.getX() + x + this.d_x, screen.getY() + y + this.d_y, this.s_x + o_x, this.s_y + o_y, this.s_w, this.s_h);
    }

    public void renderFGPartVD(Screen screen, MatrixStack ms, int value, int valueMax) {
        int k = 1 + this.s_h * value / valueMax;
        this.render(screen, ms, this.d_x, this.d_y + this.s_h - k, this.s_x, this.s_y + this.s_h - k, this.s_w, k);
    }

    public void renderFGPartHL(Screen screen, MatrixStack ms, int value, int valueMax) {
        int k = 1 + this.s_w * value / valueMax;
        this.render(screen, ms, this.d_x, this.d_y, this.s_x, this.s_y, k, this.s_h);
    }

    public boolean isPointIn(int pointX, int pointY, int o_x, int o_y) {
        return pointX > o_x + this.d_x && pointX < o_x + this.d_x + this.s_w && pointY > o_y + this.d_y && pointY < o_y + this.d_y + this.s_h;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("s_x", this.s_x).append("s_y", this.s_y).append("s_w", this.s_w).append("s_h", this.s_h).toString();
    }
}

