/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.BlockItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.Items;
import net.minecraft.item.TieredItem;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cursegame.minecraft.dt.item.ItemBase;
import org.cursegame.minecraft.dt.registry.ModTags;
import org.cursegame.minecraft.dt.registry.ModTriggers;

public class ItemDisk
extends TieredItem
implements ItemBase {
    private final String name;
    private final ItemTier dust;
    private final ItemTier base;
    public static Color C_BASE = Color.func_240743_a_((int)0x7F7F7F);
    public static Color C_TEXT = Color.func_240743_a_((int)0xA8A8A8);
    public static Color C_DATA = Color.func_240743_a_((int)5526780);
    public static final ItemDisk DUMMY = new ItemDisk("dummy", ItemTier.WOOD, ItemTier.WOOD){

        @Override
        public float getSpeedFactor(ItemStack stack) {
            return 1.0f;
        }
    };

    public ItemDisk(String name, ItemTier dust, ItemTier base) {
        super((IItemTier)base, ItemBase.getBuilder().func_200918_c(base.func_200926_a() / 5));
        this.name = name;
        this.dust = dust;
        this.base = base;
    }

    public String func_77667_c(ItemStack stack) {
        return "corail_dt.item.disk_" + this.dust.ordinal();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        TranslationTextComponent textBase = new TranslationTextComponent("corail_dt.item.base_" + this.base.ordinal());
        textBase.func_230530_a_(Style.field_240709_b_.func_240718_a_(C_BASE));
        tooltip.add((ITextComponent)textBase);
        TranslationTextComponent textData = new TranslationTextComponent("corail_dt.item.data");
        textData.func_230530_a_(Style.field_240709_b_.func_240718_a_(C_TEXT));
        tooltip.add((ITextComponent)textData);
        TranslationTextComponent textP1 = new TranslationTextComponent("corail_dt.item.data.p1", new Object[]{stack.func_77958_k()});
        textP1.func_230530_a_(Style.field_240709_b_.func_240718_a_(C_DATA));
        tooltip.add((ITextComponent)textP1);
        TranslationTextComponent textP2 = new TranslationTextComponent("corail_dt.item.data.p2", new Object[]{this.dust.func_200925_d()});
        textP2.func_230530_a_(Style.field_240709_b_.func_240718_a_(C_DATA));
        tooltip.add((ITextComponent)textP2);
        TranslationTextComponent textP3 = new TranslationTextComponent("corail_dt.item.data.p3", new Object[]{String.format("%.1f", Float.valueOf(this.getSpeedFactor(stack)))});
        textP3.func_230530_a_(Style.field_240709_b_.func_240718_a_(C_DATA));
        tooltip.add((ITextComponent)textP3);
    }

    public void func_77622_d(ItemStack stack, World level, PlayerEntity player) {
        if (level.field_72995_K) {
            return;
        }
        this.onCraftedBy(stack, (ServerPlayerEntity)player);
    }

    public void onCraftedBy(ItemStack stack, ServerPlayerEntity player) {
        if (stack.func_77973_b().func_206844_a(ModTags.Items.disk_0)) {
            ModTriggers.BUILD_DISK_0.trigger(player);
        }
        if (stack.func_77973_b().func_206844_a(ModTags.Items.disk_1)) {
            ModTriggers.BUILD_DISK_1.trigger(player);
        }
        if (stack.func_77973_b().func_206844_a(ModTags.Items.disk_2)) {
            ModTriggers.BUILD_DISK_2.trigger(player);
        }
        if (stack.func_77973_b().func_206844_a(ModTags.Items.disk_3)) {
            ModTriggers.BUILD_DISK_3.trigger(player);
        }
        if (stack.func_77973_b().func_206844_a(ModTags.Items.disk_4)) {
            ModTriggers.BUILD_DISK_4.trigger(player);
        }
        if (stack.func_77973_b().func_206844_a(ModTags.Items.disk_5)) {
            ModTriggers.BUILD_DISK_5.trigger(player);
        }
    }

    public float getXpRepairRatio(ItemStack stack) {
        return 1.0f;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return EnchantmentHelper.func_82781_a((ItemStack)book).entrySet().stream().anyMatch(p -> this.canApplyAtEnchantingTable(stack, (Enchantment)p.getKey()));
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.field_185307_s || enchantment == Enchantments.field_185308_t || enchantment == Enchantments.field_185296_A || enchantment == Enchantments.field_185305_q || enchantment == Enchantments.field_185306_r;
    }

    public float getSpeedFactor(ItemStack stack) {
        float factor = this.dust.func_200928_b();
        int boostLevel = EnchantmentHelper.func_82781_a((ItemStack)stack).getOrDefault(Enchantments.field_185305_q, 0);
        if (boostLevel > 0) {
            factor += (float)(boostLevel * boostLevel + 1);
        }
        return factor;
    }

    public boolean canGrind(ItemStack diskStack, ItemStack itemStack) {
        BlockState block = ItemDisk.getBlockFromItem(itemStack).func_176223_P();
        if (block.func_235783_q_()) {
            int boostLevel = EnchantmentHelper.func_82781_a((ItemStack)diskStack).getOrDefault(Enchantments.field_185306_r, 0);
            if (boostLevel > 0) {
                return false;
            }
            switch (this.dust) {
                case WOOD: {
                    return Items.field_151039_o.canHarvestBlock(null, block);
                }
                case STONE: {
                    return Items.field_151050_s.canHarvestBlock(null, block);
                }
                case IRON: {
                    return Items.field_151035_b.canHarvestBlock(null, block);
                }
                case DIAMOND: {
                    return Items.field_151046_w.canHarvestBlock(null, block);
                }
                case GOLD: {
                    return Items.field_151005_D.canHarvestBlock(null, block);
                }
                case NETHERITE: {
                    return Items.field_234756_kK_.canHarvestBlock(null, block);
                }
            }
        }
        return true;
    }

    public static int getGrindTime(ItemStack itemStack) {
        return Math.round(ItemDisk.getBlockFromItem(itemStack).func_176223_P().func_185887_b(null, null) * 20.0f);
    }

    private static Block getBlockFromItem(ItemStack itemStack) {
        Block block = Blocks.field_196556_aL;
        if (itemStack.func_77973_b() instanceof BlockItem) {
            block = ((BlockItem)itemStack.func_77973_b()).func_179223_d();
        }
        if (itemStack.func_77973_b() instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)itemStack.func_77973_b();
            if (tieredItem.func_200891_e() == ItemTier.WOOD) {
                block = Blocks.field_196626_Q;
            }
            if (tieredItem.func_200891_e() == ItemTier.STONE) {
                block = Blocks.field_150348_b;
            }
            if (tieredItem.func_200891_e() == ItemTier.IRON) {
                block = Blocks.field_150339_S;
            }
            if (tieredItem.func_200891_e() == ItemTier.DIAMOND) {
                block = Blocks.field_150484_ah;
            }
            if (tieredItem.func_200891_e() == ItemTier.GOLD) {
                block = Blocks.field_150340_R;
            }
            if (tieredItem.func_200891_e() == ItemTier.NETHERITE) {
                block = Blocks.field_235397_ng_;
            }
        }
        if (itemStack.func_77973_b() instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)itemStack.func_77973_b();
            if (armorItem.func_200880_d() == ArmorMaterial.LEATHER) {
                block = Blocks.field_196556_aL;
            }
            if (armorItem.func_200880_d() == ArmorMaterial.GOLD) {
                block = Blocks.field_150340_R;
            }
            if (armorItem.func_200880_d() == ArmorMaterial.CHAIN) {
                block = Blocks.field_150411_aY;
            }
            if (armorItem.func_200880_d() == ArmorMaterial.IRON) {
                block = Blocks.field_150339_S;
            }
            if (armorItem.func_200880_d() == ArmorMaterial.TURTLE) {
                block = Blocks.field_150339_S;
            }
            if (armorItem.func_200880_d() == ArmorMaterial.DIAMOND) {
                block = Blocks.field_150484_ah;
            }
            if (armorItem.func_200880_d() == ArmorMaterial.NETHERITE) {
                block = Blocks.field_235397_ng_;
            }
        }
        return block;
    }
}

