/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cursegame.minecraft.dt.block.BlockCrystalTable;
import org.cursegame.minecraft.dt.item.ItemBase;
import org.cursegame.minecraft.dt.registry.ModTriggers;
import org.cursegame.minecraft.dt.tileentity.TileEntityCrystalTable;

public class ItemVial
extends Item
implements ItemBase {
    private final int id;
    public static Color C_TEXT = Color.func_240743_a_((int)0xA8A8A8);
    public static Color C_DATA = Color.func_240743_a_((int)43008);

    public ItemVial(int id) {
        super(ItemBase.getBuilder().func_200917_a(64 >> id));
        this.id = id;
    }

    public void func_77622_d(ItemStack stack, World level, PlayerEntity player) {
        if (level.field_72995_K) {
            return;
        }
        this.onCraftedBy(stack, (ServerPlayerEntity)player);
    }

    public void onCraftedBy(ItemStack stack, ServerPlayerEntity player) {
        switch (this.id) {
            case 0: {
                ModTriggers.BUILD_VIAL_0.trigger(player);
                break;
            }
            case 1: {
                ModTriggers.BUILD_VIAL_1.trigger(player);
                break;
            }
            case 2: {
                ModTriggers.BUILD_VIAL_2.trigger(player);
                break;
            }
            case 3: {
                ModTriggers.BUILD_VIAL_3.trigger(player);
                break;
            }
            case 4: {
                ModTriggers.BUILD_VIAL_4.trigger(player);
            }
        }
    }

    public String func_77658_a() {
        return "corail_dt.item.vial_" + this.id;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ActionResultType parentResult = super.func_195939_a(context);
        if (parentResult.func_226246_a_()) {
            return parentResult;
        }
        World level = context.func_195991_k();
        BlockState blockState = level.func_180495_p(context.func_195995_a());
        if (blockState.func_177230_c() instanceof BlockCrystalTable) {
            TileEntityCrystalTable tileEntityCrystal = (TileEntityCrystalTable)level.func_175625_s(context.func_195995_a());
            if (!level.field_72995_K && tileEntityCrystal.addCharge(ItemVial.charge(context.func_195996_i(), (ServerPlayerEntity)context.func_195999_j(), 7.0f)) == 0.0f) {
                return ActionResultType.FAIL;
            }
        }
        return ActionResultType.PASS;
    }

    public boolean func_77636_d(ItemStack stack) {
        return ItemVial.getItemCharge(stack) >= ItemVial.getItemMaxCharge(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        float chargeAmount = ItemVial.getItemCharge(stack) / (float)ItemVial.getChargeMax(this.id);
        String state = chargeAmount == 0.0f ? "s0" : ((double)chargeAmount < 0.1 ? "s1" : ((double)chargeAmount < 0.5 ? "s2" : ((double)chargeAmount < 0.9 ? "s3" : ((double)chargeAmount < 1.0 ? "s4" : "s5"))));
        TranslationTextComponent textP4 = new TranslationTextComponent("corail_dt.item.data." + state);
        textP4.func_230530_a_(Style.field_240709_b_.func_240718_a_(C_DATA));
        tooltip.add((ITextComponent)textP4);
    }

    public static int getChargeMax(int id) {
        int multiplier = 1;
        switch (id) {
            case 4: {
                multiplier *= 5;
            }
            case 3: {
                multiplier *= 5;
            }
            case 2: {
                multiplier *= 5;
            }
            case 1: {
                multiplier *= 5;
            }
            case 0: {
                multiplier *= 5;
            }
        }
        return 7 * multiplier;
    }

    public static int absorb(ItemStack itemStack, ServerPlayerEntity player, int amount) {
        float result = -ItemVial.charge(itemStack, player, -amount);
        return (int)result;
    }

    public static float charge(ItemStack itemStack, @Nullable ServerPlayerEntity player, float amount) {
        float consume;
        float result;
        if (amount == 0.0f) {
            return amount;
        }
        ItemVial item = (ItemVial)itemStack.func_77973_b();
        float itemCharge = ItemVial.getItemCharge(itemStack);
        float itemChargeMax = ItemVial.getItemMaxCharge(itemStack);
        float charge = itemCharge;
        if (amount < 0.0f) {
            result = amount;
            if (itemCharge < itemChargeMax) {
                consume = itemChargeMax - itemCharge;
                if (consume > -result) {
                    consume = -result;
                }
                result += consume;
                if (player != null) {
                    if (consume > 0.0f) {
                        ModTriggers.FILL_VIAL.trigger(player);
                    }
                    if (item.id == 4 && (charge += consume) == itemChargeMax) {
                        ModTriggers.FILL_VIAL_4.trigger(player);
                    }
                }
            }
        } else {
            result = 0.0f;
            if (itemCharge > 0.0f) {
                consume = Math.min(charge, amount);
                result += consume;
                charge -= consume;
            }
        }
        if (charge != itemCharge) {
            ItemStack s = null;
            if (itemStack.func_190916_E() > 1) {
                s = itemStack.func_77979_a(itemStack.func_190916_E() - 1);
            }
            ItemVial.setItemCharge(itemStack, charge);
            if (s != null && player != null) {
                player.func_191521_c(s);
            }
        }
        return result;
    }

    private static float round(float chargeValue) {
        return (float)Math.round(chargeValue * 100.0f) / 100.0f;
    }

    public static float getItemCharge(ItemStack itemStack) {
        CompoundNBT chargeNbt;
        if (itemStack.func_77973_b() instanceof ItemVial && (chargeNbt = itemStack.func_179543_a("Charge")) != null) {
            float value = ItemVial.round(chargeNbt.func_74760_g("Value"));
            if (value > 0.0f) {
                return value;
            }
            itemStack.func_196083_e("Charge");
        }
        return 0.0f;
    }

    public static void setItemCharge(ItemStack itemStack, float charge) {
        if (itemStack.func_77973_b() instanceof ItemVial) {
            if (charge > 0.0f) {
                CompoundNBT chargeNbt = itemStack.func_190925_c("Charge");
                chargeNbt.func_74776_a("Value", ItemVial.round(charge));
                chargeNbt.func_74772_a("Stamp", System.currentTimeMillis());
            } else {
                itemStack.func_196083_e("Charge");
            }
        }
    }

    public static float getItemMaxCharge(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof ItemVial) {
            ItemVial itemCrystal = (ItemVial)itemStack.func_77973_b();
            return ItemVial.getChargeMax(itemCrystal.id);
        }
        return 0.0f;
    }

    public static float getFullnessPropertyOverride(ItemStack itemStack, @Nullable World level, @Nullable LivingEntity livingEntity) {
        float chargeMax = ItemVial.getItemMaxCharge(itemStack);
        return (double)(ItemVial.getItemCharge(itemStack) / (chargeMax + 1.0f)) < 0.1 ? 0.0f : 1.0f;
    }
}

