/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import org.cursegame.minecraft.dt.ModDT;
import org.cursegame.minecraft.dt.gui.ContainerDT;
import org.cursegame.minecraft.dt.tileentity.DTController;
import org.cursegame.minecraft.dt.tileentity.DTControllerProvider;

public class ServerMessageDT {
    private final Action action;
    private final BlockPos pos;

    public ServerMessageDT(Action action, BlockPos pos) {
        this.action = action;
        this.pos = pos;
    }

    static ServerMessageDT fromBytes(PacketBuffer buf) {
        return new ServerMessageDT(Action.values()[buf.readShort()], buf.func_179259_c());
    }

    static void toBytes(ServerMessageDT msg, PacketBuffer buf) {
        buf.writeShort(msg.action.ordinal());
        buf.func_179255_a(msg.pos);
    }

    static class Handler {
        Handler() {
        }

        static void handle(ServerMessageDT message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player != null) {
                    TileEntity tileEntity = player.field_70170_p.func_175625_s(message.pos);
                    if (tileEntity instanceof DTControllerProvider) {
                        DTController playerController = ((DTControllerProvider)tileEntity).getController(player);
                        if (playerController != null) {
                            switch (message.action) {
                                case START: {
                                    playerController.commandStarted();
                                    break;
                                }
                                case CANCEL: {
                                    playerController.commandCancelled();
                                    break;
                                }
                                case TOGGLE_AUTO: {
                                    playerController.commandStartedPermanently();
                                    break;
                                }
                                case BROWSE_RECIPE: {
                                    playerController.commandBrowse();
                                    break;
                                }
                                case HEAD_S: {
                                    if (!(player.field_71070_bA instanceof ContainerDT)) break;
                                    ((ContainerDT)player.field_71070_bA).commandHeadS((PlayerEntity)player);
                                    break;
                                }
                                case HEAD_D: {
                                    if (!(player.field_71070_bA instanceof ContainerDT)) break;
                                    ((ContainerDT)player.field_71070_bA).commandHeadD((PlayerEntity)player);
                                }
                            }
                        } else {
                            ModDT.LOGGER.warn("Illegal access to tile entity by {} at {}", (Object)player, (Object)message.pos);
                        }
                    } else {
                        ModDT.LOGGER.warn("Tile entity at {} isn't a player controllable", (Object)message.pos);
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static enum Action {
        START,
        CANCEL,
        TOGGLE_AUTO,
        BROWSE_RECIPE,
        HEAD_S,
        HEAD_D;

    }
}

