/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.recipe;

import com.google.common.collect.Sets;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.SmithingRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import org.cursegame.minecraft.dt.ModDT;
import org.cursegame.minecraft.dt.configuration.Configuration;
import org.cursegame.minecraft.dt.recipe.ReversedRecipe;
import org.cursegame.minecraft.dt.registry.ModItems;

public class RecipeProvider {
    private static void loadRegisteredRecipes(Collection<IRecipe<?>> candidates, final BiConsumer<IRecipe<?>, ReversedRecipe> consumer) {
        for (final IRecipe<?> candidate : candidates) {
            ItemStack recipeItem;
            if (candidate instanceof ShapedRecipe && candidate.func_192399_d()) {
                ModDT.LOGGER.debug("   skip dynamic recipe {}", (Object)candidate.func_199560_c());
                continue;
            }
            NonNullList ingredients = candidate.func_192400_c();
            if (candidate instanceof SmithingRecipe) {
                RecipeProvider.populateIngredients((List<Ingredient>)ingredients, (SmithingRecipe)candidate);
            }
            if ((recipeItem = candidate.func_77571_b()).func_190926_b() || ingredients.isEmpty()) continue;
            LinkedHashMap groups = new LinkedHashMap();
            ingredients.stream().filter(i -> i != Ingredient.field_193370_a).forEach(i -> groups.compute(new Group(i.func_193365_a()), (items, count) -> count == null ? 1 : count + 1));
            new Variator(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void accept(LinkedList<Map.Entry<Group, Integer>> entries, LinkedList<ItemStack> variant) {
                    if (entries.isEmpty()) {
                        if (!variant.isEmpty()) {
                            ReversedRecipe r = new ReversedRecipe(recipeItem, variant);
                            if (!candidate.func_192399_d()) {
                                r.setSourceId(candidate.func_199560_c());
                            }
                            if (candidate instanceof AbstractCookingRecipe) {
                                if (variant.stream().anyMatch(s -> s.func_77973_b().func_77645_m())) {
                                    return;
                                }
                                AbstractCookingRecipe cookingRecipe = (AbstractCookingRecipe)candidate;
                                r.setExperience(cookingRecipe.func_222138_b());
                            }
                            consumer.accept(candidate, r);
                        }
                    } else {
                        Map.Entry<Group, Integer> tail = entries.pollFirst();
                        try {
                            for (ItemStack item : tail.getKey().items) {
                                ItemStack itemStack = new ItemStack((IItemProvider)item.func_77973_b(), tail.getValue().intValue());
                                variant.addLast(itemStack);
                                try {
                                    this.accept(entries, variant);
                                }
                                finally {
                                    variant.removeLast();
                                }
                            }
                        }
                        finally {
                            entries.addFirst(tail);
                        }
                    }
                }
            }.accept(new LinkedList<Map.Entry<Group, Integer>>(groups.entrySet()), new LinkedList<ItemStack>());
        }
    }

    public static void loadRegisteredRecipes(Collection<IRecipe<?>> candidates, List<ReversedRecipe> target, IRecipeType<?> ... excludes) {
        LinkedHashMap recipeTypeIndex = new LinkedHashMap();
        BiConsumer<IRecipeType, ReversedRecipe.Id> recipeTypeIndexCollector = (t, r) -> recipeTypeIndex.computeIfAbsent(t, k -> new HashSet()).add(r);
        ArrayList result = new ArrayList();
        RecipeProvider.loadRegisteredRecipes(candidates, (i, r) -> {
            recipeTypeIndexCollector.accept(i.func_222127_g(), r.getId());
            result.add(r);
        });
        result.forEach(r -> {
            for (IRecipeType exclude : excludes) {
                if (!recipeTypeIndex.getOrDefault(exclude, Collections.emptySet()).contains(r.getId())) continue;
                return;
            }
            target.add((ReversedRecipe)r);
        });
    }

    public static void deleteDuplicates(List<ReversedRecipe> registeredRecipes) {
        LinkedHashMap<Item, Map> index = new LinkedHashMap<Item, Map>();
        registeredRecipes.forEach(r -> index.computeIfAbsent(r.getId().getIn(), i -> new LinkedHashMap()).computeIfAbsent(r.getId(), id -> new ArrayList()).add(r));
        registeredRecipes.clear();
        index.forEach((i, m) -> m.forEach((id, vs) -> vs.stream().sorted(Comparator.comparing(ReversedRecipe::ration)).findFirst().ifPresent(registeredRecipes::add)));
    }

    public static void disable0level(List<ReversedRecipe> target) {
        LinkedHashMap<Item, Map> index = new LinkedHashMap<Item, Map>();
        target.forEach(r -> index.computeIfAbsent(r.getId().getIn(), i -> new LinkedHashMap()).put(r.getId(), r));
        index.forEach((i, m) -> m.forEach((id, r) -> {
            if (!r.isRecipeDisabled() && id.getOut().contains(i)) {
                ModDT.LOGGER.debug("L0: disabled {}->{} due to input exists in the output", (Object)id.getIn(), id.getOut());
                r.setRecipeDisabled(true);
                return;
            }
            if (!r.isRecipeDisabled()) {
                for (Item o : id.getOut()) {
                    ReversedRecipe.Id fd = new ReversedRecipe.Id(o, Collections.singleton(i));
                    if (!index.getOrDefault(o, Collections.emptyMap()).containsKey(fd)) continue;
                    ModDT.LOGGER.debug("L0: disabled {}->{} due to forward recipe found {}->{}", (Object)id.getIn(), id.getOut(), (Object)fd.getIn(), fd.getOut());
                    r.setRecipeDisabled(true);
                    return;
                }
            }
        }));
    }

    public static void disable1level(List<ReversedRecipe> target) {
        LinkedHashMap<Item, Map> index = new LinkedHashMap<Item, Map>();
        target.forEach(r -> index.computeIfAbsent(r.getId().getIn(), i -> new LinkedHashMap()).put(r.getId(), r));
        index.forEach((i, m) -> m.forEach((id, r) -> {
            if (!r.isRecipeDisabled()) {
                for (int oIndex = 0; oIndex < id.getOut().size(); ++oIndex) {
                    Item oItem = id.getOut(oIndex);
                    for (ReversedRecipe pr : index.getOrDefault(oItem, Collections.emptyMap()).values()) {
                        if (pr.getSourceId().func_110624_b() != r.getSourceId().func_110624_b()) continue;
                        ReversedRecipe.Id pd = pr.getId();
                        for (ReversedRecipe sr : m.values()) {
                            Item sItem;
                            ReversedRecipe.Id sd;
                            if (sr.getSourceId().func_110624_b() != r.getSourceId().func_110624_b() || (sd = sr.getId()) == id || (sItem = sd.getOut(oIndex)) == null || !pd.getOut().contains(sItem)) continue;
                            ModDT.LOGGER.debug("L1: disabled {}->{} due to {}->{} where {} in siblings with index {}", (Object)id.getIn(), id.getOut(), (Object)pd.getIn(), pd.getOut(), (Object)sItem, (Object)oIndex);
                            r.setRecipeDisabled(true);
                            return;
                        }
                    }
                }
            }
        }));
    }

    public static void disableDefiant(List<ReversedRecipe> target) {
        HashSet disableOutput = Sets.newHashSet((Object[])new Item[]{Items.field_196136_br, Items.field_222065_kN, Items.field_226638_pX_, Items.field_221794_dg, Items.field_151127_ba, Items.field_221687_cF, Items.field_222068_kQ, Items.field_221601_aC, Items.field_196128_bn, Items.field_221619_aU, Items.field_221620_aV, Items.field_221621_aW, Items.field_221622_aX, Items.field_221623_aY, Items.field_221678_ba, Items.field_221682_bc, Items.field_221624_aZ, Items.field_221680_bb, Items.field_221684_bd, Items.field_221686_be, Items.field_221688_bf, Items.field_221690_bg, Items.field_221908_fl, Items.field_221910_fm, Items.field_221912_fn, Items.field_221914_fo});
        Set dyes = Stream.of(DyeColor.values()).map(DyeItem::func_195961_a).collect(Collectors.toSet());
        target.forEach(r -> {
            if (r.getOut().size() == 1 && disableOutput.contains(r.getId().getOut(0))) {
                ModDT.LOGGER.debug("LD: disabled {}->{} due to in the defiant list", (Object)r.getId().getIn(), r.getId().getOut());
                r.setRecipeDisabled(true);
            }
            if (dyes.contains(r.getId().getIn()) && !dyes.containsAll(r.getId().getOut())) {
                ModDT.LOGGER.debug("LD: disabled {}->{} due to dye produce non dye item", (Object)r.getId().getIn(), r.getId().getOut());
                r.setRecipeDisabled(true);
            }
            if (Tags.Items.SEEDS.func_230235_a_((Object)r.getId().getIn())) {
                ModDT.LOGGER.debug("LD: disabled {}->{} due to seed", (Object)r.getId().getIn(), r.getId().getOut());
                r.setRecipeDisabled(true);
            }
        });
    }

    public static void addSystemSet(List<ReversedRecipe> target) {
        target.add(new ReversedRecipe(new ItemStack((IItemProvider)ModItems.DUST_0, 9), new ItemStack((IItemProvider)Items.field_221586_n)));
        target.add(new ReversedRecipe(new ItemStack((IItemProvider)ModItems.DUST_1, 9), new ItemStack((IItemProvider)Items.field_221585_m)));
        target.add(new ReversedRecipe(new ItemStack((IItemProvider)ModItems.DUST_2, 9), new ItemStack((IItemProvider)Items.field_151042_j)));
        target.add(new ReversedRecipe(new ItemStack((IItemProvider)ModItems.DUST_3, 9), new ItemStack((IItemProvider)Items.field_151045_i)));
        target.add(new ReversedRecipe(new ItemStack((IItemProvider)ModItems.DUST_4, 9), new ItemStack((IItemProvider)Items.field_151043_k)));
        target.add(new ReversedRecipe(new ItemStack((IItemProvider)ModItems.DUST_5, 9), new ItemStack((IItemProvider)Items.field_234759_km_)));
        target.add(new ReversedRecipe(new ItemStack((IItemProvider)Items.field_221713_cS), new ItemStack((IItemProvider)Items.field_221585_m), EntityType.field_200740_af));
        target.add(new ReversedRecipe(new ItemStack((IItemProvider)Items.field_221721_cW), new ItemStack((IItemProvider)Items.field_221782_da), EntityType.field_200740_af));
        target.add(new ReversedRecipe(new ItemStack((IItemProvider)Items.field_221719_cV), new ItemStack((IItemProvider)Items.field_221727_cZ), EntityType.field_200740_af));
        target.add(new ReversedRecipe(new ItemStack((IItemProvider)Items.field_221717_cU), new ItemStack((IItemProvider)Items.field_221725_cY), EntityType.field_200740_af));
        target.add(new ReversedRecipe(new ItemStack((IItemProvider)Items.field_221711_cR), new ItemStack((IItemProvider)Items.field_221574_b), EntityType.field_200740_af));
        target.add(new ReversedRecipe(new ItemStack((IItemProvider)Items.field_221715_cT), new ItemStack((IItemProvider)Items.field_221723_cX), EntityType.field_200740_af));
    }

    public static void addCustomSet(List<ReversedRecipe> target) {
        target.add(new ReversedRecipe(new ItemStack((IItemProvider)Items.field_222115_pz), new ItemStack((IItemProvider)Items.field_151054_z)));
        target.add(new ReversedRecipe(new ItemStack((IItemProvider)Items.field_151068_bn), new ItemStack((IItemProvider)Items.field_151069_bo)));
        target.add(new ReversedRecipe(new ItemStack((IItemProvider)Items.field_185155_bH), new ItemStack((IItemProvider)Items.field_151069_bo)));
        target.add(new ReversedRecipe(new ItemStack((IItemProvider)Items.field_185156_bI), new ItemStack((IItemProvider)Items.field_151069_bo)));
        target.add(new ReversedRecipe(new ItemStack((IItemProvider)Blocks.field_222431_lT), new ItemStack((IItemProvider)Items.field_221574_b, 4), new ItemStack((IItemProvider)Items.field_221696_bj), new ItemStack((IItemProvider)Items.field_151055_y, 3)));
        target.add(new ReversedRecipe(new ItemStack((IItemProvider)Blocks.field_196717_eY), new ItemStack((IItemProvider)Items.field_221698_bk, 2), new ItemStack((IItemProvider)Items.field_151042_j, 4)));
        target.add(new ReversedRecipe(new ItemStack((IItemProvider)Blocks.field_196718_eZ), new ItemStack((IItemProvider)Items.field_221698_bk, 1), new ItemStack((IItemProvider)Items.field_151042_j, 4)));
        target.add(new ReversedRecipe(new ItemStack((IItemProvider)Items.field_151029_X), new ItemStack((IItemProvider)Items.field_234729_dO_, 4)));
        target.add(new ReversedRecipe(new ItemStack((IItemProvider)Items.field_151022_W), new ItemStack((IItemProvider)Items.field_234729_dO_, 7)));
        target.add(new ReversedRecipe(new ItemStack((IItemProvider)Items.field_151020_U), new ItemStack((IItemProvider)Items.field_234729_dO_, 4)));
        target.add(new ReversedRecipe(new ItemStack((IItemProvider)Items.field_151023_V), new ItemStack((IItemProvider)Items.field_234729_dO_, 8)));
        target.add(new ReversedRecipe(new ItemStack((IItemProvider)Items.field_151138_bX), new ItemStack((IItemProvider)Items.field_151042_j, 7)));
        target.add(new ReversedRecipe(new ItemStack((IItemProvider)Items.field_151136_bY), new ItemStack((IItemProvider)Items.field_151043_k, 7)));
        target.add(new ReversedRecipe(new ItemStack((IItemProvider)Items.field_151125_bZ), new ItemStack((IItemProvider)Items.field_151045_i, 7)));
        target.add(new ReversedRecipe(new ItemStack((IItemProvider)Items.field_151141_av), new ItemStack((IItemProvider)Items.field_151116_aA, 5), new ItemStack((IItemProvider)Items.field_151042_j, 3)));
        target.add(new ReversedRecipe(new ItemStack((IItemProvider)Items.field_190929_cY), new ItemStack((IItemProvider)Items.field_151153_ao), new ItemStack((IItemProvider)Items.field_151074_bl, 5), new ItemStack((IItemProvider)Items.field_151166_bC, 2)));
        target.add(new ReversedRecipe(new ItemStack((IItemProvider)Items.field_151164_bB), new ItemStack((IItemProvider)Items.field_151099_bA)));
    }

    public static void addGrinds(Collection<IRecipe<?>> candidates, List<ReversedRecipe> target) {
        target.add(new ReversedRecipe(new ItemStack((IItemProvider)Items.field_151042_j), new ItemStack((IItemProvider)ModItems.DUST_2, 9)));
        target.add(new ReversedRecipe(new ItemStack((IItemProvider)Items.field_151045_i), new ItemStack((IItemProvider)ModItems.DUST_3, 9)));
        target.add(new ReversedRecipe(new ItemStack((IItemProvider)Items.field_151043_k), new ItemStack((IItemProvider)ModItems.DUST_4, 9)));
        target.add(new ReversedRecipe(new ItemStack((IItemProvider)Items.field_234759_km_), new ItemStack((IItemProvider)ModItems.DUST_5, 9)));
        target.add(new ReversedRecipe(new ItemStack((IItemProvider)Items.field_151116_aA), new ItemStack((IItemProvider)ModItems.LEATHER_STRIP, 9)));
        target.add(new ReversedRecipe(new ItemStack((IItemProvider)Items.field_221737_dE, 2), new ItemStack((IItemProvider)ModItems.DUST_2, 9), new ItemStack((IItemProvider)Items.field_151055_y, 2)));
        target.add(new ReversedRecipe(new ItemStack((IItemProvider)Items.field_234729_dO_), new ItemStack((IItemProvider)ModItems.DUST_2, 11)));
        RecipeProvider.forTagItems("forge:stone", item -> target.add(new ReversedRecipe(new ItemStack((IItemProvider)item), new ItemStack((IItemProvider)ModItems.DUST_1, 9))));
        RecipeProvider.forTagItems("forge:cobblestone", item -> target.add(new ReversedRecipe(new ItemStack((IItemProvider)item), new ItemStack((IItemProvider)ModItems.DUST_1, 9))));
        RecipeProvider.forTagItems("minecraft:planks", item -> target.add(new ReversedRecipe(new ItemStack((IItemProvider)item), new ItemStack((IItemProvider)Items.field_151055_y, 2))));
        RecipeProvider.forTagItems("minecraft:logs", item -> target.add(new ReversedRecipe(new ItemStack((IItemProvider)item), new ItemStack((IItemProvider)Items.field_151055_y, 8))));
        target.sort(ReversedRecipe.ORDER_NATURAL);
        ModDT.LOGGER.debug("Grind recipes:");
        for (ReversedRecipe t : target) {
            ModDT.LOGGER.debug("  {}", (Object)t);
        }
    }

    public static void forTagItems(String tag, Consumer<Item> c) {
        ResourceLocation resourcelocation = new ResourceLocation(tag);
        ITag<Item> iTag = RecipeProvider.getTag(resourcelocation);
        if (iTag == null) {
            ModDT.LOGGER.warn("No tag registered: {}", (Object)tag);
        } else {
            iTag.func_230236_b_().forEach(c);
        }
    }

    public static ITag<Item> getTag(ResourceLocation resourcelocation) {
        return ItemTags.func_199903_a().func_199910_a(resourcelocation);
    }

    private static void populateIngredients(List<Ingredient> ingredients, SmithingRecipe recipe) {
        PacketBuffer friendlyBB = new PacketBuffer(Unpooled.buffer());
        IRecipeSerializer.field_234826_u_.func_199427_a_(friendlyBB, (IRecipe)recipe);
        Ingredient base = Ingredient.func_199566_b((PacketBuffer)friendlyBB);
        Ingredient addition = Ingredient.func_199566_b((PacketBuffer)friendlyBB);
        ingredients.add(base);
        ingredients.add(addition);
        friendlyBB.clear();
    }

    private static class Group {
        private final ItemStack[] items;

        public Group(ItemStack[] items) {
            int tagLimit = (Integer)Configuration.getInstance().server.tagLimit.get();
            this.items = (ItemStack[])Stream.of(items).limit(tagLimit > 0 ? (long)tagLimit : (long)items.length).toArray(ItemStack[]::new);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            for (ItemStack item : this.items) {
                result = 31 * result + item.func_77973_b().hashCode();
            }
            return result;
        }

        public boolean equals(Object o) {
            Group other = (Group)o;
            if (this.items.length != other.items.length) {
                return false;
            }
            for (int i = 0; i < this.items.length; ++i) {
                if (this.items[i].func_77973_b() == other.items[i].func_77973_b()) continue;
                return false;
            }
            return true;
        }
    }

    static interface Variator {
        public void accept(LinkedList<Map.Entry<Group, Integer>> var1, LinkedList<ItemStack> var2);
    }
}

