/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.recipe;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.block.BannerBlock;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BannerItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.item.crafting.ServerRecipeBook;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import org.apache.commons.lang3.time.StopWatch;
import org.cursegame.minecraft.dt.ModDT;
import org.cursegame.minecraft.dt.capability.Slots;
import org.cursegame.minecraft.dt.configuration.Configuration;
import org.cursegame.minecraft.dt.item.ItemDisk;
import org.cursegame.minecraft.dt.item.ItemVial;
import org.cursegame.minecraft.dt.recipe.RecipeProvider;
import org.cursegame.minecraft.dt.recipe.ReversedRecipe;
import org.cursegame.minecraft.dt.recipe.ReversedRecipeHolder;
import org.cursegame.minecraft.dt.recipe.ReversedRecipeOverride;
import org.cursegame.minecraft.dt.recipe.ReversedRecipeOverrides;
import org.cursegame.minecraft.dt.registry.ModItems;
import org.cursegame.minecraft.dt.registry.ModTags;

public class RecipeService {
    public static final int ORB_XP = 7;
    private static RecipeService instance;
    private RecipeManager recipeManager;
    private List<ReversedRecipe> grinds = NonNullList.func_191196_a();
    private Map<Item, Set<ReversedRecipe>> recipeIndex = new LinkedHashMap<Item, Set<ReversedRecipe>>();
    private List<ReversedRecipe> recipes = NonNullList.func_191196_a();

    public static RecipeService getInstance() {
        if (instance == null) {
            instance = new RecipeService();
        }
        return instance;
    }

    private RecipeService() {
    }

    public RecipeManager getRecipeManager() {
        if (this.recipeManager == null) {
            throw new IllegalStateException("Recipe manager isn't initialized yet");
        }
        return this.recipeManager;
    }

    public void initialize(RecipeManager recipeManager) {
        this.recipeManager = recipeManager;
        this.loadRecipes();
        this.loadGrinds();
    }

    private void loadGrinds() {
        RecipeProvider.addGrinds(this.getRecipeManager().func_199510_b(), this.grinds);
    }

    public List<ReversedRecipe> getRegisteredRecipes() {
        return this.recipes;
    }

    private void loadRecipes() {
        StopWatch sw = StopWatch.createStarted();
        RecipeProvider.addSystemSet(this.recipes);
        RecipeProvider.addCustomSet(this.recipes);
        RecipeProvider.loadRegisteredRecipes(this.getRecipeManager().func_199510_b(), this.recipes, IRecipeType.field_222151_c);
        RecipeProvider.deleteDuplicates(this.recipes);
        sw.split();
        ModDT.LOGGER.debug("recipe collecting {}ms", (Object)sw.getSplitTime());
        RecipeProvider.disableDefiant(this.recipes);
        sw.split();
        ModDT.LOGGER.debug("recipe filtering defiant {}ms", (Object)sw.getSplitTime());
        RecipeProvider.disable0level(this.recipes);
        sw.split();
        ModDT.LOGGER.debug("recipe filtering level 0 {}ms", (Object)sw.getSplitTime());
        RecipeProvider.disable1level(this.recipes);
        sw.split();
        ModDT.LOGGER.debug("recipe filtering level 1 {}ms", (Object)sw.getSplitTime());
        ReversedRecipeOverrides recipeOverrides = Configuration.getInstance().loadOverrides();
        HashSet toHide = new HashSet();
        HashSet toShow = new HashSet();
        HashMap toSwap = new HashMap();
        recipeOverrides.getOverrides().forEach(o -> {
            switch (o.getAction()) {
                case HIDE: {
                    toHide.add(o.getRecipe().getId());
                    break;
                }
                case SHOW: {
                    toShow.add(o.getRecipe().getId());
                    break;
                }
                case SWAP: {
                    toSwap.put(o.getRecipe().getId(), o.getUpdate());
                    break;
                }
            }
        });
        if (Stream.of(new ReversedRecipe(new ItemStack((IItemProvider)Items.field_151064_bs), new ItemStack((IItemProvider)Items.field_151065_br), new ItemStack((IItemProvider)Items.field_151123_aH))).mapToInt(r -> {
            ReversedRecipe s = (ReversedRecipe)toSwap.get(r.getId());
            if (s == null) {
                toSwap.put(r.getId(), r);
                recipeOverrides.getOverrides().add(new ReversedRecipeOverride(ReversedRecipeOverride.Action.SWAP, (ReversedRecipe)r, r.copy().setExperience(35.0f)));
                return 1;
            }
            return 0;
        }).sum() > 0) {
            Configuration.getInstance().saveOverrides();
        }
        for (ReversedRecipe r2 : this.recipes) {
            ReversedRecipe s;
            if (toHide.contains(r2.getId()) && !r2.isRecipeDisabled()) {
                ModDT.LOGGER.info("Hide recipe {}->{} due to config override", (Object)r2.getId().getIn(), r2.getId().getOut());
                r2.setRecipeDisabled(true);
            }
            if (toShow.contains(r2.getId()) && r2.isRecipeDisabled()) {
                ModDT.LOGGER.info("Show recipe {}->{} due to config override", (Object)r2.getId().getIn(), r2.getId().getOut());
                r2.setRecipeDisabled(false);
            }
            if ((s = (ReversedRecipe)toSwap.get(r2.getId())) == null) continue;
            r2.setExperience(s.getExperience());
        }
        ModDT.LOGGER.info("Loaded {} deconstruction schemas, {}ms", (Object)this.recipes.size(), (Object)sw.getTime());
        this.recipes.forEach(r -> this.recipeIndex.computeIfAbsent(r.getId().getIn(), i -> new LinkedHashSet()).add(r));
    }

    private ReversedRecipe getGrindRecipe(Item item) {
        return this.grinds.stream().filter(r -> r.getIn().func_77973_b() == item).findFirst().orElse(null);
    }

    public static NonNullList<ReversedRecipe> getRecipesForSearch(Map<Item, ReversedRecipeHolder> recipes, String searchText) {
        return recipes.values().stream().flatMap(rh -> rh.getItems().stream()).filter(recipe -> searchText.isEmpty() || recipe.getIn().func_151000_E().getString().toLowerCase().contains(searchText)).sorted(ReversedRecipe.ORDER_NATURAL).collect(Collectors.toCollection(NonNullList::func_191196_a));
    }

    public Result estimate(Input input, World world) {
        Map enchantments;
        CompoundNBT data;
        Result result = new Result();
        ReversedRecipe currentRecipe = null;
        ReversedRecipeHolder recipeHolder = (ReversedRecipeHolder)input.recipes.get(input.itemStack.func_77973_b());
        if (recipeHolder != null) {
            currentRecipe = recipeHolder.getCurrentRecipe();
        }
        if (currentRecipe == null && input.itemStack.func_77973_b() == Items.field_185167_i) {
            currentRecipe = new ReversedRecipe(new ItemStack((IItemProvider)Items.field_185167_i, 8), new ItemStack((IItemProvider)Items.field_151032_g, 8));
        }
        if (currentRecipe == null && input.itemStack.func_77973_b() == Items.field_151098_aY) {
            MapData mapData = FilledMapItem.func_219994_a((ItemStack)input.itemStack, (World)world);
            currentRecipe = mapData != null ? new ReversedRecipe(new ItemStack((IItemProvider)Items.field_151098_aY), new ItemStack((IItemProvider)Items.field_151148_bJ), new ItemStack((IItemProvider)Items.field_151121_aF, (int)mapData.field_76197_d)) : new ReversedRecipe(new ItemStack((IItemProvider)Items.field_151098_aY), new ItemStack((IItemProvider)Items.field_151148_bJ));
        }
        if (currentRecipe == null && input.itemStack.func_77973_b() == Items.field_196152_dE) {
            ArrayList<ItemStack> stacksOut = new ArrayList<ItemStack>();
            stacksOut.add(new ItemStack((IItemProvider)Items.field_151016_H));
            stacksOut.add(new ItemStack((IItemProvider)Items.field_151121_aF));
            CompoundNBT tagFireworks = input.itemStack.func_179543_a("Fireworks");
            if (tagFireworks != null) {
                ListNBT tagExplosions = tagFireworks.func_150295_c("Explosions", 10);
                tagExplosions.stream().map(CompoundNBT.class::cast).forEach(c -> {
                    ItemStack starStack = new ItemStack((IItemProvider)Items.field_196153_dF);
                    CompoundNBT starStackTag = new CompoundNBT();
                    starStackTag.func_218657_a("Explosion", (INBT)c);
                    starStack.func_77982_d(starStackTag);
                    stacksOut.add(starStack);
                });
            }
            currentRecipe = new ReversedRecipe(new ItemStack((IItemProvider)Items.field_196152_dE, 3), stacksOut);
        }
        if (currentRecipe != null) {
            Block bannerBlock;
            CompoundNBT tag;
            CompoundNBT compoundnbt;
            IDyeableArmorItem dyeableArmorItem;
            if (input.itemStack.func_77973_b() instanceof IDyeableArmorItem && (dyeableArmorItem = (IDyeableArmorItem)input.itemStack.func_77973_b()).func_200883_f_(input.itemStack)) {
                int color = dyeableArmorItem.func_200886_f(input.itemStack);
                for (ListNBT dyeColor : DyeColor.values()) {
                    if (color != dyeColor.getColorValue()) continue;
                    result.items.add(new ItemStack((IItemProvider)DyeItem.func_195961_a((DyeColor)dyeColor)));
                    break;
                }
            }
            if (input.itemStack.func_77973_b() instanceof BannerItem && (compoundnbt = input.itemStack.func_179543_a("BlockEntityTag")) != null && compoundnbt.func_74764_b("Patterns")) {
                ListNBT patterns = compoundnbt.func_150295_c("Patterns", 10);
                for (int i = 0; i < patterns.size() && i < 6; ++i) {
                    DyeItem dyeItem = DyeItem.func_195961_a((DyeColor)DyeColor.func_196056_a((int)patterns.func_150305_b(i).func_74762_e("Color")));
                    if (dyeItem == null) continue;
                    result.items.add(new ItemStack((IItemProvider)dyeItem));
                }
            }
            if (input.itemStack.func_77973_b() instanceof ShieldItem && (tag = input.itemStack.func_179543_a("BlockEntityTag")) != null && (bannerBlock = BannerBlock.func_196287_a((DyeColor)DyeColor.func_196056_a((int)tag.func_74762_e("Base")))) != null) {
                ItemStack bannerItem = new ItemStack((IItemProvider)bannerBlock);
                if (tag.func_74764_b("Patterns")) {
                    bannerItem.func_190925_c("BlockEntityTag").func_218657_a("Patterns", (INBT)tag.func_150295_c("Patterns", 10).func_74737_b());
                }
                result.items.add(bannerItem);
            }
        }
        if (currentRecipe == null && input.itemStack.func_77973_b() == Items.field_151062_by) {
            currentRecipe = new ReversedRecipe(new ItemStack((IItemProvider)Items.field_151062_by), new ItemStack((IItemProvider)Items.field_151069_bo));
            result.xp = 700;
        }
        if (input.itemStack.func_77973_b().func_206844_a(ModTags.Items.vials)) {
            float charge = ItemVial.getItemCharge(input.itemStack);
            if (charge > 0.0f || currentRecipe == null) {
                currentRecipe = new ReversedRecipe(new ItemStack((IItemProvider)input.itemStack.func_77973_b()), new ItemStack((IItemProvider)input.itemStack.func_77973_b()));
            }
            result.xp = (int)(100.0f * ItemVial.getItemCharge(input.itemStack));
        }
        if (currentRecipe != null) {
            result.recipeAvailable = true;
            result.recipeAmbiguous = recipeHolder != null && recipeHolder.getItems().size() > 1;
            result.recipeDisabled = currentRecipe.isRecipeDisabled();
            result.entityType = currentRecipe.getEntityType();
        }
        if (currentRecipe != null && (data = input.itemStack.func_77978_p()) != null) {
            boolean listDetected = false;
            block4: for (String key : data.func_150296_c()) {
                INBT value = data.func_74781_a(key);
                if (!(value instanceof ListNBT)) continue;
                ListNBT listNBT = (ListNBT)value;
                for (INBT listItem : listNBT) {
                    listDetected = true;
                    if (!(listItem instanceof CompoundNBT)) continue;
                    CompoundNBT compoundNBT = (CompoundNBT)listItem;
                    try {
                        ItemStack itemStack2 = ItemStack.func_199557_a((CompoundNBT)compoundNBT);
                        if (itemStack2.func_190926_b()) continue;
                        result.content.add(itemStack2);
                    }
                    catch (Throwable t) {
                        continue block4;
                    }
                }
            }
            if (listDetected && !result.content.isEmpty()) {
                ModDT.LOGGER.debug("Nested items found (to be thrown out): {}", (Object)result.content);
            }
        }
        ModDT.LOGGER.debug("Analysed item {} tag {}", (Object)input.itemStack, (Object)input.itemStack.func_77978_p());
        if (currentRecipe != null) {
            ModDT.LOGGER.debug("    recipe {} {}", (Object)currentRecipe.getSourceId(), (Object)currentRecipe);
        }
        if (currentRecipe != null) {
            boolean isDamagedStack;
            boolean bl = isDamagedStack = input.itemStack.func_77958_k() > 0 && input.itemStack.func_77952_i() > 0;
            if (isDamagedStack) {
                if (input.itemStack.func_190916_E() != 1) {
                    throw new IllegalStateException();
                }
                this.processPartial(result, currentRecipe, 1.0f - 1.0f * (float)input.itemStack.func_77952_i() / (float)input.itemStack.func_77958_k());
                result.itemConsumed++;
            } else {
                if (input.itemStack.func_190916_E() < currentRecipe.getIn().func_190916_E()) {
                    this.processPartial(result, currentRecipe, 1.0f * (float)input.itemStack.func_190916_E() / (float)currentRecipe.getIn().func_190916_E());
                } else {
                    result.items.addAll(currentRecipe.getOut());
                }
                Result listDetected = result;
                listDetected.itemConsumed = listDetected.itemConsumed + currentRecipe.getIn().func_190916_E();
            }
            float experience = currentRecipe.getExperience();
            if (experience > 0.0f) {
                result.bondConsumed = (int)(100.0f * experience);
                if (input.itemStack.func_77973_b() == ModItems.ESSENCE) {
                    result.bondConsumed = 700 - result.bondConsumed;
                }
            }
        }
        if (!(enchantments = EnchantmentHelper.func_82781_a((ItemStack)input.itemStack)).isEmpty()) {
            int bookCount = input.bookStack.func_190916_E();
            if (input.itemStack.func_77973_b() == Items.field_151134_bR) {
                if (enchantments.size() < 2 || bookCount == 0) {
                    ItemStack bookItem = new ItemStack((IItemProvider)Items.field_151122_aG);
                    result.items.add(bookItem);
                    Result key = result;
                    key.xp = key.xp + RecipeService.getEnchantmentXp(enchantments);
                } else {
                    result.bookConsumed--;
                    ++bookCount;
                    LinkedList q = new LinkedList(enchantments.entrySet());
                    block6: while (q.size() > 0) {
                        ItemStack currentBook = null;
                        while (q.size() > 0) {
                            Map.Entry entry = (Map.Entry)q.poll();
                            if (currentBook == null && bookCount > 0) {
                                currentBook = new ItemStack((IItemProvider)Items.field_151134_bR);
                                result.items.add(currentBook);
                                result.bookConsumed++;
                                --bookCount;
                            }
                            if (currentBook != null) {
                                EnchantedBookItem.func_92115_a((ItemStack)currentBook, (EnchantmentData)new EnchantmentData((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue()));
                            }
                            if (bookCount <= 0) continue;
                            continue block6;
                        }
                    }
                }
                result.itemConsumed++;
            } else {
                Result currentBook;
                if (bookCount > 0) {
                    currentBook = new ItemStack((IItemProvider)Items.field_151134_bR);
                    for (Map.Entry entry : enchantments.entrySet()) {
                        EnchantedBookItem.func_92115_a((ItemStack)currentBook, (EnchantmentData)new EnchantmentData((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue()));
                    }
                    result.items.add(currentBook);
                    result.bookConsumed++;
                    --bookCount;
                } else {
                    currentBook = result;
                    currentBook.xp = currentBook.xp + RecipeService.getEnchantmentXp(enchantments);
                }
                if (currentRecipe == null) {
                    ItemStack itemStack3 = input.itemStack.func_77946_l();
                    EnchantmentHelper.func_82782_a(Collections.emptyMap(), (ItemStack)itemStack3);
                    result.items.add(itemStack3);
                    result.itemConsumed++;
                }
            }
        }
        if (result.xp > 0 && !input.bondStack.func_190926_b()) {
            float itemCharge = ItemVial.getItemCharge(input.bondStack);
            float itemMaxCharge = ItemVial.getItemMaxCharge(input.bondStack);
            int capacity = (int)(100.0f * (itemMaxCharge - itemCharge));
            if (result.xp <= capacity) {
                capacity = result.xp;
            }
            Result entry = result;
            entry.xp = entry.xp - capacity;
            entry = result;
            entry.bondConsumed = entry.bondConsumed - capacity;
        }
        if (result.xp > 0 && input.vialStack.func_77973_b() == Items.field_151069_bo && input.itemStack.func_77973_b() != Items.field_151062_by) {
            int orbXp = 700;
            ItemStack bulbItem = new ItemStack((IItemProvider)Items.field_151062_by, 0);
            for (int bulbCount = input.vialStack.func_190916_E(); bulbCount > 0 && result.xp >= 700; --bulbCount) {
                bulbItem.func_190917_f(1);
                Result entry = result;
                entry.xp = entry.xp - 700;
            }
            if (!bulbItem.func_190926_b()) {
                result.items.add(bulbItem);
                Result entry = result;
                entry.vialConsumed = entry.vialConsumed + bulbItem.func_190916_E();
            }
        }
        if (result.xp > 0 && (result.vialConsumed != 0 || result.bondConsumed != 0)) {
            result.items.forEach(itemStack -> {
                float itemMaxCharge;
                if (itemStack.func_190916_E() == 1 && (itemMaxCharge = ItemVial.getItemMaxCharge(itemStack)) > 0.0f) {
                    int capacity = (int)(100.0f * (itemMaxCharge - ItemVial.getItemCharge(itemStack)));
                    if (result.xp <= capacity) {
                        capacity = result.xp;
                    }
                    result.xp = result.xp - capacity;
                    ItemVial.charge(itemStack, null, (float)(-capacity) / 100.0f);
                }
            });
        }
        if (currentRecipe != null) {
            CompoundNBT tag;
            ArrayList<EffectInstance> itemStackEffects = PotionUtils.func_185189_a((ItemStack)input.itemStack);
            if (itemStackEffects.isEmpty() && (tag = input.itemStack.func_77978_p()) != null) {
                ListNBT listNbt = tag.func_150295_c("Effects", 10);
                for (int i = 0; i < listNbt.size(); ++i) {
                    CompoundNBT effectNbt = listNbt.func_150305_b(i);
                    Effect effect = Effect.func_188412_a((int)effectNbt.func_74771_c("EffectId"));
                    if (effect == null) continue;
                    itemStackEffects.add(new EffectInstance(effect, effectNbt.func_74762_e("EffectDuration")));
                }
            }
            if (itemStackEffects.size() > 0 && input.itemStack.func_190916_E() >= currentRecipe.getIn().func_190916_E() && Slots.VIAL_POTION.test(input.vialStack)) {
                LinkedHashSet<Effect> effects = new LinkedHashSet<Effect>();
                HashMap<Effect, Object> stackEffects = new HashMap<Effect, Object>();
                for (Object effect : PotionUtils.func_185189_a((ItemStack)input.vialStack)) {
                    effects.add(effect.func_188419_a());
                    stackEffects.put(effect.func_188419_a(), effect);
                }
                HashMap<Effect, EffectInstance> arrowEffects = new HashMap<Effect, EffectInstance>();
                for (EffectInstance effectInstance : itemStackEffects) {
                    effects.add(effectInstance.func_188419_a());
                    arrowEffects.put(effectInstance.func_188419_a(), effectInstance);
                }
                ItemStack itemStack4 = new ItemStack((IItemProvider)input.vialStack.func_77973_b());
                itemStackEffects = new ArrayList<EffectInstance>();
                for (Effect effect : effects) {
                    int a;
                    int d;
                    EffectInstance l = (EffectInstance)stackEffects.get(effect);
                    EffectInstance r = (EffectInstance)arrowEffects.get(effect);
                    if (l == null) {
                        d = PotionUtils.func_185191_c((ItemStack)input.vialStack) == Potions.field_185233_e ? r.func_76459_b() : r.func_76459_b() / 2;
                        a = r.func_76458_c();
                    } else if (r == null) {
                        d = l.func_76459_b() / 2;
                        a = l.func_76458_c();
                    } else {
                        float s = Math.max(l.func_76459_b(), r.func_76459_b());
                        float v = Math.min(l.func_76459_b(), r.func_76459_b());
                        s += v * v / (s + v);
                        d = (int)s;
                        a = Math.min(l.func_76458_c(), r.func_76458_c());
                    }
                    itemStackEffects.add(new EffectInstance(effect, d, a));
                }
                Potion potion = PotionUtils.func_185191_c((ItemStack)input.itemStack);
                if (potion != Potions.field_185229_a && itemStackEffects.containsAll(potion.func_185170_a())) {
                    PotionUtils.func_185188_a((ItemStack)itemStack4, (Potion)potion);
                    itemStackEffects.removeAll(potion.func_185170_a());
                }
                PotionUtils.func_185184_a((ItemStack)itemStack4, itemStackEffects);
                result.items.add(itemStack4);
                result.vialConsumed++;
            }
        }
        if (input.diskStack.func_77973_b() != ItemDisk.DUMMY) {
            result.diskConsumed++;
        }
        return result;
    }

    private void processPartial(Result result, ReversedRecipe recipe, float damage) {
        HashMap output = new HashMap();
        recipe.getOut().forEach(s -> {
            if (s.func_77984_f()) {
                ItemStack itemStack = new ItemStack((IItemProvider)s.func_77973_b());
                itemStack.func_196085_b(itemStack.func_77958_k() - (int)((float)itemStack.func_77958_k() * damage));
                output.put(s.func_77973_b(), itemStack);
            } else {
                this.evaluate(output, IntStream.range(0, s.func_190916_E()).boxed().map(i -> s.func_77973_b()).collect(Collectors.toList()), damage);
            }
        });
        result.items.addAll(output.values());
    }

    private float evaluate(Map<Item, ItemStack> output, List<Item> line, float part) {
        for (int i = 0; i < line.size(); ++i) {
            float f = part * (float)line.size();
            if (i < (int)f) {
                output.computeIfAbsent(line.get(i), item -> new ItemStack((IItemProvider)item, 0)).func_190917_f(1);
                continue;
            }
            ReversedRecipe recipe = this.getGrindRecipe(line.get(i));
            if (recipe == null) continue;
            this.evaluate(output, recipe.toFlatOut(), (f - (float)((int)f)) / (float)recipe.getIn().func_190916_E());
            break;
        }
        return part;
    }

    private List<ReversedRecipe> loadUserDefinedRecipes(ServerPlayerEntity player) {
        CompoundNBT preferredRecipes = player.getPersistentData().func_74775_l("dt:preferred_recipes");
        ModDT.LOGGER.debug("loadUserDefinedRecipes {}", (Object)preferredRecipes);
        return preferredRecipes.func_150296_c().stream().map(arg_0 -> ((CompoundNBT)preferredRecipes).func_74775_l(arg_0)).map(ReversedRecipe::asNBT).collect(Collectors.toList());
    }

    public void saveUserDefinedRecipe(ServerPlayerEntity player, ReversedRecipe recipe) {
        CompoundNBT preferredRecipes = player.getPersistentData().func_74775_l("dt:preferred_recipes");
        preferredRecipes.func_218657_a(recipe.getIn().func_77973_b().getRegistryName().toString(), (INBT)ReversedRecipe.toNBT(recipe));
        ModDT.LOGGER.debug("saveUserDefinedRecipe {}", (Object)preferredRecipes);
        player.getPersistentData().func_218657_a("dt:preferred_recipes", (INBT)preferredRecipes);
    }

    public void updateRecipeFromPlayerRecipeBook(ServerPlayerEntity player, Map<Item, ReversedRecipeHolder> recipes) {
        ModDT.LOGGER.debug("Collecting recipes for {} ...", (Object)player.func_200200_C_().getString());
        StopWatch stopWatch = StopWatch.createStarted();
        this.updateRecipeFromRecipeBook(player, recipes);
        stopWatch.stop();
        ModDT.LOGGER.debug("Collecting done in {}ms", (Object)stopWatch.getTime());
    }

    public void updateRecipeFromRecipeBook(ServerPlayerEntity player, Map<Item, ReversedRecipeHolder> recipes) {
        recipes.clear();
        boolean moderator = player.func_184812_l_();
        ServerRecipeBook recipeBook = player.func_192037_E();
        Predicate<ReversedRecipe> userRecipePredicate = r -> !r.isRecipeDisabled() && (r.isCustomSource() || recipeBook.func_226144_b_(r.getSourceId()));
        this.recipeIndex.forEach((i, s) -> {
            ReversedRecipeHolder h = new ReversedRecipeHolder((NonNullList<ReversedRecipe>)NonNullList.func_191196_a(), -1);
            for (ReversedRecipe r : s) {
                if (!moderator && !userRecipePredicate.test(r)) continue;
                h.addItem(r);
            }
            if (h.getItems().size() > 0) {
                recipes.put((Item)i, h);
            }
        });
        this.loadUserDefinedRecipes(player).forEach(recipe -> recipes.computeIfPresent(recipe.getIn().func_77973_b(), (k, h) -> {
            int index = h.getItems().indexOf(recipe);
            if (index != -1) {
                h.setIndex(index);
            }
            return h;
        }));
    }

    public void browseRecipe(ServerPlayerEntity player, ReversedRecipeHolder recipeHolder) {
        recipeHolder.addIndex();
        this.saveUserDefinedRecipe(player, recipeHolder.getCurrentRecipe());
    }

    public void toggleRecipeVisibility(ReversedRecipe recipe) {
        recipe.setRecipeDisabled(!recipe.isRecipeDisabled());
        ReversedRecipeOverrides recipeOverrides = Configuration.getInstance().loadOverrides();
        recipeOverrides.getOverrides().removeIf(o -> (o.getAction() == ReversedRecipeOverride.Action.HIDE || o.getAction() == ReversedRecipeOverride.Action.SHOW) && o.getRecipe().getId().equals(recipe.getId()));
        recipeOverrides.getOverrides().add(new ReversedRecipeOverride(recipe.isRecipeDisabled() ? ReversedRecipeOverride.Action.HIDE : ReversedRecipeOverride.Action.SHOW, recipe, null));
        Configuration.getInstance().saveOverrides();
    }

    public static int getEnchantmentXp(Map<Enchantment, Integer> enchantments) {
        float l = 0.0f;
        for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
            Enchantment enchantment = entry.getKey();
            Integer level = entry.getValue();
            l = (float)((double)l + (double)(enchantment.func_77321_a(level.intValue()) + enchantment.func_223551_b(level.intValue())) / 2.0);
        }
        return (int)(100.0f * l);
    }

    public static class Result {
        private final List<ItemStack> items = NonNullList.func_191196_a();
        private final List<ItemStack> content = NonNullList.func_191196_a();
        private int itemConsumed;
        private int diskConsumed;
        private int bookConsumed;
        private int vialConsumed;
        private int bondConsumed;
        private int xp;
        private boolean recipeAvailable;
        private boolean recipeAmbiguous;
        private boolean recipeDisabled;
        private EntityType<?> entityType;

        public List<ItemStack> getItems() {
            return this.items;
        }

        public List<ItemStack> getContent() {
            return this.content;
        }

        public int getItemConsumed() {
            return this.itemConsumed;
        }

        public int getDiskConsumed() {
            return this.diskConsumed;
        }

        public int getBookConsumed() {
            return this.bookConsumed;
        }

        public int getVialConsumed() {
            return this.vialConsumed;
        }

        public int getBondConsumed() {
            return this.bondConsumed;
        }

        public int getXp() {
            return this.xp;
        }

        public boolean isRecipeAvailable() {
            return this.recipeAvailable;
        }

        public boolean isRecipeAmbiguous() {
            return this.recipeAmbiguous;
        }

        public boolean isRecipeDisabled() {
            return this.recipeDisabled;
        }

        public EntityType<?> getEntityType() {
            return this.entityType;
        }
    }

    public static class Input {
        private final Map<Item, ReversedRecipeHolder> recipes;
        private final ItemStack itemStack;
        private final ItemStack diskStack;
        private final ItemStack bookStack;
        private final ItemStack vialStack;
        private final ItemStack bondStack;

        public Input(Map<Item, ReversedRecipeHolder> recipes, ItemStack itemStack, ItemStack diskStack, ItemStack bookStack, ItemStack vialStack, ItemStack bondStack) {
            this.recipes = recipes;
            this.itemStack = itemStack;
            this.diskStack = diskStack;
            this.bookStack = bookStack;
            this.vialStack = vialStack;
            this.bondStack = bondStack;
        }
    }
}

