/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import org.cursegame.minecraft.dt.util.Utils;

public class ReversedRecipe {
    public static final Comparator<ReversedRecipe> ORDER_NATURAL = Comparator.comparing(r -> Item.func_150891_b((Item)r.getIn().func_77973_b())).thenComparing(r -> r.getOut().size());
    private final Id id;
    private final ItemStack in;
    private final Map<Item, ItemStack> out;
    private boolean recipeDisabled;
    private List<ItemStack> outList;
    private static final ResourceLocation CUSTOM_SOURCE = new ResourceLocation("minecraft", "custom");
    private ResourceLocation sourceId = CUSTOM_SOURCE;
    private float experience;
    private EntityType<?> entityType;

    public boolean isRecipeDisabled() {
        return this.recipeDisabled;
    }

    public void setRecipeDisabled(boolean b) {
        this.recipeDisabled = b;
    }

    public ReversedRecipe(ItemStack in, Map<Item, ItemStack> out) {
        this.id = new Id(in.func_77973_b(), out.keySet());
        this.in = in;
        this.out = out;
    }

    public ReversedRecipe(ItemStack stackIn, List<ItemStack> stacksOut) {
        this(stackIn, stacksOut.stream().filter(s -> !s.func_190926_b()).collect(Collectors.toMap(ItemStack::func_77973_b, Function.identity(), Utils::merge, LinkedHashMap::new)));
    }

    public ReversedRecipe(ItemStack stackIn, ItemStack ... stacksOut) {
        this(stackIn, Arrays.asList(stacksOut));
    }

    public ReversedRecipe(ItemStack stackIn, ItemStack stacksOut, EntityType<?> entityType) {
        this(stackIn, Arrays.asList(stacksOut));
        this.entityType = entityType;
    }

    public Id getId() {
        return this.id;
    }

    @Nonnull
    public ItemStack getIn() {
        return this.in;
    }

    public Collection<ItemStack> getOut() {
        return this.out.values();
    }

    @Nullable
    public ItemStack getOut(Item item) {
        return this.out.get(item);
    }

    @Nullable
    public ItemStack getOut(int index) {
        return this.getOutList().get(index);
    }

    public List<ItemStack> getOutList() {
        if (this.outList == null) {
            this.outList = new ArrayList<ItemStack>(this.out.values());
        }
        return this.outList;
    }

    public ReversedRecipe copy() {
        return new ReversedRecipe(this.in, this.out);
    }

    public boolean isCustomSource() {
        return this.sourceId == CUSTOM_SOURCE;
    }

    public ResourceLocation getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(ResourceLocation sourceId) {
        this.sourceId = sourceId;
    }

    public float getExperience() {
        return this.experience;
    }

    public ReversedRecipe setExperience(float experience) {
        this.experience = experience;
        return this;
    }

    public EntityType<?> getEntityType() {
        return this.entityType;
    }

    public void setEntityType(EntityType<?> entityId) {
        this.entityType = entityId;
    }

    public double ration() {
        double s = 0.0;
        for (ItemStack ss : this.getOut()) {
            s += (double)ss.func_190916_E();
        }
        return s / (double)this.getIn().func_190916_E();
    }

    public List<Item> toFlatOut() {
        ArrayList<Item> result = new ArrayList<Item>();
        for (ItemStack s : this.getOut()) {
            for (int i = 0; i < s.func_190916_E(); ++i) {
                result.add(s.func_77973_b());
            }
        }
        return result;
    }

    public static CompoundNBT toNBT(ReversedRecipe recipe) {
        CompoundNBT recipeNBT = new CompoundNBT();
        recipeNBT.func_218657_a("i", (INBT)StringNBT.func_229705_a_((String)recipe.getIn().toString()));
        recipeNBT.func_218657_a("o", (INBT)recipe.getOut().stream().map(Utils::toString).map(StringNBT::func_229705_a_).collect(ListNBT::new, AbstractList::add, AbstractCollection::addAll));
        return recipeNBT;
    }

    public static ReversedRecipe asNBT(CompoundNBT recipeNBT) {
        String i = recipeNBT.func_74779_i("i");
        if (i.isEmpty()) {
            return null;
        }
        ListNBT o = (ListNBT)recipeNBT.func_74781_a("o");
        return new ReversedRecipe(Utils.asString(i), (List)o.stream().map(INBT::func_150285_a_).map(Utils::asString).collect(Collectors.toCollection(NonNullList::func_191196_a)));
    }

    public static ReversedRecipe asJson(JsonElement json) {
        JsonObject jsonObject = json.getAsJsonObject();
        ReversedRecipe reversedRecipe = new ReversedRecipe(Utils.asString(jsonObject.get("in").getAsString()), (List)StreamSupport.stream(jsonObject.get("out").getAsJsonArray().spliterator(), false).map(JsonElement::getAsString).map(Utils::asString).collect(Collectors.toCollection(NonNullList::func_191196_a)));
        if (jsonObject.has("xp")) {
            reversedRecipe.experience = jsonObject.get("xp").getAsFloat();
        }
        return reversedRecipe;
    }

    public static JsonElement toJson(ReversedRecipe recipe) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("in", Utils.toString(recipe.getIn()));
        jsonObject.add("out", (JsonElement)recipe.getOut().stream().map(Utils::toString).collect(JsonArray::new, JsonArray::add, (l, r) -> {}));
        if (recipe.experience != 0.0f) {
            jsonObject.addProperty("xp", (Number)Float.valueOf(recipe.experience));
        }
        return jsonObject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReversedRecipe that = (ReversedRecipe)o;
        return this.id.equals(that.id);
    }

    public String toString() {
        return ReversedRecipe.toNBT(this).toString();
    }

    public static class Id {
        private final Item in;
        private final Set<Item> out;
        private final int hashCode;
        private List<Item> outList;

        public Id(Item in, Set<Item> out) {
            this.in = in;
            this.out = out;
            this.hashCode = Objects.hash(in, out);
        }

        public Item getIn() {
            return this.in;
        }

        public Set<Item> getOut() {
            return this.out;
        }

        public Item getOut(int index) {
            if (index < this.out.size()) {
                return this.getOutList().get(index);
            }
            return null;
        }

        public List<Item> getOutList() {
            if (this.outList == null) {
                this.outList = new ArrayList<Item>(this.out);
            }
            return this.outList;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            Id that = (Id)o;
            return Objects.equals(this.in, that.in) && Objects.equals(this.out, that.out);
        }
    }
}

