/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.cursegame.minecraft.dt.recipe.ReversedRecipe;

public class ReversedRecipeOverride {
    private Action action;
    private ReversedRecipe recipe;
    private ReversedRecipe update;

    public ReversedRecipeOverride(Action action, ReversedRecipe recipe, ReversedRecipe update) {
        this.action = action;
        this.recipe = recipe;
        this.update = update;
    }

    public Action getAction() {
        return this.action;
    }

    public ReversedRecipe getRecipe() {
        return this.recipe;
    }

    public ReversedRecipe getUpdate() {
        return this.update;
    }

    public static ReversedRecipeOverride asJson(JsonElement json) {
        JsonObject jsonObject = json.getAsJsonObject();
        return new ReversedRecipeOverride(Action.valueOf(jsonObject.get("action").getAsString()), ReversedRecipe.asJson(jsonObject.get("recipe")), ReversedRecipe.asJson(jsonObject.get("update")));
    }

    public static JsonElement toJson(ReversedRecipeOverride recipeOverride) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("action", recipeOverride.action.toString());
        jsonObject.add("recipe", ReversedRecipe.toJson(recipeOverride.recipe));
        if (recipeOverride.update != null) {
            jsonObject.add("update", ReversedRecipe.toJson(recipeOverride.update));
        }
        return jsonObject;
    }

    public String toString() {
        return ReversedRecipeOverride.toJson(this).toString();
    }

    public static enum Action {
        SHOW,
        HIDE,
        SWAP;

    }
}

