/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.registry;

import net.minecraft.block.Block;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemTier;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.cursegame.minecraft.dt.block.BlockCrystalTable;
import org.cursegame.minecraft.dt.block.BlockDT;
import org.cursegame.minecraft.dt.block.BlockDTWork;
import org.cursegame.minecraft.dt.block.BlockDTWorkChest;
import org.cursegame.minecraft.dt.block.BlockDTWorkChestBlaze;
import org.cursegame.minecraft.dt.block.BlockDTWorkChestFlame;
import org.cursegame.minecraft.dt.gui.ContainerDT;
import org.cursegame.minecraft.dt.item.ItemBase;
import org.cursegame.minecraft.dt.item.ItemBlockCrystalTable;
import org.cursegame.minecraft.dt.item.ItemBlockDT;
import org.cursegame.minecraft.dt.item.ItemDisk;
import org.cursegame.minecraft.dt.item.ItemVial;
import org.cursegame.minecraft.dt.registry.ModBlocks;
import org.cursegame.minecraft.dt.tileentity.TileEntityCrystalTable;
import org.cursegame.minecraft.dt.tileentity.TileEntityDT;
import org.cursegame.minecraft.dt.tileentity.TileEntityDTWork;
import org.cursegame.minecraft.dt.tileentity.TileEntityDTWorkChest;
import org.cursegame.minecraft.dt.tileentity.TileEntityDTWorkChestBlaze;
import org.cursegame.minecraft.dt.tileentity.TileEntityDTWorkChestFlame;

@Mod.EventBusSubscriber(modid="corail_dt", bus=Mod.EventBusSubscriber.Bus.MOD)
public class RegistryHandler {
    public static final int[] dusts = new int[]{0, 1, 2, 3, 4, 5};
    public static final int[] bases = new int[]{0, 1, 2, 3, 4, 5};
    public static final int[] vials = new int[]{0, 1, 2, 3, 4};

    public static String getDustName(int dust) {
        return "dust_" + dust;
    }

    public static String getDiskName(int dust, int base) {
        return "disk_" + dust + "_" + base;
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().register((IForgeRegistryEntry)RegistryHandler.withName(new BlockDT(), "dt"));
        event.getRegistry().register((IForgeRegistryEntry)RegistryHandler.withName(new BlockDTWork(), "dt_w"));
        event.getRegistry().register((IForgeRegistryEntry)RegistryHandler.withName(new BlockDTWorkChest(), "dt_w_c"));
        event.getRegistry().register((IForgeRegistryEntry)RegistryHandler.withName(new BlockDTWorkChestFlame(), "dt_w_c_f"));
        event.getRegistry().register((IForgeRegistryEntry)RegistryHandler.withName(new BlockDTWorkChestBlaze(), "dt_w_c_b"));
        event.getRegistry().register((IForgeRegistryEntry)RegistryHandler.withName(new BlockCrystalTable(), "crystal_table"));
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)RegistryHandler.withName(new ItemBlockDT(ModBlocks.DT), ModBlocks.DT.getRegistryName()), (Item)RegistryHandler.withName(new ItemBlockDT(ModBlocks.DT_W), ModBlocks.DT_W.getRegistryName()), (Item)RegistryHandler.withName(new ItemBlockDT(ModBlocks.DT_W_C), ModBlocks.DT_W_C.getRegistryName()), (Item)RegistryHandler.withName(new ItemBlockDT(ModBlocks.DT_W_C_F), ModBlocks.DT_W_C_F.getRegistryName()), (Item)RegistryHandler.withName(new ItemBlockDT(ModBlocks.DT_W_C_B), ModBlocks.DT_W_C_B.getRegistryName())});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{RegistryHandler.withName(ItemBase.of("leather_strip"), "leather_strip")});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{RegistryHandler.withName(ItemBase.of("essence"), "essence")});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{RegistryHandler.withName(new ItemVial(0), "vial_0"), RegistryHandler.withName(new ItemVial(1), "vial_1"), RegistryHandler.withName(new ItemVial(2), "vial_2"), RegistryHandler.withName(new ItemVial(3), "vial_3"), RegistryHandler.withName(new ItemVial(4), "vial_4")});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)RegistryHandler.withName(new ItemBlockCrystalTable(ModBlocks.CRYSTAL_TABLE), ModBlocks.CRYSTAL_TABLE.getRegistryName())});
        for (int dust : dusts) {
            String dustName = RegistryHandler.getDustName(dust);
            event.getRegistry().register((IForgeRegistryEntry)RegistryHandler.withName(ItemBase.of(dustName), dustName));
            for (int base : bases) {
                String diskName = RegistryHandler.getDiskName(dust, base);
                event.getRegistry().register((IForgeRegistryEntry)RegistryHandler.withName(new ItemDisk(diskName, ItemTier.values()[dust], ItemTier.values()[base]), diskName));
            }
        }
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new SoundEvent[]{RegistryHandler.fromSound("dt_success"), RegistryHandler.fromSound("dt_progress")});
    }

    @SubscribeEvent
    public static void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new TileEntityType[]{RegistryHandler.withName(TileEntityType.Builder.func_223042_a(TileEntityDT::new, (Block[])new Block[]{ModBlocks.DT}).func_206865_a(null), "dt"), RegistryHandler.withName(TileEntityType.Builder.func_223042_a(TileEntityDTWork::new, (Block[])new Block[]{ModBlocks.DT_W}).func_206865_a(null), "dt_w"), RegistryHandler.withName(TileEntityType.Builder.func_223042_a(TileEntityDTWorkChest::new, (Block[])new Block[]{ModBlocks.DT_W_C}).func_206865_a(null), "dt_w_c"), RegistryHandler.withName(TileEntityType.Builder.func_223042_a(TileEntityDTWorkChestFlame::new, (Block[])new Block[]{ModBlocks.DT_W_C_F}).func_206865_a(null), "dt_w_c_f"), RegistryHandler.withName(TileEntityType.Builder.func_223042_a(TileEntityDTWorkChestBlaze::new, (Block[])new Block[]{ModBlocks.DT_W_C_B}).func_206865_a(null), "dt_w_c_b")});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new TileEntityType[]{RegistryHandler.withName(TileEntityType.Builder.func_223042_a(TileEntityCrystalTable::new, (Block[])new Block[]{ModBlocks.CRYSTAL_TABLE}).func_206865_a(null), "crystal_table")});
    }

    @SubscribeEvent
    public static void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new ContainerType[]{RegistryHandler.withName(IForgeContainerType.create(ContainerDT::new), "dt")});
    }

    private static SoundEvent fromSound(String name) {
        ResourceLocation rl = new ResourceLocation("corail_dt", name);
        return (SoundEvent)new SoundEvent(rl).setRegistryName(rl);
    }

    private static <T extends IForgeRegistryEntry<T>> T withName(T entry, String name) {
        return (T)((IForgeRegistryEntry)entry.setRegistryName(new ResourceLocation("corail_dt", name)));
    }

    private static <T extends IForgeRegistryEntry<T>> T withName(T entry, ResourceLocation locName) {
        return (T)((IForgeRegistryEntry)entry.setRegistryName(locName));
    }
}

