/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.tileentity;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cursegame.minecraft.dt.util.Utils;

public interface DTContainer {
    default public String getId() {
        return Integer.toHexString(this.hashCode());
    }

    public World getWorld();

    public BlockPos getPos();

    public IInventory getInventoryI();

    public IInventory getInventoryO();

    public IInventory getInventoryW();

    public IInventory getInventoryV();

    public Mode getMode();

    default public ItemStack getItemStack() {
        return this.getInventoryI().func_70301_a(0);
    }

    default public void setItemStack(ItemStack stack) {
        this.getInventoryI().func_70299_a(0, stack);
    }

    default public ItemStack getDiskStack() {
        return this.getInventoryW().func_70301_a(0);
    }

    default public void setDiskStack(ItemStack stack) {
        this.getInventoryW().func_70299_a(0, stack);
    }

    default public ItemStack getBookStack() {
        return this.getInventoryW().func_70301_a(1);
    }

    default public void setBookStack(ItemStack stack) {
        this.getInventoryW().func_70299_a(1, stack);
    }

    default public ItemStack getVialStack() {
        return this.getInventoryW().func_70301_a(2);
    }

    default public void setVialStack(ItemStack stack) {
        this.getInventoryW().func_70299_a(2, stack);
    }

    default public ItemStack getFuelStack() {
        return this.getInventoryW().func_70301_a(3);
    }

    default public void setFuelStack(ItemStack stack) {
        this.getInventoryW().func_70299_a(3, stack);
    }

    default public ItemStack getBondStack() {
        return this.getInventoryW().func_70301_a(4);
    }

    default public void setBondStack(ItemStack stack) {
        this.getInventoryW().func_70299_a(4, stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public boolean isStateStarted() {
        return Utils.getValue(this.getState(), 0);
    }

    default public void setStateStarted(boolean b) {
        this.setState(Utils.setValue(this.getState(), 0, b));
    }

    @OnlyIn(value=Dist.CLIENT)
    default public boolean isStateStartedAutomatically() {
        return Utils.getValue(this.getState(), 1);
    }

    default public void setStateStartedAutomatically(boolean b) {
        this.setState(Utils.setValue(this.getState(), 1, b));
    }

    @OnlyIn(value=Dist.CLIENT)
    default public boolean isStartEnabled() {
        return Utils.getValue(this.getState(), 2);
    }

    default public void setStartEnabled(boolean b) {
        this.setState(Utils.setValue(this.getState(), 2, b));
    }

    @OnlyIn(value=Dist.CLIENT)
    default public boolean isStartAutomationEnabled() {
        return Utils.getValue(this.getState(), 3);
    }

    default public boolean setStartAutomationEnabled(boolean b) {
        return this.setState(Utils.setValue(this.getState(), 3, b));
    }

    @OnlyIn(value=Dist.CLIENT)
    default public boolean isFuelFlame() {
        return Utils.getValue(this.getState(), 4);
    }

    default public void setFuelFlame(boolean b) {
        this.setState(Utils.setValue(this.getState(), 4, b));
    }

    default public int getStateProgressMax() {
        return 63;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public int getStateProgress() {
        return Utils.getValue(this.getState(), 8, 6);
    }

    default public void setStateProgress(int v) {
        this.setState(Utils.setValue(this.getState(), 8, 6, v));
    }

    default public int getStateTemperatureMax() {
        return 64;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public int getStateTemperature() {
        return Utils.getValue(this.getState(), 14, 6);
    }

    default public boolean setStateTemperature(int v) {
        return this.setState(Utils.setValue(this.getState(), 14, 6, v));
    }

    default public int getStateBurnMax() {
        return 63;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public int getStateBurn() {
        return Utils.getValue(this.getState(), 20, 6);
    }

    default public boolean setStateBurn(int v) {
        return this.setState(Utils.setValue(this.getState(), 20, 6, v));
    }

    default public int getStateFuelMax() {
        return 63;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public int getStateFuel() {
        return Utils.getValue(this.getState(), 26, 6);
    }

    default public boolean setStateFuel(int v) {
        return this.setState(Utils.setValue(this.getState(), 26, 6, v));
    }

    @OnlyIn(value=Dist.CLIENT)
    default public boolean isRecipeAvailable() {
        return Utils.getValue(this.getRecipeState(), 0);
    }

    default public void setRecipeAvailable(boolean b) {
        this.setRecipeState(Utils.setValue(this.getRecipeState(), 0, b));
    }

    @OnlyIn(value=Dist.CLIENT)
    default public boolean isRecipeAmbiguous() {
        return Utils.getValue(this.getRecipeState(), 1);
    }

    default public void setRecipeAmbiguous(boolean b) {
        this.setRecipeState(Utils.setValue(this.getRecipeState(), 1, b));
    }

    @OnlyIn(value=Dist.CLIENT)
    default public boolean isRecipeDisabled() {
        return Utils.getValue(this.getRecipeState(), 2);
    }

    default public void setRecipeDisabled(boolean b) {
        this.setRecipeState(Utils.setValue(this.getRecipeState(), 2, b));
    }

    @OnlyIn(value=Dist.CLIENT)
    default public boolean isRecipeRequireXp() {
        return Utils.getValue(this.getRecipeState(), 3);
    }

    default public void setRecipeRequireXp(boolean b) {
        this.setRecipeState(Utils.setValue(this.getRecipeState(), 3, b));
    }

    @OnlyIn(value=Dist.CLIENT)
    default public boolean isRecipeProduceXp() {
        return Utils.getValue(this.getRecipeState(), 4);
    }

    default public void setRecipeProduceXp(boolean b) {
        this.setRecipeState(Utils.setValue(this.getRecipeState(), 4, b));
    }

    @OnlyIn(value=Dist.CLIENT)
    default public boolean isRecipeXpInflation() {
        return Utils.getValue(this.getRecipeState(), 5);
    }

    default public void setRecipeXpInflation(boolean b) {
        this.setRecipeState(Utils.setValue(this.getRecipeState(), 5, b));
    }

    @OnlyIn(value=Dist.CLIENT)
    default public boolean isRecipeXpDeflation() {
        return Utils.getValue(this.getRecipeState(), 6);
    }

    default public void setRecipeXpDeflation(boolean b) {
        this.setRecipeState(Utils.setValue(this.getRecipeState(), 6, b));
    }

    @OnlyIn(value=Dist.CLIENT)
    default public boolean isRecipeNestedContent() {
        return Utils.getValue(this.getRecipeState(), 7);
    }

    default public void setRecipeNestedContent(boolean b) {
        this.setRecipeState(Utils.setValue(this.getRecipeState(), 7, b));
    }

    @OnlyIn(value=Dist.CLIENT)
    default public int getRecipeItemInput() {
        return Utils.getValue(this.getRecipeState(), 8, 6);
    }

    default public void setRecipeItemInput(int number) {
        this.setRecipeState(Utils.setValue(this.getRecipeState(), 8, 6, number));
    }

    @OnlyIn(value=Dist.CLIENT)
    default public int getRecipeDiskInput() {
        return Utils.getValue(this.getRecipeState(), 14, 6);
    }

    default public void setRecipeDiskInput(int number) {
        this.setRecipeState(Utils.setValue(this.getRecipeState(), 14, 6, number));
    }

    @OnlyIn(value=Dist.CLIENT)
    default public int getRecipeBookInput() {
        return Utils.getValue(this.getRecipeState(), 20, 6);
    }

    default public void setRecipeBookInput(int number) {
        this.setRecipeState(Utils.setValue(this.getRecipeState(), 20, 6, number));
    }

    @OnlyIn(value=Dist.CLIENT)
    default public int getRecipeVialInput() {
        return Utils.getValue(this.getRecipeState(), 26, 6);
    }

    default public void setRecipeVialInput(int number) {
        this.setRecipeState(Utils.setValue(this.getRecipeState(), 26, 6, number));
    }

    public int getState();

    public boolean setState(int var1);

    public int getRecipeState();

    public boolean setRecipeState(int var1);

    public void requestUpdateRecipe();

    public void disarm(PlayerEntity var1);

    public boolean canInteract(PlayerEntity var1);

    public IIntArray newTrackedData();

    public static class Mode {
        private int mode;

        private Mode(int mode) {
            this.mode = mode;
        }

        public int getMode() {
            return this.mode;
        }

        public static Mode of(int mode) {
            return new Mode(0);
        }

        public Mode setWSlots() {
            this.mode = Utils.setValue(this.mode, 0, true);
            return this;
        }

        public boolean hasWSlots() {
            return Utils.getValue(this.mode, 0);
        }

        public Mode setISlots() {
            this.mode = Utils.setValue(this.mode, 1, true);
            return this;
        }

        public boolean hasISlots() {
            return Utils.getValue(this.mode, 1);
        }

        public Mode setOSlots() {
            this.mode = Utils.setValue(this.mode, 2, true);
            return this;
        }

        public boolean hasOSlots() {
            return Utils.getValue(this.mode, 2);
        }

        public Mode setFuelFlame() {
            this.mode = Utils.setValue(this.mode, 3, true);
            return this;
        }

        public boolean hasFuelFlame() {
            return Utils.getValue(this.mode, 3);
        }

        public Mode setFuelBlaze() {
            this.mode = Utils.setValue(this.mode, 4, true);
            return this;
        }

        public boolean hasFuelBlaze() {
            return Utils.getValue(this.mode, 4);
        }

        public boolean hasAutomation() {
            return this.hasFuelBlaze() || this.hasFuelFlame();
        }
    }
}

