/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.tileentity;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cursegame.minecraft.dt.block.BlockCrystalTable;
import org.cursegame.minecraft.dt.registry.ModTileEntityTypes;
import org.cursegame.minecraft.dt.tileentity.TileEntity;

public class TileEntityCrystalTable
extends TileEntity
implements ITickableTileEntity {
    private float charge;
    private LinkedList<ExperienceOrbEntity> entities = new LinkedList();
    private static final int MAX_ORB_COUNT = 512;
    private final int orbXp = 7;
    private static Random random = new Random(31100L);
    private static double velocity = 0.02;
    private static double acceleration = 0.002;
    private double xMin;
    private double xMax;
    private double yMin;
    private double yMax;
    private double zMin;
    private double zMax;
    private double cX;
    private double cY;
    private double cZ;
    private double lX;
    private double lY;
    private double lZ;

    public TileEntityCrystalTable() {
        super(ModTileEntityTypes.CRYSTAL_TABLE);
    }

    public float getCharge() {
        return this.charge;
    }

    public float setCharge(float charge) {
        this.charge = charge;
        return charge;
    }

    public float addCharge(float charge) {
        this.charge += charge;
        return charge;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        if (tag.func_74764_b("Charge")) {
            this.charge = tag.func_74775_l("Charge").func_74760_g("Value");
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        this.saveSharedTag(nbt);
        return nbt;
    }

    protected void saveSharedTag(CompoundNBT tag) {
        if (this.charge > 0.0f) {
            CompoundNBT compoundTag = tag.func_74775_l("Charge");
            compoundTag.func_74776_a("Value", this.charge);
            tag.func_218657_a("Charge", (INBT)compoundTag);
        }
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT updateTag = super.func_189517_E_();
        this.saveSharedTag(updateTag);
        return updateTag;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 13, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.handleUpdateTag(null, pkt.func_148857_g());
    }

    @Override
    protected ITextComponent getDefaultName() {
        return new TranslationTextComponent("corail_dt.block.crystal_table");
    }

    public List<? extends Entity> getCachedEntities() {
        return this.entities;
    }

    public void func_73660_a() {
        if (this.field_145850_b == null) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            this.tickClient();
        } else {
            this.tickServer();
        }
    }

    private void tickServer() {
        int orbCount;
        if (this.entities.size() < 15 && (orbCount = this.getOrbCount(this.charge)) > this.entities.size()) {
            BlockState blockState;
            ExperienceOrbEntity experienceOrb = new ExperienceOrbEntity(EntityType.field_200807_u, this.field_145850_b);
            experienceOrb.func_213293_j(this.random(0.5), this.random(0.5), this.random(0.5));
            experienceOrb.func_70107_b((double)this.field_174879_c.func_177958_n() + 0.5 + this.random(0.5), (double)this.field_174879_c.func_177956_o() + 0.5 + this.random(0.5), (double)this.field_174879_c.func_177952_p() + 0.5 + this.random(0.5));
            experienceOrb.field_70530_e = 7;
            this.entities.add(experienceOrb);
            int ll = this.entities.size();
            if (ll > 15) {
                ll = 15;
            }
            if ((Integer)(blockState = this.func_195044_w()).func_177229_b((Property)BlockCrystalTable.LEVEL) != ll) {
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)blockState.func_206870_a((Property)BlockCrystalTable.LEVEL, (Comparable)Integer.valueOf(ll)), 3);
            }
        }
    }

    public void spawnOrbs(World world) {
        int sample = (int)this.charge / 512;
        int min = 7;
        if (sample < min) {
            sample = min;
        }
        int top = sample - min;
        double power = Math.log(1.0f + this.charge / 7.0f) / 5.0;
        while (this.charge > 0.0f) {
            ExperienceOrbEntity experienceOrbEntity = new ExperienceOrbEntity(EntityType.field_200807_u, world);
            experienceOrbEntity.func_213293_j(this.random(power), this.random(power), this.random(power));
            experienceOrbEntity.func_70107_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
            int xp = min + random.nextInt(top + 1);
            if ((float)xp > this.charge) {
                xp = (int)this.charge;
                this.charge = 0.0f;
            } else {
                this.charge -= (float)xp;
            }
            experienceOrbEntity.field_70530_e = xp;
            world.func_217376_c((Entity)experienceOrbEntity);
        }
    }

    private int getOrbCount(float charge) {
        return (int)(charge / 7.0f);
    }

    private double random(double max) {
        return ((double)random.nextFloat() - 0.5) * max;
    }

    protected void readShape(BlockState state) {
        VoxelShape shape = BlockCrystalTable.SHELL;
        AxisAlignedBB aabb = shape.func_197752_a().func_186664_h(0.05);
        this.xMin = aabb.field_72340_a;
        this.yMin = aabb.field_72338_b;
        this.zMin = aabb.field_72339_c;
        this.xMax = aabb.field_72336_d;
        this.yMax = aabb.field_72337_e;
        this.zMax = aabb.field_72334_f;
        this.lX = this.xMax - this.xMin;
        this.lY = this.yMax - this.yMin;
        this.lZ = this.zMax - this.zMin;
        this.cX = (this.xMin + this.xMax) / 2.0;
        this.cY = (this.yMin + this.yMax) / 2.0;
        this.cZ = (this.zMin + this.zMax) / 2.0;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickClient() {
        int orbCount;
        if (this.lX == 0.0 || this.lY == 0.0 || this.lZ == 0.0) {
            this.readShape(this.func_195044_w());
        }
        if (this.entities.size() < 512 && (orbCount = this.getOrbCount(this.charge)) > this.entities.size()) {
            ExperienceOrbEntity e2 = new ExperienceOrbEntity(EntityType.field_200807_u, this.field_145850_b);
            e2.field_70169_q = this.cX + this.random(this.lX);
            e2.field_70167_r = this.cY + this.random(this.lY);
            e2.field_70166_s = this.cZ + this.random(this.lZ);
            e2.field_70142_S = this.random(velocity);
            e2.field_70137_T = this.random(velocity);
            e2.field_70136_U = this.random(velocity);
            this.entities.add(e2);
        }
        this.entities.forEach(e -> {
            --e.field_70533_a;
            double px = e.field_70169_q;
            double py = e.field_70167_r;
            double pz = e.field_70166_s;
            double vx = e.field_70142_S;
            double vy = e.field_70137_T;
            double vz = e.field_70136_U;
            if ((double)random.nextFloat() < 0.01) {
                if (Math.abs(vx += this.random(acceleration)) > velocity / 1.1) {
                    vx /= 1.1;
                }
                if (Math.abs(vy += this.random(acceleration)) > velocity / 1.1) {
                    vy /= 1.1;
                }
                if (Math.abs(vz += this.random(acceleration)) > velocity / 1.1) {
                    vz /= 1.1;
                }
            }
            px += vx;
            py += vy;
            pz += vz;
            if (px < this.xMin) {
                px = this.xMin;
                vx *= -1.0;
            }
            if (px > this.xMax) {
                px = this.xMax;
                vx *= -1.0;
            }
            if (py < this.yMin) {
                py = this.yMin;
                vy *= -1.0;
            }
            if (py > this.yMax) {
                py = this.yMax;
                vy *= -1.0;
            }
            if (pz < this.zMin) {
                pz = this.zMin;
                vz *= -1.0;
            }
            if (pz > this.zMax) {
                pz = this.zMax;
                vz *= -1.0;
            }
            e.field_70169_q = px;
            e.field_70167_r = py;
            e.field_70166_s = pz;
            e.field_70142_S = vx;
            e.field_70137_T = vy;
            e.field_70136_U = vz;
        });
    }
}

