/*
 * Decompiled with CFR 0.152.
 */
package org.cursegame.minecraft.dt.tileentity;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.logging.log4j.util.Supplier;
import org.cursegame.minecraft.dt.ModDT;
import org.cursegame.minecraft.dt.block.BlockDTBase;
import org.cursegame.minecraft.dt.gui.ContainerDT;
import org.cursegame.minecraft.dt.tileentity.DTContainer;
import org.cursegame.minecraft.dt.tileentity.DTContainerBase;
import org.cursegame.minecraft.dt.tileentity.DTContainerProvider;
import org.cursegame.minecraft.dt.tileentity.DTController;
import org.cursegame.minecraft.dt.tileentity.DTControllerProvider;
import org.cursegame.minecraft.dt.tileentity.TileEntity;
import org.cursegame.minecraft.dt.util.I18N;

public abstract class TileEntityDTBase
extends TileEntity
implements DTContainerProvider,
DTControllerProvider,
ITickableTileEntity,
IContainerProvider {
    private final DTContainerBase dtContainer = this.createContainer();
    private int playerIn;
    private int lastPlayerIn;
    private int xpToSpawn;
    private final LazyOptional<IItemHandlerModifiable> iCapability = LazyOptional.of(() -> new InvWrapper((IInventory)this.dtContainer.getInventoryI()));
    private final LazyOptional<IItemHandlerModifiable> oCapability = LazyOptional.of(() -> new InvWrapper((IInventory)this.dtContainer.getInventoryO()));
    private final LazyOptional<IItemHandlerModifiable> wCapability = LazyOptional.of(() -> new InvWrapper((IInventory)this.dtContainer.getInventoryW()));
    private static final int inventoryVersion = 1;

    protected TileEntityDTBase(TileEntityType<?> typeIn) {
        super(typeIn);
    }

    @Override
    protected ITextComponent getDefaultName() {
        return null;
    }

    protected abstract DTContainerBase createContainer();

    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
        return new ContainerDT(id, playerInventory, this.dtContainer);
    }

    private ServerPlayerEntity getPlayer(int playerId) {
        if (playerId == 0) {
            return null;
        }
        for (PlayerEntity player : this.field_145850_b.func_217369_A()) {
            if (player.func_145782_y() != playerId) continue;
            return (ServerPlayerEntity)player;
        }
        return null;
    }

    private Optional<ServerPlayerEntity> getPlayerIfExist(Integer ... playerIds) {
        return Stream.of(playerIds).map(this::getPlayer).filter(Objects::nonNull).findFirst();
    }

    @Override
    public DTContainerBase getContainer(PlayerEntity player) {
        if (this.field_145850_b == null) {
            return null;
        }
        if (this.field_145850_b.field_72995_K) {
            return this.dtContainer;
        }
        if (this.playerIn != 0 && this.playerIn != player.func_145782_y() && !player.func_184812_l_()) {
            I18N.MESSAGE_ENGAGED.sendTo(player, this.func_145748_c_(), this.getPlayerIfExist(this.playerIn).map(p -> p.func_145748_c_().getString()).orElse("[hidden]]"));
            return null;
        }
        if (this.playerIn != player.func_145782_y()) {
            this.dtContainer.updateRecipeFromPlayerRecipeBook((ServerPlayerEntity)player);
            this.dtContainer.requestUpdateRecipe();
            this.func_70296_d();
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = this::getId;
            supplierArray[1] = () -> ((PlayerEntity)player).func_145782_y();
            ModDT.LOGGER.debug("Instance {} engaged by {}", supplierArray);
        }
        this.lastPlayerIn = this.playerIn = player.func_145782_y();
        return this.dtContainer;
    }

    public void func_145843_s() {
        super.func_145843_s();
        ModDT.LOGGER.debug("Instance {} destroyed", new Supplier[]{this::getId});
    }

    @Override
    public DTController getController(ServerPlayerEntity player) {
        if (this.playerIn != player.func_145782_y()) {
            return null;
        }
        return this.dtContainer;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
        if (!this.field_145846_f && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == Direction.DOWN) {
                return this.oCapability.cast();
            }
            Direction front = (Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)BlockDTBase.FACING);
            if (side == Direction.UP || side == front.func_176746_e()) {
                return this.iCapability.cast();
            }
            if (side == front.func_176734_d() || side == front.func_176735_f()) {
                return this.wCapability.cast();
            }
        }
        return LazyOptional.empty();
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("version", 1);
        compound.func_218657_a("input", (INBT)this.dtContainer.getInventoryI().save());
        if (this.dtContainer.getMode().hasOSlots()) {
            compound.func_218657_a("output", (INBT)this.dtContainer.getInventoryO().save());
        }
        if (this.dtContainer.getMode().hasWSlots()) {
            compound.func_218657_a("working", (INBT)this.dtContainer.getInventoryW().save());
        }
        if (this.dtContainer.getMode().hasFuelFlame()) {
            compound.func_74768_a("temperature", this.dtContainer.temperature);
            compound.func_74768_a("burnTime", this.dtContainer.fuelBurnTime);
            compound.func_74768_a("burnTimeTotal", this.dtContainer.fuelBurnTimeTotal);
        }
        if (this.dtContainer.getMode().hasFuelBlaze()) {
            compound.func_74768_a("fuelLoad", this.dtContainer.fuelLoad);
            compound.func_74768_a("fuelRest", this.dtContainer.fuelRest);
        }
        compound.func_74768_a("xp", this.xpToSpawn);
        return compound;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        int version = tag.func_74762_e("version");
        this.dtContainer.getInventoryI().load(tag.func_150295_c("input", 10));
        if (this.dtContainer.getMode().hasOSlots()) {
            this.dtContainer.getInventoryO().load(tag.func_150295_c("output", 10));
        }
        if (this.dtContainer.getMode().hasWSlots()) {
            this.dtContainer.getInventoryW().load(tag.func_150295_c("working", 10));
        }
        if (this.dtContainer.getMode().hasFuelFlame()) {
            this.dtContainer.temperature = tag.func_74762_e("temperature");
            this.dtContainer.fuelBurnTime = tag.func_74762_e("burnTime");
            this.dtContainer.fuelBurnTimeTotal = tag.func_74762_e("burnTimeTotal");
        }
        if (this.dtContainer.getMode().hasFuelBlaze()) {
            this.dtContainer.fuelLoad = tag.func_74762_e("fuelLoad");
            this.dtContainer.fuelRest = tag.func_74762_e("fuelRest");
        }
        this.xpToSpawn = tag.func_74762_e("xp");
    }

    public void dropContents(World level, BlockPos blockPos) {
        Stream.of(this.dtContainer.getInventoryI(), this.dtContainer.getInventoryW(), this.dtContainer.getInventoryO()).flatMap(c -> c.func_233543_f_().stream()).forEach(this.dtContainer::spawnItem);
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.field_145846_f) {
            return;
        }
        this.spawnXp();
        this.dtContainer.tick();
    }

    private void spawnXp() {
        int mendingLevel;
        ItemStack itemStack;
        if (this.field_145850_b.func_82737_E() % 2L != 0L) {
            return;
        }
        if (this.xpToSpawn > 0 && (itemStack = this.dtContainer.getDiskStack()).func_77951_h() && (mendingLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185296_A, (ItemStack)this.dtContainer.getDiskStack())) > 0) {
            int repairs = Math.min((int)((float)Math.min(this.xpToSpawn, 7) * itemStack.getXpRepairRatio()), itemStack.func_77952_i());
            itemStack.func_196085_b(itemStack.func_77952_i() - repairs);
            this.xpToSpawn -= (int)((float)repairs / itemStack.getXpRepairRatio());
        }
        while (this.field_145850_b.field_73012_v.nextDouble() < 0.66 && this.xpToSpawn != 0) {
            int xp = Math.min(this.xpToSpawn, (1 + this.field_145850_b.field_73012_v.nextInt(10)) * 7);
            ExperienceOrbEntity experienceOrb = new ExperienceOrbEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 0.5, xp);
            experienceOrb.func_213293_j(this.field_145850_b.field_73012_v.nextDouble() * 0.2 - 0.1, this.field_145850_b.field_73012_v.nextDouble() * 3.0, this.field_145850_b.field_73012_v.nextDouble() * 0.2 - 0.1);
            this.field_145850_b.func_217376_c((Entity)experienceOrb);
            this.xpToSpawn -= xp;
            if (!((double)this.xpToSpawn < 1.0)) continue;
            this.xpToSpawn = 0;
        }
    }

    protected class BaseDTContainer
    extends DTContainerBase {
        protected BaseDTContainer(DTContainer.Mode mode) {
            super(mode);
        }

        @Override
        public World getWorld() {
            return TileEntityDTBase.this.field_145850_b;
        }

        @Override
        public BlockPos getPos() {
            return TileEntityDTBase.this.field_174879_c;
        }

        @Override
        protected void spawnXp(int xp) {
            TileEntityDTBase.this.xpToSpawn = TileEntityDTBase.this.xpToSpawn + xp / 100;
        }

        @Override
        protected void spawnItem(ItemStack itemStack) {
            BlockPos pos = TileEntityDTBase.this.field_174879_c.func_177984_a();
            ItemEntity itemEntity = new ItemEntity(TileEntityDTBase.this.field_145850_b, (double)pos.func_177958_n() + 0.2 + ((TileEntityDTBase)TileEntityDTBase.this).field_145850_b.field_73012_v.nextDouble() * 0.6, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.2 + ((TileEntityDTBase)TileEntityDTBase.this).field_145850_b.field_73012_v.nextDouble() * 0.6, itemStack);
            itemEntity.func_213317_d(Vector3d.field_186680_a);
            TileEntityDTBase.this.field_145850_b.func_217376_c((Entity)itemEntity);
        }

        @Override
        public void disarm(PlayerEntity player) {
            int entityId = player.func_145782_y();
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = TileEntityDTBase.this::getId;
            supplierArray[1] = () -> ((PlayerEntity)player).func_145782_y();
            ModDT.LOGGER.debug("Instance {} disarmed by {}", supplierArray);
            if (TileEntityDTBase.this.playerIn == entityId) {
                TileEntityDTBase.this.playerIn = 0;
            }
        }

        @Override
        public boolean canInteract(PlayerEntity player) {
            if (TileEntityDTBase.this.field_145846_f) {
                return false;
            }
            if (TileEntityDTBase.this.playerIn != 0 && TileEntityDTBase.this.playerIn != player.func_145782_y()) {
                I18N.MESSAGE_ENGAGED.sendTo(player, TileEntityDTBase.this.func_145748_c_(), TileEntityDTBase.this.getPlayerIfExist(new Integer[]{TileEntityDTBase.this.playerIn}).map(p -> p.func_145748_c_().getString()).orElse("[hidden]]"));
                return false;
            }
            if (TileEntityDTBase.this.field_145850_b.func_175625_s(TileEntityDTBase.this.field_174879_c) != TileEntityDTBase.this) {
                return false;
            }
            if (player.func_70092_e((double)TileEntityDTBase.this.field_174879_c.func_177958_n() + 0.5, (double)TileEntityDTBase.this.field_174879_c.func_177956_o() + 0.5, (double)TileEntityDTBase.this.field_174879_c.func_177952_p() + 0.5) > 64.0) {
                I18N.MESSAGE_TOO_FAR.sendTo(player, new Object[0]);
                return false;
            }
            return true;
        }

        @Override
        protected ServerPlayerEntity getPlayerIn() {
            return TileEntityDTBase.this.getPlayer(TileEntityDTBase.this.playerIn);
        }

        @Override
        protected Optional<ServerPlayerEntity> getPlayer() {
            return TileEntityDTBase.this.getPlayerIfExist(new Integer[]{TileEntityDTBase.this.playerIn, TileEntityDTBase.this.lastPlayerIn});
        }
    }
}

